/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableAssemblyOS
extends CliAbstractTable {
    public CliTableAssemblyOS(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliAssemblyOSRow(reader.readNextInt(), reader.readNextInt(), reader.readNextInt()));
        }
    }

    @Override
    public DataType getRowDataType() {
        return this.toDataType();
    }

    @Override
    public DataType toDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "AssemblyOS Row", 0);
        rowDt.add(DWORD, "OSPlatformID", null);
        rowDt.add(DWORD, "OSMajorVersion", null);
        rowDt.add(DWORD, "OSMinorVersion", null);
        return new ArrayDataType((DataType)rowDt, this.numRows, rowDt.getLength());
    }

    public class CliAssemblyOSRow
    extends CliAbstractTableRow {
        public int osPlatformID;
        public int osMajorVersion;
        public int osMinorVersion;

        public CliAssemblyOSRow(int osPlatformID, int osMajorVersion, int osMinorVersion) {
            this.osPlatformID = osPlatformID;
            this.osMajorVersion = osMajorVersion;
            this.osMinorVersion = osMinorVersion;
        }

        @Override
        public String getRepresentation() {
            return String.format("Platform %d v%d.%d", this.osPlatformID, this.osMajorVersion, this.osMinorVersion);
        }
    }
}

