/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;

public class ProviderToggleAction
extends ToggleDockingAction {
    private static final String TOOL_BAR_GROUP = "ZGroup";
    private final ComponentProviderAdapter componentProvider;

    public ProviderToggleAction(ComponentProviderAdapter provider) {
        super("Show " + provider.getTitle(), provider.getOwner(), false);
        this.componentProvider = provider;
        this.setSelected(true);
        this.setToolBarData(new ToolBarData(provider.getIcon(), TOOL_BAR_GROUP));
        this.installVisibilityTracker(provider);
    }

    private void installVisibilityTracker(final ComponentProviderAdapter provider) {
        JComponent component = provider.getComponent();
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if (4L == (changeFlags & 4L)) {
                    ProviderToggleAction.this.setSelected(provider.isVisible());
                }
            }
        });
    }

    public void actionPerformed(ActionContext context) {
        this.componentProvider.setVisible(this.isSelected());
    }
}

