/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class RedoAction
extends DockingAction {
    private final VTController controller;

    public RedoAction(VTController controller) {
        super("Redo", VTPlugin.OWNER);
        this.controller = controller;
        this.setHelpLocation(new HelpLocation("Tool", "Redo"));
        String[] menuPath = new String[]{"&Edit", "&Redo"};
        String group = "ZZUndo";
        ImageIcon icon = ResourceManager.loadImage((String)"images/redo.png");
        MenuData menuData = new MenuData(menuPath, (Icon)icon, group);
        menuData.setMenuSubGroup("2Redo");
        this.setMenuBarData(menuData);
        this.setToolBarData(new ToolBarData((Icon)icon, group));
        this.setKeyBindingData(new KeyBindingData('Z', 3));
        this.setDescription("Redo");
    }

    public void actionPerformed(ActionContext programContext) {
        VTSession session = this.controller.getSession();
        if (session == null) {
            return;
        }
        VTSessionDB sessionDB = (VTSessionDB)session;
        try {
            sessionDB.redo();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, null, null, (Throwable)e);
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        VTSessionDB session = (VTSessionDB)this.controller.getSession();
        if (session != null && session.canRedo()) {
            String name = session.getName();
            this.getMenuBarData().setMenuItemName("Redo " + name);
            String tip = HTMLUtilities.toWrappedHTML((String)("Redo " + session.getRedoName()));
            this.setDescription(tip);
            return true;
        }
        this.setDescription("Redo");
        this.getMenuBarData().setMenuItemName("Redo");
        return false;
    }
}

