"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var colors_1 = require("../../state/actions/colors");
var legend_1 = require("../../state/actions/legend");
var get_chart_theme_1 = require("../../state/selectors/get_chart_theme");
var get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
var get_legend_items_1 = require("../../state/selectors/get_legend_items");
var get_legend_items_values_1 = require("../../state/selectors/get_legend_items_values");
var get_legend_size_1 = require("../../state/selectors/get_legend_size");
var get_settings_specs_1 = require("../../state/selectors/get_settings_specs");
var commons_1 = require("../../utils/commons");
var light_theme_1 = require("../../utils/themes/light_theme");
var legend_item_1 = require("./legend_item");
var style_utils_1 = require("./style_utils");
function LegendComponent(props) {
    var items = props.items, position = props.position, size = props.size, debug = props.debug, _a = props.chartTheme, chartMargins = _a.chartMargins, legend = _a.legend;
    if (items.length === 0) {
        return null;
    }
    var legendContainerStyle = style_utils_1.getLegendStyle(position, size);
    var legendListStyle = style_utils_1.getLegendListStyle(position, chartMargins, legend);
    var legendClasses = classnames_1.default('echLegend', "echLegend--" + position, {
        'echLegend--debug': debug,
    });
    var itemProps = {
        position: position,
        totalItems: items.length,
        extraValues: props.extraValues,
        showExtra: props.showExtra,
        onMouseOut: props.onItemOut,
        onMouseOver: props.onItemOver,
        onClick: props.onItemClick,
        clearTemporaryColorsAction: props.clearTemporaryColors,
        setPersistedColorAction: props.setPersistedColor,
        setTemporaryColorAction: props.setTemporaryColor,
        mouseOutAction: props.onItemOutAction,
        mouseOverAction: props.onItemOverAction,
        toggleDeselectSeriesAction: props.onToggleDeselectSeriesAction,
        colorPicker: props.colorPicker,
    };
    return (react_1.default.createElement("div", { className: legendClasses },
        react_1.default.createElement("div", { style: legendContainerStyle, className: "echLegendListContainer" },
            react_1.default.createElement("ul", { style: legendListStyle, className: "echLegendList" }, items.map(function (item, index) { return legend_item_1.renderLegendItem(item, itemProps, items.length, index); })))));
}
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({
        onToggle: legend_1.onToggleLegend,
        onToggleDeselectSeriesAction: legend_1.onToggleDeselectSeriesAction,
        onItemOutAction: legend_1.onLegendItemOutAction,
        onItemOverAction: legend_1.onLegendItemOverAction,
        clearTemporaryColors: colors_1.clearTemporaryColors,
        setTemporaryColor: colors_1.setTemporaryColor,
        setPersistedColor: colors_1.setPersistedColor,
    }, dispatch);
};
var EMPTY_DEFAULT_STATE = {
    items: [],
    position: commons_1.Position.Right,
    collapsed: false,
    extraValues: new Map(),
    debug: false,
    chartTheme: light_theme_1.LIGHT_THEME,
    size: { width: 0, height: 0 },
    showExtra: false,
};
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return EMPTY_DEFAULT_STATE;
    }
    var _a = get_settings_specs_1.getSettingsSpecSelector(state), legendPosition = _a.legendPosition, showLegend = _a.showLegend, showLegendExtra = _a.showLegendExtra, debug = _a.debug, legendColorPicker = _a.legendColorPicker, onItemOver = _a.onLegendItemOver, onItemOut = _a.onLegendItemOut, onItemClick = _a.onLegendItemClick;
    if (!showLegend) {
        return EMPTY_DEFAULT_STATE;
    }
    return {
        debug: debug,
        chartTheme: get_chart_theme_1.getChartThemeSelector(state),
        size: get_legend_size_1.getLegendSizeSelector(state),
        collapsed: state.interactions.legendCollapsed,
        items: get_legend_items_1.getLegendItemsSelector(state),
        position: legendPosition,
        showExtra: showLegendExtra,
        extraValues: get_legend_items_values_1.getLegendExtraValuesSelector(state),
        colorPicker: legendColorPicker,
        onItemOver: onItemOver,
        onItemOut: onItemOut,
        onItemClick: onItemClick,
    };
};
exports.Legend = react_redux_1.connect(mapStateToProps, mapDispatchToProps)(LegendComponent);
//# sourceMappingURL=legend.js.map