"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var chart_types_1 = require("../chart_types");
var commons_1 = require("../utils/commons");
var light_theme_1 = require("../utils/themes/light_theme");
exports.SpecTypes = Object.freeze({
    Series: 'series',
    Axis: 'axis',
    Annotation: 'annotation',
    Settings: 'settings',
});
exports.PointerEventType = Object.freeze({
    Over: 'Over',
    Out: 'Out',
});
exports.TooltipType = Object.freeze({
    VerticalCursor: 'vertical',
    Crosshairs: 'cross',
    Follow: 'follow',
    None: 'none',
});
exports.BrushAxis = Object.freeze({
    X: 'x',
    Y: 'y',
    Both: 'both',
});
exports.DEFAULT_TOOLTIP_TYPE = exports.TooltipType.VerticalCursor;
exports.DEFAULT_TOOLTIP_SNAP = true;
exports.DEFAULT_SETTINGS_SPEC = {
    id: '__global__settings___',
    chartType: chart_types_1.ChartTypes.Global,
    specType: exports.SpecTypes.Settings,
    rendering: 'canvas',
    rotation: 0,
    animateData: true,
    showLegend: false,
    resizeDebounce: 10,
    debug: false,
    tooltip: {
        type: exports.DEFAULT_TOOLTIP_TYPE,
        snap: exports.DEFAULT_TOOLTIP_SNAP,
    },
    externalPointerEvents: {
        tooltip: {
            visible: false,
        },
    },
    legendPosition: commons_1.Position.Right,
    showLegendExtra: false,
    hideDuplicateAxes: false,
    theme: light_theme_1.LIGHT_THEME,
    brushAxis: exports.BrushAxis.X,
    minBrushDelta: 2,
};
//# sourceMappingURL=constants.js.map