function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import AceEditor from 'react-ace';
import { keysOf } from '../common';
import { htmlIdGenerator, keys } from '../../services';
import { EuiI18n } from '../i18n';
var DEFAULT_MODE = 'text';
var DEFAULT_THEME = 'textmate';

function setOrRemoveAttribute(element, attributeName, value) {
  if (value === null || value === undefined) {
    element.removeAttribute(attributeName);
  } else {
    element.setAttribute(attributeName, value);
  }
}

export var EuiCodeEditor =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiCodeEditor, _Component);

  function EuiCodeEditor() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, EuiCodeEditor);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(EuiCodeEditor)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isHintActive: true,
      isEditing: false,
      name: htmlIdGenerator()()
    });

    _defineProperty(_assertThisInitialized(_this), "idGenerator", htmlIdGenerator());

    _defineProperty(_assertThisInitialized(_this), "aceEditor", null);

    _defineProperty(_assertThisInitialized(_this), "editorHint", null);

    _defineProperty(_assertThisInitialized(_this), "aceEditorRef", function (aceEditor) {
      if (aceEditor) {
        _this.aceEditor = aceEditor;
        var textbox = aceEditor.editor.textInput.getElement();
        textbox.tabIndex = -1;
        textbox.addEventListener('keydown', _this.onKeydownAce);
        setOrRemoveAttribute(textbox, 'aria-label', _this.props['aria-label']);
        setOrRemoveAttribute(textbox, 'aria-labelledby', _this.props['aria-labelledby']);
        setOrRemoveAttribute(textbox, 'aria-describedby', _this.props['aria-describedby']);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onKeydownAce", function (event) {
      if (event.key === keys.ESCAPE) {
        // If the autocompletion context menu is open then we want to let ESCAPE close it but
        // **not** exit out of editing mode.
        if (_this.aceEditor !== null && !_this.aceEditor.editor.completer) {
          event.preventDefault();
          event.stopPropagation();

          _this.stopEditing();

          if (_this.editorHint) {
            _this.editorHint.focus();
          }
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onFocusAce", function (event, editor) {
      _this.setState({
        isEditing: true
      });

      if (_this.props.onFocus) {
        _this.props.onFocus(event, editor);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onBlurAce", function (event, editor) {
      _this.stopEditing();

      if (_this.props.onBlur) {
        _this.props.onBlur(event, editor);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "onKeyDownHint", function (event) {
      if (event.key === keys.ENTER) {
        event.preventDefault();

        _this.startEditing();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "startEditing", function () {
      _this.setState({
        isHintActive: false
      });

      if (_this.aceEditor !== null) {
        _this.aceEditor.editor.textInput.focus();
      }
    });

    return _this;
  }

  _createClass(EuiCodeEditor, [{
    key: "stopEditing",
    value: function stopEditing() {
      this.setState({
        isHintActive: true,
        isEditing: false
      });
    }
  }, {
    key: "isCustomMode",
    value: function isCustomMode() {
      return _typeof(this.props.mode) === 'object';
    }
  }, {
    key: "setCustomMode",
    value: function setCustomMode() {
      if (this.aceEditor !== null) {
        this.aceEditor.editor.getSession().setMode(this.props.mode);
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.isCustomMode()) {
        this.setCustomMode();
      }

      var _this$props = this.props,
          isReadOnly = _this$props.isReadOnly,
          id = _this$props.id;
      var textareaProps = {
        id: id,
        readOnly: isReadOnly
      };
      var el = document.getElementById(this.state.name);

      if (el) {
        var textarea = el.querySelector('textarea');
        if (textarea) keysOf(textareaProps).forEach(function (key) {
          if (textareaProps[key]) textarea.setAttribute("".concat(key), textareaProps[key].toString());
        });
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.mode !== prevProps.mode && this.isCustomMode()) {
        this.setCustomMode();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          width = _this$props2.width,
          height = _this$props2.height,
          onBlur = _this$props2.onBlur,
          isReadOnly = _this$props2.isReadOnly,
          setOptions = _this$props2.setOptions,
          cursorStart = _this$props2.cursorStart,
          _this$props2$mode = _this$props2.mode,
          mode = _this$props2$mode === void 0 ? DEFAULT_MODE : _this$props2$mode,
          _this$props2$dataTes = _this$props2['data-test-subj'],
          dataTestSubj = _this$props2$dataTes === void 0 ? 'codeEditorContainer' : _this$props2$dataTes,
          _this$props2$theme = _this$props2.theme,
          theme = _this$props2$theme === void 0 ? DEFAULT_THEME : _this$props2$theme,
          rest = _objectWithoutProperties(_this$props2, ["width", "height", "onBlur", "isReadOnly", "setOptions", "cursorStart", "mode", "data-test-subj", "theme"]);

      var classes = classNames('euiCodeEditorWrapper', {
        'euiCodeEditorWrapper-isEditing': this.state.isEditing
      });
      var promptClasses = classNames('euiCodeEditorKeyboardHint', {
        'euiCodeEditorKeyboardHint-isInactive': !this.state.isHintActive
      });
      var filteredCursorStart;

      var options = _objectSpread({}, setOptions);

      if (isReadOnly) {
        // Put the cursor at the beginning of the editor, so that it doesn't look like
        // a prompt to begin typing.
        filteredCursorStart = -1;
        Object.assign(options, {
          readOnly: true,
          highlightActiveLine: false,
          highlightGutterLine: false
        });
      } else {
        filteredCursorStart = cursorStart;
      } // Don't use EuiKeyboardAccessible here because it doesn't play nicely with onKeyDown.


      var prompt = React.createElement("div", {
        className: promptClasses,
        id: this.idGenerator('codeEditor'),
        ref: function ref(hint) {
          _this2.editorHint = hint;
        },
        tabIndex: 0,
        role: "button",
        onClick: this.startEditing,
        onKeyDown: this.onKeyDownHint,
        "data-test-subj": "codeEditorHint"
      }, React.createElement("p", {
        className: "euiText"
      }, isReadOnly ? React.createElement(EuiI18n, {
        token: "euiCodeEditor.startInteracting",
        default: "Press Enter to start interacting with the code."
      }) : React.createElement(EuiI18n, {
        token: "euiCodeEditor.startEditing",
        default: "Press Enter to start editing."
      })), React.createElement("p", {
        className: "euiText"
      }, isReadOnly ? React.createElement(EuiI18n, {
        token: "euiCodeEditor.stopInteracting",
        default: "When you're done, press Escape to stop interacting with the code."
      }) : React.createElement(EuiI18n, {
        token: "euiCodeEditor.stopEditing",
        default: "When you're done, press Escape to stop editing."
      })));
      return React.createElement("div", {
        className: classes,
        style: {
          width: width,
          height: height
        },
        "data-test-subj": dataTestSubj
      }, prompt, React.createElement(AceEditor // Setting a default, existing `mode` is necessary to properly initialize the editor
      // prior to dynamically setting a custom mode (https://github.com/elastic/eui/pull/2616)
      , _extends({
        mode: this.isCustomMode() ? DEFAULT_MODE : mode // https://github.com/securingsincity/react-ace/pull/771
        ,
        name: this.state.name,
        theme: theme,
        ref: this.aceEditorRef,
        width: width,
        height: height,
        onFocus: this.onFocusAce,
        onBlur: this.onBlurAce,
        setOptions: options,
        editorProps: {
          $blockScrolling: Infinity
        },
        cursorStart: filteredCursorStart
      }, rest)));
    }
  }]);

  return EuiCodeEditor;
}(Component);

_defineProperty(EuiCodeEditor, "defaultProps", {
  setOptions: {}
});

EuiCodeEditor.propTypes = {
  width: PropTypes.string,
  height: PropTypes.string,
  onBlur: PropTypes.any,
  onFocus: PropTypes.any,
  isReadOnly: PropTypes.bool,
  setOptions: PropTypes.any.isRequired,
  cursorStart: PropTypes.number,
  "data-test-subj": PropTypes.string,

  /**
     * Select the `brace` theme
     * The matching theme file must also be imported from `brace` (e.g., `import 'brace/theme/github';`)
     */
  theme: PropTypes.any,

  /**
     * Use string for a built-in mode or object for a custom mode
     */
  mode: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]),
  id: PropTypes.string
};
EuiCodeEditor.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "aceEditorRef",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "aceEditor",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onKeydownAce",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onFocusAce",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }, {
      "name": "editor",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onBlurAce",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }, {
      "name": "editor",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onKeyDownHint",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "startEditing",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "stopEditing",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "isCustomMode",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "setCustomMode",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }],
  "displayName": "EuiCodeEditor",
  "props": {
    "setOptions": {
      "defaultValue": {
        "value": "{}",
        "computed": false
      },
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "width": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "height": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "onBlur": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "onFocus": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "isReadOnly": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "cursorStart": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "theme": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Select the `brace` theme\nThe matching theme file must also be imported from `brace` (e.g., `import 'brace/theme/github';`)"
    },
    "mode": {
      "type": {
        "name": "union",
        "value": [{
          "name": "any"
        }, {
          "name": "any"
        }]
      },
      "required": false,
      "description": "Use string for a built-in mode or object for a custom mode"
    },
    "id": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};