"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkMatchingSchemasTask = checkMatchingSchemasTask;

var path = _interopRequireWildcard(require("path"));

var _check_collector_integrity = require("../check_collector_integrity");

var _utils = require("../utils");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function checkMatchingSchemasTask({
  roots
}) {
  return roots.map(root => ({
    task: async () => {
      const fullPath = path.resolve(process.cwd(), root.config.output);
      const esMappingString = await (0, _utils.readFileAsync)(fullPath, 'utf-8');
      const esMapping = JSON.parse(esMappingString);

      if (root.parsedCollections) {
        const differences = (0, _check_collector_integrity.checkMatchingMapping)(root.parsedCollections, esMapping);
        root.esMappingDiffs = Object.keys(differences);
      }
    },
    title: `Checking in ${root.config.root}`
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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