function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { getServices } from '../../kibana_services';
import { ErrorEmbeddable } from '../../../../embeddable/public';
import { SEARCH_EMBEDDABLE_TYPE } from './constants';
export var SearchEmbeddableFactory = /*#__PURE__*/function () {
  function SearchEmbeddableFactory(getStartServices, getInjector) {
    var _this = this;

    _classCallCheck(this, SearchEmbeddableFactory);

    this.getStartServices = getStartServices;

    _defineProperty(this, "type", SEARCH_EMBEDDABLE_TYPE);

    _defineProperty(this, "$injector", void 0);

    _defineProperty(this, "getInjector", void 0);

    _defineProperty(this, "savedObjectMetaData", {
      name: i18n.translate('discover.savedSearch.savedObjectName', {
        defaultMessage: 'Saved search'
      }),
      type: 'search',
      getIconForSavedObject: function getIconForSavedObject() {
        return 'search';
      }
    });

    _defineProperty(this, "isEditable", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return _this.getStartServices();

            case 2:
              return _context.abrupt("return", _context.sent.isEditable());

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(this, "createFromSavedObject", /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(savedObjectId, input, parent) {
        var $injector, $compile, $rootScope, filterManager, url, editUrl, savedObject, indexPattern, _yield$_this$getStart, executeTriggerActions, _yield$import, SearchEmbeddableClass;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (_this.$injector) {
                  _context2.next = 4;
                  break;
                }

                _context2.next = 3;
                return _this.getInjector();

              case 3:
                _this.$injector = _context2.sent;

              case 4:
                $injector = _this.$injector;
                $compile = $injector.get('$compile');
                $rootScope = $injector.get('$rootScope');
                filterManager = getServices().filterManager;
                _context2.next = 10;
                return getServices().getSavedSearchUrlById(savedObjectId);

              case 10:
                url = _context2.sent;
                editUrl = getServices().addBasePath("/app/discover".concat(url));
                _context2.prev = 12;
                _context2.next = 15;
                return getServices().getSavedSearchById(savedObjectId);

              case 15:
                savedObject = _context2.sent;
                indexPattern = savedObject.searchSource.getField('index');
                _context2.next = 19;
                return _this.getStartServices();

              case 19:
                _yield$_this$getStart = _context2.sent;
                executeTriggerActions = _yield$_this$getStart.executeTriggerActions;
                _context2.next = 23;
                return import('./search_embeddable');

              case 23:
                _yield$import = _context2.sent;
                SearchEmbeddableClass = _yield$import.SearchEmbeddable;
                return _context2.abrupt("return", new SearchEmbeddableClass({
                  savedSearch: savedObject,
                  $rootScope: $rootScope,
                  $compile: $compile,
                  editUrl: editUrl,
                  editPath: url,
                  filterManager: filterManager,
                  editable: getServices().capabilities.discover.save,
                  indexPatterns: indexPattern ? [indexPattern] : []
                }, input, executeTriggerActions, parent));

              case 28:
                _context2.prev = 28;
                _context2.t0 = _context2["catch"](12);
                console.error(_context2.t0); // eslint-disable-line no-console

                return _context2.abrupt("return", new ErrorEmbeddable(_context2.t0, input, parent));

              case 32:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, null, [[12, 28]]);
      }));

      return function (_x, _x2, _x3) {
        return _ref2.apply(this, arguments);
      };
    }());

    this.$injector = null;
    this.getInjector = getInjector;
  }

  _createClass(SearchEmbeddableFactory, [{
    key: "canCreateNew",
    value: function canCreateNew() {
      return false;
    }
  }, {
    key: "getDisplayName",
    value: function getDisplayName() {
      return i18n.translate('discover.embeddable.search.displayName', {
        defaultMessage: 'search'
      });
    }
  }, {
    key: "create",
    value: function () {
      var _create = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(input) {
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                return _context3.abrupt("return", new ErrorEmbeddable('Saved searches can only be created from a saved object', input));

              case 1:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      function create(_x4) {
        return _create.apply(this, arguments);
      }

      return create;
    }()
  }]);

  return SearchEmbeddableFactory;
}();