function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { i18n } from '@kbn/i18n';
import { Control, noValuesDisableMsg, noIndexPatternMsg } from './control';
import { RangeFilterManager } from './filter_manager/range_filter_manager';
import { createSearchSource } from './create_search_source';

var minMaxAgg = function minMaxAgg(field) {
  var aggBody = {};

  if (field) {
    if (field.scripted) {
      aggBody.script = {
        source: field.script,
        lang: field.lang
      };
    } else {
      aggBody.field = field.name;
    }
  }

  return {
    maxAgg: {
      max: aggBody
    },
    minAgg: {
      min: aggBody
    }
  };
};

export var RangeControl = /*#__PURE__*/function (_Control) {
  _inherits(RangeControl, _Control);

  var _super = _createSuper(RangeControl);

  function RangeControl(controlParams, filterManager, useTimeFilter, searchSource, deps) {
    var _this;

    _classCallCheck(this, RangeControl);

    _this = _super.call(this, controlParams, filterManager, useTimeFilter);

    _defineProperty(_assertThisInitialized(_this), "searchSource", void 0);

    _defineProperty(_assertThisInitialized(_this), "timefilter", void 0);

    _defineProperty(_assertThisInitialized(_this), "abortController", void 0);

    _defineProperty(_assertThisInitialized(_this), "min", void 0);

    _defineProperty(_assertThisInitialized(_this), "max", void 0);

    _this.timefilter = deps.data.query.timefilter.timefilter;
    _this.searchSource = searchSource;
    return _this;
  }

  _createClass(RangeControl, [{
    key: "fetch",
    value: function () {
      var _fetch = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var indexPattern, fieldName, aggs, searchSource, abortSignal, resp, min, max;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // Abort any in-progress fetch
                if (this.abortController) {
                  this.abortController.abort();
                }

                this.abortController = new AbortController();
                indexPattern = this.filterManager.getIndexPattern();

                if (indexPattern) {
                  _context.next = 6;
                  break;
                }

                this.disable(noIndexPatternMsg(this.controlParams.indexPattern));
                return _context.abrupt("return");

              case 6:
                fieldName = this.filterManager.fieldName;
                aggs = minMaxAgg(indexPattern.fields.getByName(fieldName));
                _context.next = 10;
                return createSearchSource(this.searchSource, null, indexPattern, aggs, this.useTimeFilter, [], this.timefilter);

              case 10:
                searchSource = _context.sent;
                abortSignal = this.abortController.signal;
                _context.prev = 12;
                _context.next = 15;
                return searchSource.fetch({
                  abortSignal: abortSignal
                });

              case 15:
                resp = _context.sent;
                _context.next = 24;
                break;

              case 18:
                _context.prev = 18;
                _context.t0 = _context["catch"](12);

                if (!(_context.t0.name === 'AbortError')) {
                  _context.next = 22;
                  break;
                }

                return _context.abrupt("return");

              case 22:
                this.disable(i18n.translate('inputControl.rangeControl.unableToFetchTooltip', {
                  defaultMessage: 'Unable to fetch range min and max, error: {errorMessage}',
                  values: {
                    errorMessage: _context.t0.message
                  }
                }));
                return _context.abrupt("return");

              case 24:
                min = _.get(resp, 'aggregations.minAgg.value', null);
                max = _.get(resp, 'aggregations.maxAgg.value', null);

                if (!(min === null || max === null)) {
                  _context.next = 29;
                  break;
                }

                this.disable(noValuesDisableMsg(fieldName, indexPattern.title));
                return _context.abrupt("return");

              case 29:
                this.min = min;
                this.max = max;
                this.enable = true;

              case 32:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[12, 18]]);
      }));

      function fetch() {
        return _fetch.apply(this, arguments);
      }

      return fetch;
    }()
  }, {
    key: "destroy",
    value: function destroy() {
      if (this.abortController) this.abortController.abort();
    }
  }]);

  return RangeControl;
}(Control);
export function rangeControlFactory(_x, _x2, _x3) {
  return _rangeControlFactory.apply(this, arguments);
}

function _rangeControlFactory() {
  _rangeControlFactory = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(controlParams, useTimeFilter, deps) {
    var _yield$deps$core$getS, _yield$deps$core$getS2, dataPluginStart, indexPattern;

    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return deps.core.getStartServices();

          case 2:
            _yield$deps$core$getS = _context2.sent;
            _yield$deps$core$getS2 = _slicedToArray(_yield$deps$core$getS, 2);
            dataPluginStart = _yield$deps$core$getS2[1].data;
            _context2.next = 7;
            return dataPluginStart.indexPatterns.get(controlParams.indexPattern);

          case 7:
            indexPattern = _context2.sent;
            return _context2.abrupt("return", new RangeControl(controlParams, new RangeFilterManager(controlParams.id, controlParams.fieldName, indexPattern, deps.data.query.filterManager), useTimeFilter, dataPluginStart.search.searchSource, deps));

          case 9:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _rangeControlFactory.apply(this, arguments);
}