function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { extractSearchSourceReferences, expandShorthand } from '../../../../data/public';
export function serializeSavedObject(savedObject, config) {
  // mapping definition for the fields that this object will expose
  var mapping = expandShorthand(config.mapping);
  var attributes = {};
  var references = [];

  _.forOwn(mapping, function (fieldMapping, fieldName) {
    if (typeof fieldName !== 'string') {
      return;
    } // @ts-ignore


    var savedObjectFieldVal = savedObject[fieldName];

    if (savedObjectFieldVal != null) {
      attributes[fieldName] = fieldMapping._serialize ? fieldMapping._serialize(savedObjectFieldVal) : savedObjectFieldVal;
    }
  });

  if (savedObject.searchSource) {
    var _savedObject$searchSo = savedObject.searchSource.serialize(),
        searchSourceJSON = _savedObject$searchSo.searchSourceJSON,
        searchSourceReferences = _savedObject$searchSo.references;

    attributes.kibanaSavedObjectMeta = {
      searchSourceJSON: searchSourceJSON
    };
    references.push.apply(references, _toConsumableArray(searchSourceReferences));
  }

  if (savedObject.searchSourceFields) {
    var _extractSearchSourceR = extractSearchSourceReferences(savedObject.searchSourceFields),
        _extractSearchSourceR2 = _slicedToArray(_extractSearchSourceR, 2),
        searchSourceFields = _extractSearchSourceR2[0],
        _searchSourceReferences = _extractSearchSourceR2[1];

    var _searchSourceJSON = JSON.stringify(searchSourceFields);

    attributes.kibanaSavedObjectMeta = {
      searchSourceJSON: _searchSourceJSON
    };
    references.push.apply(references, _toConsumableArray(_searchSourceReferences));
  }

  if (savedObject.unresolvedIndexPatternReference) {
    references.push(savedObject.unresolvedIndexPatternReference);
  }

  return {
    attributes: attributes,
    references: references
  };
}