function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useEffect, useState } from 'react';
import { EuiPanel, EuiSpacer, EuiTitle } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { BasicOptions, ColorRanges, ColorSchemaOptions, NumberInputOption, SelectOption, SwitchOption } from '../../../../../charts/public';
import { LabelsPanel } from './labels_panel';

function HeatmapOptions(props) {
  var stateParams = props.stateParams,
      vis = props.vis,
      uiState = props.uiState,
      setValue = props.setValue,
      setValidity = props.setValidity,
      setTouched = props.setTouched;

  var _stateParams$valueAxe = _slicedToArray(stateParams.valueAxes, 1),
      valueAxis = _stateParams$valueAxe[0];

  var isColorsNumberInvalid = stateParams.colorsNumber < 2 || stateParams.colorsNumber > 10;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isColorRangesValid = _useState2[0],
      setIsColorRangesValid = _useState2[1];

  var setValueAxisScale = useCallback(function (paramName, value) {
    return setValue('valueAxes', [_objectSpread(_objectSpread({}, valueAxis), {}, {
      scale: _objectSpread(_objectSpread({}, valueAxis.scale), {}, _defineProperty({}, paramName, value))
    })]);
  }, [valueAxis, setValue]);
  useEffect(function () {
    setValidity(stateParams.setColorRange ? isColorRangesValid : !isColorsNumberInvalid);
  }, [stateParams.setColorRange, isColorRangesValid, isColorsNumberInvalid, setValidity]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.editors.heatmap.basicSettingsTitle",
    defaultMessage: "Basic settings"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(BasicOptions, props), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.editors.heatmap.highlightLabel', {
      defaultMessage: 'Highlight range'
    }),
    paramName: "enableHover",
    value: stateParams.enableHover,
    setValue: setValue,
    tooltip: i18n.translate('visTypeVislib.editors.heatmap.highlightLabelTooltip', {
      defaultMessage: 'Highlight hovered range in the chart and corresponding label in the legend.'
    })
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.editors.heatmap.heatmapSettingsTitle",
    defaultMessage: "Heatmap settings"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(ColorSchemaOptions, {
    colorSchema: stateParams.colorSchema,
    colorSchemas: vis.type.editorConfig.collections.colorSchemas,
    invertColors: stateParams.invertColors,
    uiState: uiState,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SelectOption, {
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.colorScaleLabel', {
      defaultMessage: 'Color scale'
    }),
    options: vis.type.editorConfig.collections.scales,
    paramName: "type",
    value: valueAxis.scale.type,
    setValue: setValueAxisScale
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.scaleToDataBoundsLabel', {
      defaultMessage: 'Scale to data bounds'
    }),
    paramName: "defaultYExtents",
    value: valueAxis.scale.defaultYExtents,
    setValue: setValueAxisScale
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    disabled: stateParams.setColorRange,
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.percentageModeLabel', {
      defaultMessage: 'Percentage mode'
    }),
    paramName: "percentageMode",
    value: stateParams.setColorRange ? false : stateParams.percentageMode,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(NumberInputOption, {
    "data-test-subj": "heatmapColorsNumber",
    disabled: stateParams.setColorRange,
    isInvalid: isColorsNumberInvalid,
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.colorsNumberLabel', {
      defaultMessage: 'Number of colors'
    }),
    max: 10,
    min: 2,
    paramName: "colorsNumber",
    value: stateParams.colorsNumber,
    setValue: setValue
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    "data-test-subj": "heatmapUseCustomRanges",
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.useCustomRangesLabel', {
      defaultMessage: 'Use custom ranges'
    }),
    paramName: "setColorRange",
    value: stateParams.setColorRange,
    setValue: setValue
  }), stateParams.setColorRange && /*#__PURE__*/React.createElement(ColorRanges, {
    "data-test-subj": "heatmapColorRange",
    colorsRange: stateParams.colorsRange,
    setValue: setValue,
    setTouched: setTouched,
    setValidity: setIsColorRangesValid
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(LabelsPanel, {
    valueAxis: valueAxis,
    setValue: setValue
  }));
}

export { HeatmapOptions };