/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) ^ (- 0u)) => uvec3(36u, 32u, 88u)
 * (uvec3(36u, 32u, 88u) ^ (- 6u)) => uvec3(4294967262u, 4294967258u, 4294967202u)
 * (uvec3(36u, 32u, 88u) ^ (- 12u)) => uvec3(4294967248u, 4294967252u, 4294967212u)
 * (uvec3(36u, 32u, 88u) ^ (- 32u)) => uvec3(4294967236u, 4294967232u, 4294967224u)
 * (uvec3(36u, 32u, 88u) ^ (- 74u)) => uvec3(4294967186u, 4294967190u, 4294967278u)
 * (uvec3(59u, 77u, 68u) ^ (- 0u)) => uvec3(59u, 77u, 68u)
 * (uvec3(59u, 77u, 68u) ^ (- 6u)) => uvec3(4294967233u, 4294967223u, 4294967230u)
 * (uvec3(59u, 77u, 68u) ^ (- 12u)) => uvec3(4294967247u, 4294967225u, 4294967216u)
 * (uvec3(59u, 77u, 68u) ^ (- 32u)) => uvec3(4294967259u, 4294967213u, 4294967204u)
 * (uvec3(59u, 77u, 68u) ^ (- 74u)) => uvec3(4294967181u, 4294967291u, 4294967282u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) ^ (- 0u)), uvec3(36u, 32u, 88u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (- 6u)), uvec3(4294967262u, 4294967258u, 4294967202u))) ? 1 : -1] array1;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (- 12u)), uvec3(4294967248u, 4294967252u, 4294967212u))) ? 1 : -1] array2;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (- 32u)), uvec3(4294967236u, 4294967232u, 4294967224u))) ? 1 : -1] array3;
  float[all(equal((uvec3(36u, 32u, 88u) ^ (- 74u)), uvec3(4294967186u, 4294967190u, 4294967278u))) ? 1 : -1] array4;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (- 0u)), uvec3(59u, 77u, 68u))) ? 1 : -1] array5;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (- 6u)), uvec3(4294967233u, 4294967223u, 4294967230u))) ? 1 : -1] array6;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (- 12u)), uvec3(4294967247u, 4294967225u, 4294967216u))) ? 1 : -1] array7;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (- 32u)), uvec3(4294967259u, 4294967213u, 4294967204u))) ? 1 : -1] array8;
  float[all(equal((uvec3(59u, 77u, 68u) ^ (- 74u)), uvec3(4294967181u, 4294967291u, 4294967282u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
