/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionDataEP;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupValueWithPsiElement;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.util.UnmodifiableIterator;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionUtil {
    private static final CompletionData ourGenericCompletionData = new CompletionData(){
        {
            CompletionVariant variant = new CompletionVariant(PsiElement.class, TrueFilter.INSTANCE);
            variant.addCompletionFilter(TrueFilter.INSTANCE, TailType.NONE);
            this.registerVariant(variant);
        }
    };
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz ".trim();

    @Nullable
    public static CompletionData getCompletionDataByElement(@Nullable PsiElement position, @NotNull PsiFile originalFile) {
        CompletionData mainData;
        if (originalFile == null) {
            CompletionUtil.$$$reportNull$$$0(0);
        }
        if (position == null) {
            return null;
        }
        PsiElement parent = position.getParent();
        Language language = parent == null ? position.getLanguage() : parent.getLanguage();
        LanguageFileType fileType = language.getAssociatedFileType();
        if (fileType != null && (mainData = CompletionUtil.getCompletionDataByFileType((FileType)fileType)) != null) {
            return mainData;
        }
        mainData = CompletionUtil.getCompletionDataByFileType(originalFile.getFileType());
        return mainData != null ? mainData : ourGenericCompletionData;
    }

    @Nullable
    private static CompletionData getCompletionDataByFileType(FileType fileType) {
        for (CompletionDataEP ep : CompletionDataEP.EP_NAME.getExtensionList()) {
            if (!ep.fileType.equals(fileType.getName())) continue;
            return ep.getHandler();
        }
        return null;
    }

    public static boolean shouldShowFeature(CompletionParameters parameters2, @NonNls String id2) {
        return CompletionUtil.shouldShowFeature(parameters2.getPosition().getProject(), id2);
    }

    public static boolean shouldShowFeature(Project project, @NonNls String id2) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(id2, project)) {
            FeatureUsageTracker.getInstance().triggerFeatureShown(id2);
            return true;
        }
        return false;
    }

    public static String findJavaIdentifierPrefix(CompletionParameters parameters2) {
        return CompletionUtil.findJavaIdentifierPrefix(parameters2.getPosition(), parameters2.getOffset());
    }

    public static String findJavaIdentifierPrefix(PsiElement insertedElement, int offset) {
        return CompletionUtil.findIdentifierPrefix(insertedElement, offset, (ElementPattern<Character>)CharPattern.javaIdentifierPartCharacter(), (ElementPattern<Character>)CharPattern.javaIdentifierStartCharacter());
    }

    public static String findReferenceOrAlphanumericPrefix(CompletionParameters parameters2) {
        String prefix = CompletionUtil.findReferencePrefix(parameters2);
        return prefix == null ? CompletionUtil.findAlphanumericPrefix(parameters2) : prefix;
    }

    public static String findAlphanumericPrefix(CompletionParameters parameters2) {
        return CompletionUtil.findIdentifierPrefix((PsiElement)parameters2.getPosition().getContainingFile(), parameters2.getOffset(), (ElementPattern<Character>)CharPattern.letterOrDigitCharacter(), (ElementPattern<Character>)CharPattern.letterOrDigitCharacter());
    }

    public static String findIdentifierPrefix(PsiElement insertedElement, int offset, ElementPattern<Character> idPart, ElementPattern<Character> idStart) {
        if (insertedElement == null) {
            return "";
        }
        int startOffset = insertedElement.getTextRange().getStartOffset();
        return CompletionUtil.findInText(offset, startOffset, idPart, idStart, insertedElement.getNode().getChars());
    }

    public static String findIdentifierPrefix(@NotNull Document document, int offset, ElementPattern<Character> idPart, ElementPattern<Character> idStart) {
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(1);
        }
        CharSequence text = document.getImmutableCharSequence();
        return CompletionUtil.findInText(offset, 0, idPart, idStart, text);
    }

    @NotNull
    private static String findInText(int offset, int startOffset, ElementPattern<Character> idPart, ElementPattern<Character> idStart, CharSequence text) {
        int start2;
        int offsetInElement = offset - startOffset;
        for (start2 = offsetInElement - 1; start2 >= 0 && idPart.accepts((Object)Character.valueOf(text.charAt(start2))); --start2) {
        }
        while (start2 + 1 < offsetInElement && !idStart.accepts((Object)Character.valueOf(text.charAt(start2 + 1)))) {
            ++start2;
        }
        String string = text.subSequence(start2 + 1, offsetInElement).toString().trim();
        if (string == null) {
            CompletionUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String findReferencePrefix(CompletionParameters parameters2) {
        return CompletionData.getReferencePrefix(parameters2.getPosition(), parameters2.getOffset());
    }

    public static InsertionContext emulateInsertion(InsertionContext oldContext, int newStart, LookupElement item) {
        InsertionContext newContext = CompletionUtil.newContext(oldContext, item);
        CompletionUtil.emulateInsertion(item, newStart, newContext);
        return newContext;
    }

    private static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement) {
        Editor editor = oldContext.getEditor();
        return new InsertionContext(new OffsetMap(editor.getDocument()), '\u0000', new LookupElement[]{forElement}, oldContext.getFile(), editor, oldContext.shouldAddCompletionChar());
    }

    public static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement, int startOffset, int tailOffset) {
        InsertionContext context = CompletionUtil.newContext(oldContext, forElement);
        CompletionUtil.setOffsets(context, startOffset, tailOffset);
        return context;
    }

    public static void emulateInsertion(LookupElement item, int offset, InsertionContext context) {
        CompletionUtil.setOffsets(context, offset, offset);
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        String lookupString = item.getLookupString();
        document.insertString(offset, (CharSequence)lookupString);
        editor.getCaretModel().moveToOffset(context.getTailOffset());
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
        item.handleInsert(context);
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
    }

    private static void setOffsets(InsertionContext context, int offset, int tailOffset) {
        OffsetMap offsetMap = context.getOffsetMap();
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, offset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, tailOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, tailOffset);
        context.setTailOffset(tailOffset);
    }

    @Nullable
    public static PsiElement getTargetElement(LookupElement lookupElement) {
        PsiElement element2;
        PsiElement psiElement = lookupElement.getPsiElement();
        if (psiElement != null && psiElement.isValid()) {
            return CompletionUtil.getOriginalElement(psiElement);
        }
        Object object = lookupElement.getObject();
        if (object instanceof LookupValueWithPsiElement && (element2 = ((LookupValueWithPsiElement)object).getElement()) != null && element2.isValid()) {
            return CompletionUtil.getOriginalElement(element2);
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi) {
        if (psi == null) {
            CompletionUtil.$$$reportNull$$$0(3);
        }
        return CompletionUtilCoreImpl.getOriginalElement(psi);
    }

    @NotNull
    public static <T extends PsiElement> T getOriginalOrSelf(@NotNull T psi) {
        T element2;
        if (psi == null) {
            CompletionUtil.$$$reportNull$$$0(4);
        }
        T t = (element2 = CompletionUtil.getOriginalElement(psi)) == null ? psi : element2;
        if (t == null) {
            CompletionUtil.$$$reportNull$$$0(5);
        }
        return t;
    }

    public static Iterable<String> iterateLookupStrings(final @NotNull LookupElement element2) {
        if (element2 == null) {
            CompletionUtil.$$$reportNull$$$0(6);
        }
        return new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator original = element2.getAllLookupStrings().iterator();
                return new UnmodifiableIterator<String>(original){

                    public boolean hasNext() {
                        try {
                            return super.hasNext();
                        }
                        catch (ConcurrentModificationException e) {
                            throw this.handleCME(e);
                        }
                    }

                    public String next() {
                        try {
                            return (String)super.next();
                        }
                        catch (ConcurrentModificationException e) {
                            throw this.handleCME(e);
                        }
                    }

                    private RuntimeException handleCME(ConcurrentModificationException cme) {
                        RuntimeExceptionWithAttachments ewa = new RuntimeExceptionWithAttachments("Error while traversing lookup strings of " + element2 + " of " + element2.getClass(), (String)null, new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
                        ewa.initCause((Throwable)cme);
                        return ewa;
                    }
                };
            }
        };
    }

    @NotNull
    @ApiStatus.Internal
    public static CompletionAssertions.WatchingInsertionContext createInsertionContext(@Nullable List<LookupElement> lookupItems, LookupElement item, char completionChar, Editor editor, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        int initialStartOffset = Math.max(0, caretOffset - item.getLookupString().length());
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, initialStartOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, caretOffset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, idEndOffset);
        List<LookupElement> items = lookupItems == null ? Collections.emptyList() : lookupItems;
        return new CompletionAssertions.WatchingInsertionContext(offsetMap, psiFile, completionChar, items, editor);
    }

    @ApiStatus.Internal
    public static int calcIdEndOffset(OffsetMap offsetMap, Editor editor, Integer initOffset) {
        return offsetMap.containsOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) ? offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) : CompletionInitializationContext.calcDefaultIdentifierEnd((Editor)editor, (int)initOffset);
    }

    @ApiStatus.Internal
    public static int calcIdEndOffset(CompletionProcessEx indicator) {
        return CompletionUtil.calcIdEndOffset(indicator.getOffsetMap(), indicator.getEditor(), indicator.getCaret().getOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findInText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalOrSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionDataByElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findIdentifierPrefix";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalOrSelf";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateLookupStrings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

