/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.focusMode;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.focusMode.FocusModeProvider;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FocusRegion;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FocusModePassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final Key<Set<FocusRegion>> FOCUS_REGIONS_FROM_PASS = Key.create((String)"editor.focus.mode.segmentsFromPass");
    private static final LanguageExtension<FocusModeProvider> EP_NAME = new LanguageExtension("com.intellij.focusModeProvider");
    private static final long MAX_ALLOWED_TIME = 100L;
    private static final Logger LOG = Logger.getInstance(FocusModePassFactory.class);

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            FocusModePassFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FocusModePassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            FocusModePassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            FocusModePassFactory.$$$reportNull$$$0(3);
        }
        return FocusModePassFactory.isEnabled() && EditorUtil.isRealFileEditor(editor) && editor instanceof EditorImpl ? new FocusModePass(editor, file2) : null;
    }

    private static boolean isEnabled() {
        return EditorSettingsExternalizable.getInstance().isFocusMode();
    }

    @Nullable
    public static List<? extends Segment> calcFocusZones(@Nullable PsiFile file2) {
        if (file2 == null || !FocusModePassFactory.isEnabled()) {
            return null;
        }
        return (List)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            FileViewProvider provider = file2.getViewProvider();
            List segments = EP_NAME.allForLanguageOrAny(provider.getBaseLanguage()).stream().map(p -> FocusModePassFactory.calcFocusZones(p, file2)).map(l -> ContainerUtil.append((List)l, (Object[])new Segment[]{file2.getTextRange()})).findFirst().orElse(null);
            return CachedValueProvider.Result.create((Object)segments, (Object[])new Object[]{file2});
        });
    }

    @NotNull
    private static List<? extends Segment> calcFocusZones(@NotNull FocusModeProvider focusModeProvider, @NotNull PsiFile psiFile) {
        Ref resultRef;
        long executionTime;
        if (focusModeProvider == null) {
            FocusModePassFactory.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            FocusModePassFactory.$$$reportNull$$$0(5);
        }
        if ((executionTime = TimeoutUtil.measureExecutionTime(() -> FocusModePassFactory.lambda$calcFocusZones$3(resultRef = Ref.create(), focusModeProvider, psiFile))) > 100L) {
            LOG.warn("Focus zones collecting took too long: " + executionTime + "ms; Provider: " + focusModeProvider.getClass().getSimpleName() + "; File size: " + psiFile.getTextLength() + "; Ranges collected: " + ((List)resultRef.get()).size());
        }
        List list2 = (List)resultRef.get();
        if (list2 == null) {
            FocusModePassFactory.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public static void setToEditor(@NotNull List<? extends Segment> zones, Editor editor) {
        if (zones == null) {
            FocusModePassFactory.$$$reportNull$$$0(7);
        }
        FocusModePassFactory.mergeSegments(editor, zones);
    }

    private static void mergeSegments(Editor editor, @NotNull List<? extends Segment> zones) {
        if (zones == null) {
            FocusModePassFactory.$$$reportNull$$$0(8);
        }
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        FocusModeModel focusModeModel = ((EditorImpl)editor).getFocusModeModel();
        Set focusRegions = (Set)((EditorImpl)editor).putUserDataIfAbsent(FOCUS_REGIONS_FROM_PASS, new HashSet());
        HashSet invalidFocusRegions = new HashSet(focusRegions);
        for (Segment segment : zones) {
            FocusRegion foundRegion = focusModeModel.findFocusRegion(segment.getStartOffset(), segment.getEndOffset());
            if (foundRegion == null) {
                FocusRegion newRegion = focusModeModel.createFocusRegion(segment.getStartOffset(), segment.getEndOffset());
                focusRegions.add(newRegion);
                continue;
            }
            if (focusRegions.contains(foundRegion)) {
                invalidFocusRegions.remove(foundRegion);
                continue;
            }
            LOG.warn("Trying to add existing focus region. startOffset: " + segment.getStartOffset() + ", endOffset: " + segment.getEndOffset());
        }
        for (FocusRegion focusRegion : invalidFocusRegions) {
            focusModeModel.removeFocusRegion(focusRegion);
            focusRegions.remove(focusRegion);
        }
    }

    private static /* synthetic */ void lambda$calcFocusZones$3(Ref resultRef, FocusModeProvider focusModeProvider, PsiFile psiFile) throws RuntimeException {
        resultRef.set(focusModeProvider.calcFocusZones(psiFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusModeProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/focusMode/FocusModePassFactory";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zones";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/focusMode/FocusModePassFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFocusZones";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcFocusZones";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setToEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeSegments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FocusModePass
    extends EditorBoundHighlightingPass {
        private List<? extends Segment> myZones;

        private FocusModePass(Editor editor, PsiFile file2) {
            super(editor, file2, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress2) {
            if (progress2 == null) {
                FocusModePass.$$$reportNull$$$0(0);
            }
            this.myZones = FocusModePassFactory.calcFocusZones(this.myFile);
        }

        @Override
        public void doApplyInformationToEditor() {
            if (this.myZones != null) {
                FocusModePassFactory.setToEditor(this.myZones, this.myEditor);
                ((EditorImpl)this.myEditor).applyFocusMode();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/focusMode/FocusModePassFactory$FocusModePass", "doCollectInformation"));
        }
    }
}

