/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ImportOldConfigsUsagesCollector;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jetbrains.annotations.Nullable;

class ImportOldConfigsPanel
extends JDialog {
    private JPanel myRootPanel;
    private JRadioButton myRbImportAuto;
    private JRadioButton myRbImport;
    private TextFieldWithBrowseButton myPrevInstallation;
    private JRadioButton myCustomButton;
    private JRadioButton myRbDoNotImport;
    private JButton myOkButton;
    private ComboBox<Path> myComboBoxOldPaths;
    private final List<Path> myGuessedOldConfigDirs;
    private final Function<Path, Pair<Path, Path>> myValidator;
    private final String myProductName;
    private Path myLastSelection = null;
    private Pair<Path, Path> myResult;

    ImportOldConfigsPanel(List<Path> guessedOldConfigDirs, Function<Path, Pair<Path, Path>> validator) {
        super((Dialog)null, true);
        this.myGuessedOldConfigDirs = guessedOldConfigDirs;
        this.myValidator = validator;
        this.$$$setupUI$$$();
        this.myProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.setTitle(ApplicationBundle.message((String)"title.import.settings", (Object[])new Object[]{this.myProductName}));
        this.init();
    }

    private void init() {
        String programFiles;
        MnemonicHelper.init((Component)this.getContentPane());
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbImportAuto);
        group.add(this.myRbImport);
        group.add(this.myRbDoNotImport);
        this.myRbDoNotImport.setSelected(true);
        this.myRbDoNotImport.setText(ApplicationBundle.message((String)"radio.do.not.import", (Object[])new Object[0]));
        if (this.myGuessedOldConfigDirs.isEmpty()) {
            this.myRbImportAuto.setVisible(false);
            this.myComboBoxOldPaths.setVisible(false);
        } else {
            this.myRbImportAuto.setText(ApplicationBundle.message((String)"radio.import.auto", (Object[])new Object[0]));
            this.myComboBoxOldPaths.setModel((ComboBoxModel)new CollectionComboBoxModel(this.myGuessedOldConfigDirs));
            this.myComboBoxOldPaths.setSelectedItem((Object)this.myGuessedOldConfigDirs.get(0));
            this.myRbImportAuto.setSelected(true);
        }
        Enumeration<AbstractButton> e2 = group.getElements();
        while (e2.hasMoreElements()) {
            e2.nextElement().addChangeListener(event -> this.update());
        }
        if (SystemInfo.isMac) {
            this.myLastSelection = Paths.get("/Applications", new String[0]);
        } else if (SystemInfo.isWindows && (programFiles = System.getenv("ProgramFiles")) != null) {
            Path candidate = Paths.get(programFiles, "JetBrains");
            this.myLastSelection = Files.isDirectory(candidate, new LinkOption[0]) ? candidate : Paths.get(programFiles, new String[0]);
        }
        this.myPrevInstallation.setTextFieldPreferredWidth(50);
        this.myPrevInstallation.addActionListener(e -> {
            FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
            chooserDescriptor.setHideIgnored(false);
            chooserDescriptor.withFileFilter(file2 -> file2.isDirectory() || ConfigImportHelper.isSettingsFile(file2));
            Ref fileRef = Ref.create();
            PathChooserDialog chooser = FileChooserFactoryImpl.createNativePathChooserIfEnabled(chooserDescriptor, null, this.myRootPanel);
            if (chooser != null) {
                CoreLocalVirtualFile vf = this.myLastSelection != null ? new CoreLocalVirtualFile(new CoreLocalFileSystem(), this.myLastSelection.toFile(), true) : null;
                chooser.choose((VirtualFile)vf, files2 -> fileRef.set((Object)new File(((VirtualFile)files2.get(0)).getPresentableUrl())));
            } else {
                File file3;
                JFileChooser fc = new JFileChooser(this.myLastSelection != null ? this.myLastSelection.getParent().toFile() : null);
                fc.setSelectedFile(this.myLastSelection != null ? this.myLastSelection.toFile() : null);
                fc.setFileSelectionMode(2);
                fc.setFileHidingEnabled(SystemInfo.isWindows || SystemInfo.isMac);
                fc.setFileFilter(new FileNameExtensionFilter("settings file", "zip", "jar"));
                int returnVal = fc.showOpenDialog(this);
                if (returnVal == 0 && (file3 = fc.getSelectedFile()) != null) {
                    fileRef.set((Object)file3);
                    this.myPrevInstallation.setText(file3.getAbsolutePath());
                }
            }
            if (!fileRef.isNull()) {
                this.myLastSelection = ((File)fileRef.get()).toPath();
                this.myPrevInstallation.setText(((File)fileRef.get()).getAbsolutePath());
            }
        });
        this.myOkButton.addActionListener(e -> this.close());
        CloudConfigProvider configProvider = CloudConfigProvider.getProvider();
        if (configProvider != null) {
            configProvider.initConfigsPanel(group, this.myCustomButton);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.myRootPanel);
        this.getRootPane().setDefaultButton(this.myOkButton);
        this.update();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setMinimumSize(this.getSize());
    }

    private void update() {
        this.myComboBoxOldPaths.setEnabled(this.myRbImportAuto.isSelected());
        this.myPrevInstallation.setEnabled(this.myRbImport.isSelected());
    }

    private void close() {
        if (this.myRbImport.isSelected()) {
            String text = this.myPrevInstallation.getText();
            if (StringUtil.isEmptyOrSpaces((String)text)) {
                this.showError(ApplicationBundle.message((String)"error.please.select.previous.installation.home", (Object[])new Object[]{this.myProductName}));
                return;
            }
            Path selectedDir = Paths.get(FileUtil.toCanonicalPath((String)text.trim()), new String[0]);
            if (Files.isRegularFile(selectedDir, new LinkOption[0])) {
                if (!ConfigImportHelper.isValidSettingsFile(selectedDir.toFile())) {
                    this.showError(IdeBundle.message((String)"error.file.contains.no.settings.to.import", (Object[])new Object[]{selectedDir, IdeBundle.message((String)"message.please.ensure.correct.settings", (Object[])new Object[0])}));
                    return;
                }
                this.myResult = Pair.pair((Object)selectedDir, null);
            } else {
                if (FileUtil.pathsEqual((String)selectedDir.toString(), (String)PathManager.getHomePath()) || FileUtil.pathsEqual((String)selectedDir.toString(), (String)PathManager.getConfigPath())) {
                    this.showError(ApplicationBundle.message((String)"error.selected.current.installation.home", (Object[])new Object[]{this.myProductName}));
                    return;
                }
                Pair<Path, Path> result2 = this.myValidator.apply(selectedDir);
                if (result2 == null) {
                    this.showError(ApplicationBundle.message((String)"error.does.not.appear.to.be.installation.home", (Object[])new Object[]{selectedDir, this.myProductName}));
                    return;
                }
                if (!Files.isReadable((Path)result2.first)) {
                    this.showError(ApplicationBundle.message((String)"error.no.read.permissions", (Object[])new Object[]{result2}));
                    return;
                }
                this.myResult = result2;
            }
        }
        this.dispose();
    }

    private void showError(String message) {
        String title = ApplicationBundle.message((String)"title.installation.home.required", (Object[])new Object[0]);
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    @Nullable
    Pair<Path, Path> getSelectedFile() {
        ImportOldConfigsUsagesCollector.ImportOldConfigsState.getInstance().saveImportOldConfigType(this.myRbImportAuto, this.myRbImport, this.myRbDoNotImport, this.myResult != null);
        if (this.myRbImportAuto.isSelected()) {
            return Pair.pair((Object)this.myGuessedOldConfigDirs.get(Math.max(this.myComboBoxOldPaths.getSelectedIndex(), 0)), null);
        }
        if (this.myRbImport.isSelected()) {
            return this.myResult;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        ComboBox comboBox2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRbImportAuto = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ImportOldConfigsPanel.class).getString("radio.import.auto"));
        jPanel3.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbImport = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ImportOldConfigsPanel.class).getString("radio.import"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myPrevInstallation = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 0, null, null, null, 2));
        this.myCustomButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("");
        ((Component)jRadioButton2).setVisible(false);
        jPanel3.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myRbDoNotImport = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ImportOldConfigsPanel.class).getString("radio.do.not.import"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myComboBoxOldPaths = comboBox2 = new ComboBox();
        jPanel3.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOkButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ImportOldConfigsPanel.class).getString("button.ok"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, new Dimension(80, -1), null, null, 5));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

