/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.Patches;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeMouseEventDispatcher {
    private final PresentationFactory myPresentationFactory = new PresentationFactory();
    private final List<AnAction> myActions = new ArrayList<AnAction>(1);
    private final Map<Container, BlockState> myRootPaneToBlockedId = new HashMap<Container, BlockState>();
    private int myLastHorScrolledComponentHash;
    private boolean myPressedModifiersStored;
    @JdkConstants.InputEventMask
    private int myModifiers;
    @JdkConstants.InputEventMask
    private int myModifiersEx;
    private static boolean myForceTouchIsAllowed = true;
    private static final int[] SWING_EVENTS_PRIORITY = new int[]{501, 504, 505, 503, 506, 507, 502, 500};

    public static void forbidForceTouch() {
        myForceTouchIsAllowed = false;
    }

    public static boolean isForceTouchAllowed() {
        return myForceTouchIsAllowed;
    }

    private void fillActionsList(Component component2, MouseShortcut mouseShortcut, boolean isModalContext) {
        KeymapManager keymapManager2;
        this.myActions.clear();
        while (component2 != null) {
            if (component2 instanceof JComponent) {
                for (AnAction action2 : ActionUtil.getActions((JComponent)((JComponent)component2))) {
                    for (Shortcut shortcut : action2.getShortcutSet().getShortcuts()) {
                        if (!mouseShortcut.equals((Object)shortcut) || this.myActions.contains(action2)) continue;
                        this.myActions.add(action2);
                    }
                }
                if (!this.myActions.isEmpty()) {
                    return;
                }
            }
            component2 = component2.getParent();
        }
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            return;
        }
        Object object = keymapManager2 = KeymapManagerImpl.isKeymapManagerInitialized() ? KeymapManager.getInstance() : null;
        if (keymapManager2 == null) {
            return;
        }
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        for (String actionId : keymap2.getActionIds(mouseShortcut)) {
            AnAction action3 = actionManager.getAction(actionId);
            if (action3 == null || isModalContext && !action3.isEnabledInModalContext() || this.myActions.contains(action3)) continue;
            this.myActions.add(action3);
        }
    }

    public boolean dispatchMouseEvent(MouseEvent e) {
        boolean done;
        BlockState blockState;
        int button2;
        int clickCount;
        boolean ignore;
        Component c;
        block31: {
            block30: {
                Component at;
                IdeFocusManager focusManager;
                c = e.getComponent();
                if (e.getID() == 501 && c instanceof IdeFrame && !c.hasFocus() && (focusManager = IdeFocusManager.getGlobalInstance()) instanceof FocusManagerImpl && (at = SwingUtilities.getDeepestComponentAt(c, e.getX(), e.getY())) != null && at.isFocusable()) {
                    ((FocusManagerImpl)focusManager).setLastFocusedAtDeactivation((Window)c, at);
                }
                if (e.isPopupTrigger()) {
                    if (3 == e.getButton()) {
                        if (Registry.is((String)"ide.mouse.popup.trigger.modifiers.disabled") && (0xFFFFEFFF & e.getModifiersEx()) != 0) {
                            IdeMouseEventDispatcher.resetPopupTrigger(e);
                        }
                    } else if (SystemInfo.isXWindow) {
                        IdeMouseEventDispatcher.resetPopupTrigger(e);
                    }
                }
                ignore = false;
                if (e.getID() != 501 && e.getID() != 502 && (e.getID() != 507 || 0 >= e.getModifiersEx()) && e.getID() != 500) {
                    ignore = true;
                }
                IdeMouseEventDispatcher.patchClickCount(e);
                clickCount = e.getClickCount();
                button2 = MouseShortcut.getButton((MouseEvent)e);
                if (button2 == 143 || button2 == 142) {
                    clickCount = 1;
                }
                if (e.isConsumed() || e.isPopupTrigger() || (button2 <= 3 ? e.getID() != 502 : e.getID() != 501 && e.getID() != 507)) break block30;
                if (clickCount >= 1 && button2 != 0) break block31;
            }
            ignore = true;
        }
        int modifiers = e.getModifiers();
        int modifiersEx = e.getModifiersEx();
        if (e.getID() == 501) {
            this.myPressedModifiersStored = true;
            this.myModifiers = modifiers;
            this.myModifiersEx = modifiersEx;
        } else if (e.getID() == 502) {
            myForceTouchIsAllowed = true;
            if (this.myPressedModifiersStored) {
                this.myPressedModifiersStored = false;
                modifiers = this.myModifiers;
                modifiersEx = this.myModifiersEx;
            }
        }
        JRootPane root = IdeMouseEventDispatcher.findRoot(e);
        if (root != null && (blockState = this.myRootPaneToBlockedId.get(root)) != null) {
            if (ArrayUtil.indexOf((int[])SWING_EVENTS_PRIORITY, (int)blockState.currentEventId) < ArrayUtil.indexOf((int[])SWING_EVENTS_PRIORITY, (int)e.getID())) {
                blockState.currentEventId = e.getID();
                if (blockState.blockMode == IdeEventQueue.BlockMode.COMPLETE) {
                    return true;
                }
                ignore = true;
            } else {
                this.myRootPaneToBlockedId.remove(root);
            }
        }
        if (c == null) {
            throw new IllegalStateException("component cannot be null");
        }
        if ((c = SwingUtilities.getDeepestComponentAt(c, e.getX(), e.getY())) instanceof IdeGlassPaneImpl) {
            c = ((IdeGlassPaneImpl)c).getTargetComponentFor(e);
        }
        if (c == null) {
            return false;
        }
        if (c instanceof MouseShortcutPanel || c.getParent() instanceof MouseShortcutPanel) {
            return false;
        }
        if (IdeMouseEventDispatcher.doVerticalDiagramScrolling(c, e)) {
            return true;
        }
        if (IdeMouseEventDispatcher.isHorizontalScrolling(c, e) && (done = this.doHorizontalScrolling(c, (MouseWheelEvent)e))) {
            return true;
        }
        if (ignore) {
            return false;
        }
        if (!KeymapManagerImpl.isKeymapManagerInitialized()) {
            return false;
        }
        MouseShortcut shortcut = new MouseShortcut(button2, modifiersEx, clickCount);
        this.fillActionsList(c, shortcut, IdeKeyEventDispatcher.isModalContext(c));
        ActionManagerEx actionManager = (ActionManagerEx)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager != null) {
            AnAction[] actions;
            for (AnAction action2 : actions = this.myActions.toArray(AnAction.EMPTY_ARRAY)) {
                Presentation presentation2;
                DataContext dataContext = DataManager.getInstance().getDataContext(c);
                AnActionEvent actionEvent = new AnActionEvent((InputEvent)e, dataContext, "mouse shortcut", presentation2 = this.myPresentationFactory.getPresentation(action2), ActionManager.getInstance(), modifiers);
                if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)actionEvent, (boolean)false)) continue;
                actionManager.fireBeforeActionPerformed(action2, dataContext, actionEvent);
                Component context = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                if (context != null && !context.isShowing()) continue;
                ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)actionEvent);
                actionManager.fireAfterActionPerformed(action2, dataContext, actionEvent);
                e.consume();
                break;
            }
        }
        return e.getButton() > 3;
    }

    private static void resetPopupTrigger(MouseEvent e) {
        ReflectionUtil.setField(MouseEvent.class, (Object)e, Boolean.TYPE, (String)"popupTrigger", (Object)false);
    }

    public static boolean patchClickCount(MouseEvent e) {
        if (e.getClickCount() != 1 && e.getButton() > 3) {
            ReflectionUtil.setField(MouseEvent.class, (Object)e, Integer.TYPE, (String)"clickCount", (Object)1);
            return true;
        }
        return false;
    }

    private boolean doHorizontalScrolling(Component c, MouseWheelEvent me) {
        JScrollBar scrollBar = IdeMouseEventDispatcher.findHorizontalScrollBar(c);
        if (scrollBar != null) {
            if (scrollBar.hashCode() != this.myLastHorScrolledComponentHash) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("ui.horizontal.scrolling");
                this.myLastHorScrolledComponentHash = scrollBar.hashCode();
            }
            scrollBar.setValue(scrollBar.getValue() + IdeMouseEventDispatcher.getScrollAmount(me, scrollBar));
            return true;
        }
        return false;
    }

    private static boolean doVerticalDiagramScrolling(@Nullable Component component2, @NotNull MouseEvent event) {
        JScrollBar scrollBar;
        MouseWheelEvent mwe;
        if (event == null) {
            IdeMouseEventDispatcher.$$$reportNull$$$0(0);
        }
        if (component2 != null && event instanceof MouseWheelEvent && IdeMouseEventDispatcher.isDiagramViewComponent(component2.getParent()) && !(mwe = (MouseWheelEvent)event).isShiftDown() && mwe.getScrollType() == 0 && JBScrollPane.isScrollEvent((MouseWheelEvent)mwe) && (scrollBar = IdeMouseEventDispatcher.findVerticalScrollBar(component2)) != null) {
            scrollBar.setValue(scrollBar.getValue() + IdeMouseEventDispatcher.getScrollAmount(mwe, scrollBar));
            return true;
        }
        return false;
    }

    @Nullable
    private static JScrollBar findVerticalScrollBar(@Nullable Component component2) {
        if (component2 == null) {
            return null;
        }
        if (component2 instanceof JScrollPane) {
            JScrollBar scrollBar = ((JScrollPane)component2).getVerticalScrollBar();
            return scrollBar != null && scrollBar.isVisible() ? scrollBar : null;
        }
        if (IdeMouseEventDispatcher.isDiagramViewComponent(component2)) {
            JComponent view = (JComponent)component2;
            for (int i2 = 0; i2 < view.getComponentCount(); ++i2) {
                JScrollBar scrollBar;
                if (!(view.getComponent(i2) instanceof JScrollBar) || (scrollBar = (JScrollBar)view.getComponent(i2)).getOrientation() != 1) continue;
                return scrollBar.isVisible() ? scrollBar : null;
            }
        }
        return IdeMouseEventDispatcher.findVerticalScrollBar(component2.getParent());
    }

    public void resetHorScrollingTracker() {
        this.myLastHorScrolledComponentHash = 0;
    }

    private static int getScrollAmount(MouseWheelEvent me, JScrollBar scrollBar) {
        return me.getUnitsToScroll() * scrollBar.getUnitIncrement();
    }

    private static boolean isHorizontalScrolling(Component c, MouseEvent e) {
        if (c != null && e instanceof MouseWheelEvent && (Patches.JDK_BUG_ID_8147994 || IdeMouseEventDispatcher.isDiagramViewComponent(c.getParent()))) {
            MouseWheelEvent mwe = (MouseWheelEvent)e;
            return mwe.isShiftDown() && mwe.getScrollType() == 0 && JBScrollPane.isScrollEvent((MouseWheelEvent)mwe) && IdeMouseEventDispatcher.findHorizontalScrollBar(c) != null;
        }
        return false;
    }

    @Nullable
    private static JScrollBar findHorizontalScrollBar(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JScrollPane) {
            JScrollBar scrollBar = ((JScrollPane)c).getHorizontalScrollBar();
            return scrollBar != null && scrollBar.isVisible() ? scrollBar : null;
        }
        if (IdeMouseEventDispatcher.isDiagramViewComponent(c)) {
            JComponent view = (JComponent)c;
            for (int i2 = 0; i2 < view.getComponentCount(); ++i2) {
                JScrollBar scrollBar;
                if (!(view.getComponent(i2) instanceof JScrollBar) || (scrollBar = (JScrollBar)view.getComponent(i2)).getOrientation() != 0) continue;
                return scrollBar.isVisible() ? scrollBar : null;
            }
        }
        return IdeMouseEventDispatcher.findHorizontalScrollBar(c.getParent());
    }

    public static boolean isDiagramViewComponent(@Nullable Component component2) {
        return UIUtil.isClientPropertyTrue((Object)component2, (Object)"Diagram-View-Component-Key");
    }

    public void blockNextEvents(@NotNull MouseEvent e, @NotNull IdeEventQueue.BlockMode blockMode) {
        JRootPane root;
        if (e == null) {
            IdeMouseEventDispatcher.$$$reportNull$$$0(1);
        }
        if (blockMode == null) {
            IdeMouseEventDispatcher.$$$reportNull$$$0(2);
        }
        if ((root = IdeMouseEventDispatcher.findRoot(e)) == null) {
            return;
        }
        this.myRootPaneToBlockedId.put(root, new BlockState(e.getID(), blockMode));
    }

    @Nullable
    private static JRootPane findRoot(MouseEvent e) {
        Component parent = UIUtil.findUltimateParent((Component)e.getComponent());
        JRootPane root = null;
        if (parent instanceof JWindow) {
            root = ((JWindow)parent).getRootPane();
        } else if (parent instanceof JDialog) {
            root = ((JDialog)parent).getRootPane();
        } else if (parent instanceof JFrame) {
            root = ((JFrame)parent).getRootPane();
        }
        return root;
    }

    public static void requestFocusInNonFocusedWindow(@NotNull MouseEvent event) {
        if (event == null) {
            IdeMouseEventDispatcher.$$$reportNull$$$0(3);
        }
        if (event.getID() == 501) {
            IdeMouseEventDispatcher.requestFocusInNonFocusedWindow(event.getComponent());
        }
    }

    private static void requestFocusInNonFocusedWindow(@Nullable Component component2) {
        Window window = ComponentUtil.getWindow((Component)component2);
        if (window != null && !UIUtil.isFocusAncestor((Component)window)) {
            Component focusable;
            Component component3 = focusable = UIUtil.isFocusable((Component)component2) ? component2 : IdeMouseEventDispatcher.findDefaultFocusableComponent(component2);
            if (focusable != null) {
                focusable.requestFocus();
            }
        }
    }

    @Nullable
    private static Component findDefaultFocusableComponent(@Nullable Component component2) {
        Container provider = IdeMouseEventDispatcher.findFocusTraversalPolicyProvider(component2);
        return provider == null ? null : provider.getFocusTraversalPolicy().getDefaultComponent(provider);
    }

    @Nullable
    private static Container findFocusTraversalPolicyProvider(@Nullable Component component2) {
        Container container2;
        Container container3 = container2 = component2 == null || component2 instanceof Container ? (Container)component2 : component2.getParent();
        while (container2 != null) {
            if (container2.isFocusCycleRoot() && container2.isFocusTraversalPolicyProvider()) {
                return container2;
            }
            container2 = container2.getParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/keymap/impl/IdeMouseEventDispatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doVerticalDiagramScrolling";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "blockNextEvents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "requestFocusInNonFocusedWindow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class BlockState {
        private int currentEventId;
        private final IdeEventQueue.BlockMode blockMode;

        private BlockState(int id2, IdeEventQueue.BlockMode mode) {
            this.currentEventId = id2;
            this.blockMode = mode;
        }
    }
}

