/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VfsEventGenerationHelper {
    static final Logger LOG = Logger.getInstance(RefreshWorker.class);
    private final List<VFileEvent> myEvents = new ArrayList<VFileEvent>();
    private int myMarkedStart = -1;

    VfsEventGenerationHelper() {
    }

    @NotNull
    public List<VFileEvent> getEvents() {
        List<VFileEvent> list2 = this.myEvents;
        if (list2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(0);
        }
        return list2;
    }

    static boolean checkDirty(@NotNull NewVirtualFile file2) {
        if (file2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(1);
        }
        boolean fileDirty = file2.isDirty();
        if (LOG.isTraceEnabled()) {
            LOG.trace("file=" + file2 + " dirty=" + fileDirty);
        }
        return fileDirty;
    }

    /*
     * WARNING - void declaration
     */
    void checkContentChanged(@NotNull VirtualFile file2, long oldTimestamp, long newTimestamp, long l, long l2) {
        void newLength;
        void oldLength;
        if (file2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(2);
        }
        if (oldTimestamp != newTimestamp || oldLength != newLength) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("update file=" + file2 + (oldTimestamp != newTimestamp ? " TS=" + oldTimestamp + "->" + newTimestamp : "") + (oldLength != newLength ? " len=" + (long)oldLength + "->" + (long)newLength : ""));
            }
            this.myEvents.add((VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, oldTimestamp, newTimestamp, (long)oldLength, (long)newLength, true));
        }
    }

    void scheduleCreation(@NotNull VirtualFile parent, @NotNull String childName, @NotNull FileAttributes attributes, @Nullable String symlinkTarget, @NotNull ThrowableRunnable<RefreshWorker.RefreshCancelledException> checkCanceled) throws RefreshWorker.RefreshCancelledException {
        if (parent == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(3);
        }
        if (childName == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(5);
        }
        if (checkCanceled == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(6);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("create parent=" + parent + " name=" + childName + " attr=" + attributes);
        }
        ChildInfo[] children2 = null;
        if (attributes.isDirectory() && parent.getFileSystem() instanceof LocalFileSystem && !attributes.isSymLink()) {
            try {
                Path child2 = Paths.get(parent.getPath(), childName);
                if (VfsEventGenerationHelper.shouldScanDirectory(parent, child2, childName)) {
                    List relevantExcluded = ContainerUtil.mapNotNull(ProjectManagerEx.getInstanceEx().getAllExcludedUrls(), url -> {
                        Path path = Paths.get(VirtualFileManager.extractPath((String)url), new String[0]);
                        return path.startsWith(child2) ? path : null;
                    });
                    children2 = VfsEventGenerationHelper.scanChildren(child2, relevantExcluded, checkCanceled);
                }
            }
            catch (InvalidPathException e) {
                LOG.warn("Invalid child name: '" + childName + "'", (Throwable)e);
            }
        }
        this.myEvents.add((VFileEvent)new VFileCreateEvent(null, parent, childName, attributes.isDirectory(), attributes, symlinkTarget, true, children2));
    }

    private static boolean shouldScanDirectory(@NotNull VirtualFile parent, @NotNull Path child2, @NotNull String childName) {
        if (parent == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(7);
        }
        if (child2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(8);
        }
        if (childName == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(9);
        }
        if (FileTypeManager.getInstance().isFileIgnored(childName)) {
            return false;
        }
        for (Project openProject2 : ProjectManager.getInstance().getOpenProjects()) {
            Path path;
            if (((Boolean)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)openProject2).isUnderIgnored(parent))).booleanValue()) {
                return false;
            }
            String projectRootPath = openProject2.getBasePath();
            if (projectRootPath == null || !child2.startsWith(path = Paths.get(projectRootPath, new String[0]))) continue;
            return true;
        }
        return false;
    }

    void beginTransaction() {
        this.myMarkedStart = this.myEvents.size();
    }

    void endTransaction(boolean success) {
        if (!success) {
            this.myEvents.subList(this.myMarkedStart, this.myEvents.size()).clear();
        }
        this.myMarkedStart = -1;
    }

    private static ChildInfo @Nullable [] scanChildren(final @NotNull Path root, final @NotNull List<Path> excluded, final @NotNull ThrowableRunnable<RefreshWorker.RefreshCancelledException> checkCanceled) throws RefreshWorker.RefreshCancelledException {
        if (root == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(10);
        }
        if (excluded == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(11);
        }
        if (checkCanceled == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(12);
        }
        final Stack stack = new Stack();
        ChildInfoImpl fakeRoot = new ChildInfoImpl(-238, "", null, null, null);
        stack.push((Object)new SmartList((Object)fakeRoot));
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){
            int checkCanceledCount;

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (!dir.equals(root)) {
                    this.visitFile(dir, attrs);
                }
                if (excluded.contains(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                stack.push(new ArrayList());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                if ((++this.checkCanceledCount & 0xF) == 0) {
                    checkCanceled.run();
                }
                String name = file2.getFileName().toString();
                boolean isSymLink = false;
                if (attrs.isSymbolicLink()) {
                    isSymLink = true;
                    attrs = Files.readAttributes(file2, BasicFileAttributes.class, new LinkOption[0]);
                }
                FileAttributes attributes = LocalFileSystemRefreshWorker.toFileAttributes(file2, attrs, isSymLink);
                String symLinkTarget = isSymLink ? FileUtil.toSystemIndependentName((String)file2.toRealPath(new LinkOption[0]).toString()) : null;
                ChildInfoImpl info = new ChildInfoImpl(-238, name, attributes, null, symLinkTarget);
                ((List)stack.peek()).add(info);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                List childInfos = (List)stack.pop();
                List parentInfos = (List)stack.peek();
                ChildInfo parentInfo = (ChildInfo)ContainerUtil.getLastItem((List)parentInfos);
                ChildInfo[] children2 = childInfos.toArray(ChildInfo.EMPTY_ARRAY);
                ChildInfoImpl newInfo = new ChildInfoImpl(parentInfo.getId(), parentInfo.getNameId(), parentInfo.getFileAttributes(), children2, parentInfo.getSymlinkTarget());
                parentInfos.set(parentInfos.size() - 1, newInfo);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file2, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        return ((ChildInfo)((List)stack.pop()).get(0)).getChildren();
    }

    void scheduleDeletion(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(13);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("delete file=" + file2);
        }
        this.myEvents.add((VFileEvent)new VFileDeleteEvent(null, file2, true));
    }

    void checkSymbolicLinkChange(@NotNull VirtualFile child2, String oldTarget, String currentTarget) {
        String currentVfsTarget;
        if (child2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(14);
        }
        String string = currentVfsTarget = currentTarget != null ? FileUtil.toSystemIndependentName((String)currentTarget) : null;
        if (!Objects.equals(oldTarget, currentVfsTarget)) {
            this.scheduleAttributeChange(child2, "symlink", oldTarget, currentVfsTarget);
        }
    }

    void checkHiddenAttributeChange(@NotNull VirtualFile child2, boolean oldHidden, boolean newHidden) {
        if (child2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(15);
        }
        if (oldHidden != newHidden) {
            this.scheduleAttributeChange(child2, "HIDDEN", oldHidden, newHidden);
        }
    }

    void checkWritableAttributeChange(@NotNull VirtualFile file2, boolean oldWritable, boolean newWritable) {
        if (file2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(16);
        }
        if (oldWritable != newWritable) {
            this.scheduleAttributeChange(file2, "writable", oldWritable, newWritable);
        }
    }

    void scheduleAttributeChange(@NotNull VirtualFile file2, @VirtualFile.PropName @NotNull String property, Object current2, Object upToDate) {
        if (file2 == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(17);
        }
        if (property == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(18);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("update file=" + file2 + ' ' + property + '=' + current2 + "->" + upToDate);
        }
        this.myEvents.add((VFileEvent)new VFilePropertyChangeEvent(null, file2, property, current2, upToDate, true));
    }

    void addAllEventsFrom(@NotNull VfsEventGenerationHelper otherHelper) {
        if (otherHelper == null) {
            VfsEventGenerationHelper.$$$reportNull$$$0(19);
        }
        this.myEvents.addAll(otherHelper.myEvents);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/VfsEventGenerationHelper";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkCanceled";
                break;
            }
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excluded";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/VfsEventGenerationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkDirty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkContentChanged";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCreation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldScanDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scanChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scheduleDeletion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkSymbolicLinkChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkHiddenAttributeChange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkWritableAttributeChange";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAttributeChange";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addAllEventsFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

