/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataModifications;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeCollectorImpl
extends TemplateDataElementType.RangeCollector {
    private final TemplateDataElementType myTemplateDataElementType;
    private final List<TextRange> myOuterAndRemoveRanges;
    static final Key<RangeCollectorImpl> OUTER_ELEMENT_RANGES = Key.create((String)"template.parser.outer.element.handler");

    RangeCollectorImpl(@NotNull TemplateDataElementType templateDataElementType) {
        if (templateDataElementType == null) {
            RangeCollectorImpl.$$$reportNull$$$0(0);
        }
        this(templateDataElementType, new ArrayList<TextRange>());
    }

    private RangeCollectorImpl(@NotNull TemplateDataElementType templateDataElementType, @NotNull List<TextRange> outerAndRemoveRanges) {
        if (templateDataElementType == null) {
            RangeCollectorImpl.$$$reportNull$$$0(1);
        }
        if (outerAndRemoveRanges == null) {
            RangeCollectorImpl.$$$reportNull$$$0(2);
        }
        this.myTemplateDataElementType = templateDataElementType;
        this.myOuterAndRemoveRanges = outerAndRemoveRanges;
    }

    @Override
    public void addOuterRange(@NotNull TextRange newRange) {
        if (newRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(3);
        }
        this.addOuterRange(newRange, false);
    }

    @Override
    public void addOuterRange(@NotNull TextRange newRange, boolean isInsertion) {
        int lastItemIndex;
        TextRange lastRange;
        if (newRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(4);
        }
        if (newRange.isEmpty()) {
            return;
        }
        this.assertRangeOrder(newRange);
        if (!this.myOuterAndRemoveRanges.isEmpty() && (lastRange = this.myOuterAndRemoveRanges.get(lastItemIndex = this.myOuterAndRemoveRanges.size() - 1)).getEndOffset() == newRange.getStartOffset() && !(lastRange instanceof RangeToRemove)) {
            InsertionRange joinedRange = lastRange instanceof InsertionRange || isInsertion ? new InsertionRange(lastRange.getStartOffset(), newRange.getEndOffset()) : TextRange.create((int)lastRange.getStartOffset(), (int)newRange.getEndOffset());
            this.myOuterAndRemoveRanges.set(lastItemIndex, joinedRange);
            return;
        }
        this.myOuterAndRemoveRanges.add(isInsertion ? new InsertionRange(newRange.getStartOffset(), newRange.getEndOffset()) : newRange);
    }

    @Override
    public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
        if (rangeToRemove == null) {
            RangeCollectorImpl.$$$reportNull$$$0(5);
        }
        if (rangeToRemove.isEmpty()) {
            return;
        }
        this.assertRangeOrder(rangeToRemove);
        this.myOuterAndRemoveRanges.add(new RangeToRemove(rangeToRemove.getStartOffset(), rangeToRemove.getEndOffset()));
    }

    private void assertRangeOrder(@NotNull TextRange newRange) {
        if (newRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(6);
        }
        TextRange range2 = (TextRange)ContainerUtil.getLastItem(this.myOuterAndRemoveRanges);
        assert (range2 == null || newRange.getStartOffset() >= range2.getStartOffset());
    }

    void prepareFileForParsing(@NotNull Language templateLanguage, @NotNull CharSequence originalSourceCode, @NotNull CharSequence templateSourceCode) {
        if (templateLanguage == null) {
            RangeCollectorImpl.$$$reportNull$$$0(7);
        }
        if (originalSourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(8);
        }
        if (templateSourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(9);
        }
        this.addDummyStringsToRangesToRemove(templateSourceCode);
        TemplateDataElementType.OuterLanguageRangePatcher patcher = (TemplateDataElementType.OuterLanguageRangePatcher)TemplateDataElementType.OuterLanguageRangePatcher.EXTENSION.forLanguage(templateLanguage);
        if (patcher != null) {
            StringBuilder builder2 = templateSourceCode instanceof StringBuilder ? (StringBuilder)templateSourceCode : new StringBuilder(templateSourceCode);
            this.insertDummyStringIntoInsertionRanges(patcher, originalSourceCode, builder2);
        }
    }

    private void addDummyStringsToRangesToRemove(@NotNull CharSequence generatedText) {
        if (generatedText == null) {
            RangeCollectorImpl.$$$reportNull$$$0(10);
        }
        int shift = 0;
        ListIterator<TextRange> iterator2 = this.myOuterAndRemoveRanges.listIterator();
        while (iterator2.hasNext()) {
            TextRange range2 = iterator2.next();
            if (range2 instanceof RangeToRemove) {
                CharSequence insertedString = generatedText.subSequence(range2.getStartOffset() - shift, range2.getEndOffset() - shift);
                iterator2.set(new RangeToRemove(range2.getStartOffset(), insertedString));
                shift -= range2.getLength();
                continue;
            }
            shift += range2.getLength();
        }
    }

    private void insertDummyStringIntoInsertionRanges(@NotNull TemplateDataElementType.OuterLanguageRangePatcher patcher, @NotNull CharSequence originalSourceCode, @NotNull StringBuilder modifiedText) {
        if (patcher == null) {
            RangeCollectorImpl.$$$reportNull$$$0(11);
        }
        if (originalSourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(12);
        }
        if (modifiedText == null) {
            RangeCollectorImpl.$$$reportNull$$$0(13);
        }
        if (this.myOuterAndRemoveRanges.isEmpty()) {
            return;
        }
        int shift = 0;
        ListIterator<TextRange> iterator2 = this.myOuterAndRemoveRanges.listIterator();
        while (iterator2.hasNext()) {
            String dummyString;
            TextRange outerElementRange = iterator2.next();
            if (outerElementRange instanceof RangeToRemove) {
                shift += outerElementRange.getLength();
                continue;
            }
            if (outerElementRange instanceof InsertionRange && (dummyString = patcher.getTextForOuterLanguageInsertionRange(this.myTemplateDataElementType, outerElementRange.subSequence(originalSourceCode))) != null) {
                iterator2.add(new RangeToRemove(outerElementRange.getEndOffset(), outerElementRange.getEndOffset() + dummyString.length()));
                modifiedText.insert(outerElementRange.getStartOffset() + shift, dummyString);
                shift += dummyString.length();
            }
            shift -= outerElementRange.getLength();
        }
    }

    void insertOuterElementsAndRemoveRanges(@NotNull TreeElement templateFileElement, @NotNull CharSequence sourceCode, @NotNull CharTable charTable, @NotNull Language language) {
        if (templateFileElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(14);
        }
        if (sourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(15);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(16);
        }
        if (language == null) {
            RangeCollectorImpl.$$$reportNull$$$0(17);
        }
        TreePatcher templateTreePatcher = (TreePatcher)TemplateDataElementType.TREE_PATCHER.forLanguage(language);
        TreeElement currentLeafOrLazyParseable = RangeCollectorImpl.findFirstSuitableElement(templateFileElement);
        int currentLeafOffset = 0;
        for (TextRange rangeToProcess : this.myOuterAndRemoveRanges) {
            int rangeStartOffset = rangeToProcess.getStartOffset();
            while (currentLeafOrLazyParseable != null && currentLeafOffset + currentLeafOrLazyParseable.getTextLength() <= rangeStartOffset) {
                currentLeafOffset += currentLeafOrLazyParseable.getTextLength();
                currentLeafOrLazyParseable = RangeCollectorImpl.findNextSuitableElement(currentLeafOrLazyParseable);
            }
            boolean addRangeToLazyParseableCollector = false;
            if (rangeToProcess instanceof RangeToRemove) {
                if (currentLeafOrLazyParseable == null) {
                    Logger.getInstance(TemplateDataElementType.RangeCollector.class).error("RangeToRemove's range is out of original text bound", new Attachment[]{new Attachment("myOuterAndRemoveRanges", StringUtil.join(this.myOuterAndRemoveRanges, TextRange::toString, (String)", ")), new Attachment("rangeToProcess", rangeToProcess.toString()), new Attachment("sourceCode", sourceCode.toString())});
                    continue;
                }
                if ((currentLeafOrLazyParseable = this.removeElementsForRange(currentLeafOrLazyParseable, currentLeafOffset, rangeToProcess, templateTreePatcher, charTable)) != null && !(currentLeafOrLazyParseable instanceof LeafElement) && ((RangeToRemove)rangeToProcess).myTextToRemove != null) {
                    addRangeToLazyParseableCollector = true;
                }
            } else {
                if (currentLeafOrLazyParseable instanceof LeafElement && currentLeafOffset < rangeStartOffset) {
                    int splitOffset = rangeStartOffset - currentLeafOffset;
                    currentLeafOrLazyParseable = templateTreePatcher.split((LeafElement)currentLeafOrLazyParseable, splitOffset, charTable);
                    currentLeafOffset = rangeStartOffset;
                }
                if (currentLeafOrLazyParseable == null) {
                    this.insertLastOuterElementForRange((CompositeElement)templateFileElement, rangeToProcess, sourceCode, charTable);
                } else if (!((currentLeafOrLazyParseable = this.insertOuterElementFromRange(currentLeafOrLazyParseable, currentLeafOffset, rangeToProcess, sourceCode, templateTreePatcher, charTable)) instanceof LeafElement)) {
                    addRangeToLazyParseableCollector = true;
                }
            }
            if (!addRangeToLazyParseableCollector) continue;
            RangeCollectorImpl lazyParseableCollector = (RangeCollectorImpl)currentLeafOrLazyParseable.getUserData(OUTER_ELEMENT_RANGES);
            assert (lazyParseableCollector != null && lazyParseableCollector != this);
            lazyParseableCollector.myOuterAndRemoveRanges.add(rangeToProcess.shiftLeft(currentLeafOffset));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String after2 = templateFileElement.getText();
            assert (after2.contentEquals(sourceCode)) : "Text presentation for the new tree must be the same: \nbefore: " + sourceCode + "\nafter: " + after2;
        }
    }

    @Nullable
    private static TreeElement findFirstSuitableElement(@NotNull ASTNode element2) {
        if (element2 == null) {
            RangeCollectorImpl.$$$reportNull$$$0(18);
        }
        if (RangeCollectorImpl.isSuitableElement(element2)) {
            return (TreeElement)element2;
        }
        for (ASTNode child2 = element2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            TreeElement leaf = RangeCollectorImpl.findFirstSuitableElement(child2);
            if (leaf == null) continue;
            return leaf;
        }
        return null;
    }

    @Nullable
    private static TreeElement findNextSuitableElement(@NotNull TreeElement start2) {
        if (start2 == null) {
            RangeCollectorImpl.$$$reportNull$$$0(19);
        }
        for (TreeElement element2 = start2; element2 != null; element2 = element2.getTreeParent()) {
            TreeElement nextTree = element2;
            TreeElement next = null;
            while (next == null && (nextTree = nextTree.getTreeNext()) != null) {
                next = RangeCollectorImpl.findFirstSuitableElement(nextTree);
            }
            if (next == null) continue;
            return next;
        }
        return null;
    }

    private static boolean isSuitableElement(@NotNull ASTNode element2) {
        if (element2 == null) {
            RangeCollectorImpl.$$$reportNull$$$0(20);
        }
        return element2 instanceof LeafElement || TreeUtil.isCollapsedChameleon(element2) && element2.getElementType() instanceof TemplateDataElementType.TemplateAwareElementType;
    }

    private void insertLastOuterElementForRange(@NotNull CompositeElement templateFileElement, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull CharTable charTable) {
        if (templateFileElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(21);
        }
        if (outerElementRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(22);
        }
        if (sourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(23);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(24);
        }
        assert (RangeCollectorImpl.isLastRange(this.myOuterAndRemoveRanges, outerElementRange)) : "This should only happen for the last inserted range. Got " + this.myOuterAndRemoveRanges.lastIndexOf(outerElementRange) + " of " + (this.myOuterAndRemoveRanges.size() - 1);
        OuterLanguageElementImpl outerLanguageElement = this.myTemplateDataElementType.createOuterLanguageElement(charTable.intern(outerElementRange.subSequence(sourceCode)), this.myTemplateDataElementType.myOuterElementType);
        templateFileElement.rawAddChildren(outerLanguageElement);
    }

    private static boolean isLastRange(@NotNull List<TextRange> outerElementsRanges, @NotNull TextRange outerElementRange) {
        if (outerElementsRanges == null) {
            RangeCollectorImpl.$$$reportNull$$$0(25);
        }
        if (outerElementRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(26);
        }
        return outerElementsRanges.get(outerElementsRanges.size() - 1) == outerElementRange;
    }

    @NotNull
    private TreeElement insertOuterElementFromRange(@NotNull TreeElement currentLeaf, int currentLeafOffset, @NotNull TextRange outerElementRange, @NotNull CharSequence sourceCode, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (currentLeaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(27);
        }
        if (outerElementRange == null) {
            RangeCollectorImpl.$$$reportNull$$$0(28);
        }
        if (sourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(29);
        }
        if (templateTreePatcher == null) {
            RangeCollectorImpl.$$$reportNull$$$0(30);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(31);
        }
        CharSequence outerElementText = outerElementRange.subSequence(sourceCode);
        if (currentLeaf instanceof LazyParseableElement) {
            StringBuilder builder2 = new StringBuilder(currentLeaf.getText());
            builder2.insert(outerElementRange.getStartOffset() - currentLeafOffset, outerElementText);
            TreeElement newElement = this.newLazyParseable(currentLeaf, builder2.toString());
            currentLeaf.rawInsertAfterMe(newElement);
            currentLeaf.rawRemove();
            TreeElement treeElement = newElement;
            if (treeElement == null) {
                RangeCollectorImpl.$$$reportNull$$$0(32);
            }
            return treeElement;
        }
        OuterLanguageElementImpl newLeaf = this.myTemplateDataElementType.createOuterLanguageElement(charTable.intern(outerElementText), this.myTemplateDataElementType.myOuterElementType);
        templateTreePatcher.insert(currentLeaf.getTreeParent(), currentLeaf, newLeaf);
        OuterLanguageElementImpl outerLanguageElementImpl = newLeaf;
        if (outerLanguageElementImpl == null) {
            RangeCollectorImpl.$$$reportNull$$$0(33);
        }
        return outerLanguageElementImpl;
    }

    @NotNull
    private TreeElement newLazyParseable(@NotNull TreeElement currentLeaf, @NotNull CharSequence text) {
        if (currentLeaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(34);
        }
        if (text == null) {
            RangeCollectorImpl.$$$reportNull$$$0(35);
        }
        TemplateDataElementType.TemplateAwareElementType elementType = (TemplateDataElementType.TemplateAwareElementType)currentLeaf.getElementType();
        TreeElement newElement = elementType.createTreeElement(text);
        RangeCollectorImpl collector = (RangeCollectorImpl)currentLeaf.getUserData(OUTER_ELEMENT_RANGES);
        if (collector == null) {
            collector = new RangeCollectorImpl(this.myTemplateDataElementType);
        }
        newElement.putUserData(OUTER_ELEMENT_RANGES, collector);
        TreeElement treeElement = newElement;
        if (treeElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(36);
        }
        return treeElement;
    }

    @Nullable
    private TreeElement removeElementsForRange(@NotNull TreeElement startLeaf, int startLeafOffset, @NotNull TextRange rangeToRemove, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (startLeaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(37);
        }
        if (rangeToRemove == null) {
            RangeCollectorImpl.$$$reportNull$$$0(38);
        }
        if (templateTreePatcher == null) {
            RangeCollectorImpl.$$$reportNull$$$0(39);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(40);
        }
        TreeElement nextLeaf = startLeaf;
        int nextLeafStartOffset = startLeafOffset;
        ArrayList<TreeElement> leavesToRemove = new ArrayList<TreeElement>();
        while (nextLeaf != null && rangeToRemove.containsRange(nextLeafStartOffset, nextLeafStartOffset + nextLeaf.getTextLength())) {
            leavesToRemove.add(nextLeaf);
            nextLeafStartOffset += nextLeaf.getTextLength();
            nextLeaf = RangeCollectorImpl.findNextSuitableElement(nextLeaf);
        }
        nextLeaf = this.splitOrRemoveRangeInsideLeafIfOverlap(nextLeaf, nextLeafStartOffset, rangeToRemove, templateTreePatcher, charTable);
        for (TreeElement element2 : leavesToRemove) {
            element2.rawRemove();
        }
        return nextLeaf;
    }

    @Nullable
    private TreeElement splitOrRemoveRangeInsideLeafIfOverlap(@Nullable TreeElement nextLeaf, int nextLeafStartOffset, @NotNull TextRange rangeToRemove, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (rangeToRemove == null) {
            RangeCollectorImpl.$$$reportNull$$$0(41);
        }
        if (templateTreePatcher == null) {
            RangeCollectorImpl.$$$reportNull$$$0(42);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(43);
        }
        if (nextLeaf == null) {
            return null;
        }
        if (nextLeafStartOffset >= rangeToRemove.getEndOffset()) {
            return nextLeaf;
        }
        if (rangeToRemove.getStartOffset() > nextLeafStartOffset) {
            return this.removeRange(nextLeaf, rangeToRemove.shiftLeft(nextLeafStartOffset), charTable);
        }
        int offsetToSplit = rangeToRemove.getEndOffset() - nextLeafStartOffset;
        return this.removeLeftPartOfLeaf(nextLeaf, offsetToSplit, templateTreePatcher, charTable);
    }

    @NotNull
    private TreeElement removeLeftPartOfLeaf(@NotNull TreeElement nextLeaf, int offsetToSplit, @NotNull TreePatcher templateTreePatcher, @NotNull CharTable charTable) {
        if (nextLeaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(44);
        }
        if (templateTreePatcher == null) {
            RangeCollectorImpl.$$$reportNull$$$0(45);
        }
        if (charTable == null) {
            RangeCollectorImpl.$$$reportNull$$$0(46);
        }
        if (offsetToSplit == 0) {
            TreeElement treeElement = nextLeaf;
            if (treeElement == null) {
                RangeCollectorImpl.$$$reportNull$$$0(47);
            }
            return treeElement;
        }
        if (!(nextLeaf instanceof LeafElement)) {
            return this.removeRange(nextLeaf, TextRange.from((int)0, (int)offsetToSplit), charTable);
        }
        LeafElement rLeaf = templateTreePatcher.split((LeafElement)nextLeaf, offsetToSplit, charTable);
        LeafElement lLeaf = (LeafElement)TreeUtil.prevLeaf(rLeaf);
        assert (lLeaf != null);
        lLeaf.rawRemove();
        LeafElement leafElement = rLeaf;
        if (leafElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(48);
        }
        return leafElement;
    }

    @NotNull
    ASTNode applyRangeCollectorAndExpandChameleon(@NotNull ASTNode chameleon, @NotNull Language language, @NotNull @NotNull Function<@NotNull CharSequence, @NotNull ASTNode> parser) {
        if (chameleon == null) {
            RangeCollectorImpl.$$$reportNull$$$0(49);
        }
        if (language == null) {
            RangeCollectorImpl.$$$reportNull$$$0(50);
        }
        if (parser == null) {
            RangeCollectorImpl.$$$reportNull$$$0(51);
        }
        CharSequence chars = chameleon.getChars();
        if (this.myOuterAndRemoveRanges.isEmpty()) {
            ASTNode aSTNode = parser.apply(chars);
            if (aSTNode == null) {
                RangeCollectorImpl.$$$reportNull$$$0(52);
            }
            return aSTNode;
        }
        StringBuilder stringBuilder = this.applyOuterAndRemoveRanges(chars);
        TemplateDataElementType.OuterLanguageRangePatcher outerLanguageRangePatcher = (TemplateDataElementType.OuterLanguageRangePatcher)TemplateDataElementType.OuterLanguageRangePatcher.EXTENSION.forLanguage(language);
        if (outerLanguageRangePatcher != null) {
            this.insertDummyStringIntoInsertionRanges(outerLanguageRangePatcher, chars, stringBuilder);
        }
        ASTNode root = parser.apply(stringBuilder.toString());
        DebugUtil.performPsiModification("lazy parseable outer elements insertion", () -> this.insertOuterElementsAndRemoveRanges((TreeElement)root, chars, SharedImplUtil.findCharTableByTree(chameleon), language));
        ASTNode aSTNode = root;
        if (aSTNode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(53);
        }
        return aSTNode;
    }

    @NotNull
    private StringBuilder applyOuterAndRemoveRanges(CharSequence chars) {
        StringBuilder stringBuilder = new StringBuilder(chars);
        int shift = 0;
        for (TextRange outerElementRange : this.myOuterAndRemoveRanges) {
            if (outerElementRange instanceof RangeToRemove) {
                CharSequence textToRemove = ((RangeToRemove)outerElementRange).myTextToRemove;
                if (textToRemove == null) continue;
                stringBuilder.insert(outerElementRange.getStartOffset() + shift, textToRemove);
                shift += textToRemove.length();
                continue;
            }
            stringBuilder.delete(outerElementRange.getStartOffset() + shift, outerElementRange.getEndOffset() + shift);
            shift -= outerElementRange.getLength();
        }
        StringBuilder stringBuilder2 = stringBuilder;
        if (stringBuilder2 == null) {
            RangeCollectorImpl.$$$reportNull$$$0(54);
        }
        return stringBuilder2;
    }

    @NotNull
    private TreeElement removeRange(@NotNull TreeElement leaf, @NotNull TextRange rangeToRemove, @NotNull CharTable table) {
        if (leaf == null) {
            RangeCollectorImpl.$$$reportNull$$$0(55);
        }
        if (rangeToRemove == null) {
            RangeCollectorImpl.$$$reportNull$$$0(56);
        }
        if (table == null) {
            RangeCollectorImpl.$$$reportNull$$$0(57);
        }
        CharSequence chars = leaf.getChars();
        String res2 = rangeToRemove.replace(chars.toString(), "");
        TreeElement newLeaf = leaf instanceof LeafElement ? ASTFactory.leaf(leaf.getElementType(), table.intern((CharSequence)res2)) : this.newLazyParseable(leaf, res2);
        leaf.rawInsertBeforeMe(newLeaf);
        leaf.rawRemove();
        TreeElement treeElement = newLeaf;
        if (treeElement == null) {
            RangeCollectorImpl.$$$reportNull$$$0(58);
        }
        return treeElement;
    }

    @NotNull
    CharSequence applyTemplateDataModifications(@NotNull CharSequence sourceCode, @NotNull TemplateDataModifications modifications) {
        if (sourceCode == null) {
            RangeCollectorImpl.$$$reportNull$$$0(59);
        }
        if (modifications == null) {
            RangeCollectorImpl.$$$reportNull$$$0(60);
        }
        assert (this.myOuterAndRemoveRanges.isEmpty());
        List<TextRange> ranges = modifications.myOuterAndRemoveRanges;
        if (ranges.isEmpty()) {
            CharSequence charSequence = sourceCode;
            if (charSequence == null) {
                RangeCollectorImpl.$$$reportNull$$$0(61);
            }
            return charSequence;
        }
        for (TextRange range2 : ranges) {
            if (range2 instanceof RangeToRemove) {
                if (range2.isEmpty()) continue;
                this.assertRangeOrder(range2);
                CharSequence textToRemove = ((RangeToRemove)range2).myTextToRemove;
                assert (textToRemove != null);
                this.myOuterAndRemoveRanges.add(new RangeToRemove(range2.getStartOffset(), textToRemove));
                continue;
            }
            this.addOuterRange(range2, range2 instanceof InsertionRange);
        }
        return this.applyOuterAndRemoveRanges(sourceCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 32: 
            case 33: 
            case 36: 
            case 47: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 32: 
            case 33: 
            case 36: 
            case 47: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateDataElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerAndRemoveRanges";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRange";
                break;
            }
            case 5: 
            case 38: 
            case 41: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToRemove";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateLanguage";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSourceCode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateSourceCode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedText";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileElement";
                break;
            }
            case 15: 
            case 23: 
            case 29: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceCode";
                break;
            }
            case 16: 
            case 24: 
            case 31: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charTable";
                break;
            }
            case 17: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementRange";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementsRanges";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLeaf";
                break;
            }
            case 30: 
            case 39: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateTreePatcher";
                break;
            }
            case 32: 
            case 33: 
            case 36: 
            case 47: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/RangeCollectorImpl";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLeaf";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextLeaf";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/RangeCollectorImpl";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "insertOuterElementFromRange";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "newLazyParseable";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLeftPartOfLeaf";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "applyRangeCollectorAndExpandChameleon";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "applyOuterAndRemoveRanges";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRange";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTemplateDataModifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addOuterRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRangeToRemove";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertRangeOrder";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareFileForParsing";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDummyStringsToRangesToRemove";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertDummyStringIntoInsertionRanges";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "insertOuterElementsAndRemoveRanges";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findFirstSuitableElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findNextSuitableElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableElement";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "insertLastOuterElementForRange";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isLastRange";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "insertOuterElementFromRange";
                break;
            }
            case 32: 
            case 33: 
            case 36: 
            case 47: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 61: {
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "newLazyParseable";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeElementsForRange";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "splitOrRemoveRangeInsideLeafIfOverlap";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeLeftPartOfLeaf";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "applyRangeCollectorAndExpandChameleon";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "applyTemplateDataModifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 32: 
            case 33: 
            case 36: 
            case 47: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 58: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class InsertionRange
    extends TextRange {
        InsertionRange(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        @NotNull
        public TextRange shiftLeft(int delta) {
            if (delta == 0) {
                InsertionRange insertionRange = this;
                if (insertionRange == null) {
                    InsertionRange.$$$reportNull$$$0(0);
                }
                return insertionRange;
            }
            return new InsertionRange(this.getStartOffset() - delta, this.getEndOffset() - delta);
        }

        public String toString() {
            return "InsertionRange" + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/RangeCollectorImpl$InsertionRange", "shiftLeft"));
        }
    }

    static final class RangeToRemove
    extends TextRange {
        @Nullable
        public final CharSequence myTextToRemove;

        RangeToRemove(int startOffset, @NotNull CharSequence text) {
            if (text == null) {
                RangeToRemove.$$$reportNull$$$0(0);
            }
            super(startOffset, startOffset + text.length());
            this.myTextToRemove = text;
        }

        RangeToRemove(int startOffset, int endOffset) {
            super(startOffset, endOffset);
            this.myTextToRemove = null;
        }

        @NotNull
        public TextRange shiftLeft(int delta) {
            if (delta == 0) {
                RangeToRemove rangeToRemove = this;
                if (rangeToRemove == null) {
                    RangeToRemove.$$$reportNull$$$0(1);
                }
                return rangeToRemove;
            }
            return this.myTextToRemove != null ? new RangeToRemove(this.getStartOffset() - delta, this.myTextToRemove) : new RangeToRemove(this.getStartOffset() - delta, this.getEndOffset() - delta);
        }

        public String toString() {
            return "RangeToRemove" + super.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/templateLanguages/RangeCollectorImpl$RangeToRemove";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/templateLanguages/RangeCollectorImpl$RangeToRemove";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shiftLeft";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

