/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import com.intellij.util.indexing.roots.IndexableFilesProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00122\u0006\u0010\f\u001a\u00020\rJ$\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018R\u001c\u0010\u0003\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticDumper;", "", "()V", "pusherName", "", "Lcom/intellij/openapi/roots/impl/FilePropertyPusher;", "getPusherName", "(Lcom/intellij/openapi/roots/impl/FilePropertyPusher;)Ljava/lang/String;", "createIndexedFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "doesFileHaveProvidedIndex", "", "file", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "dumpFilePropertyPusherValues", "", "getIndexContentDiagnostic", "Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnostic;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.lang.impl"})
public final class IndexContentDiagnosticDumper {
    public static final IndexContentDiagnosticDumper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexContentDiagnostic getIndexContentDiagnostic(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        List<IndexableFilesProvider> list2 = ((FileBasedIndexImpl)fileBasedIndex).getOrderedIndexableFilesProviders(project);
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"(FileBasedIndex.getInsta\u2026leFilesProviders(project)");
        List<IndexableFilesProvider> providers = list2;
        ConcurrentBitSet visitedFiles = new ConcurrentBitSet();
        indicator.setText(IndexingBundle.message((String)"index.content.diagnostic.dumping", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        boolean bl = false;
        ArrayList indexedFilePaths = new ArrayList();
        boolean bl2 = false;
        HashMap providerNameToOriginalFileIds = new HashMap();
        boolean bl3 = false;
        ArrayList filesFromUnsupportedFileSystem = new ArrayList();
        ExtensionPointName extensionPointName = FileBasedIndexExtension.EXTENSION_POINT_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"FileBasedIndexExtension.EXTENSION_POINT_NAME");
        List list3 = extensionPointName.getExtensionList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"FileBasedIndexExtension.\u2026_POINT_NAME.extensionList");
        List fileBasedIndexExtensions = list3;
        Stream stream = FileBasedIndexInfrastructureExtension.EP_NAME.extensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)stream, (String)"FileBasedIndexInfrastruc\u2026sion.EP_NAME.extensions()");
        List infrastructureExtensions2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<FileBasedIndexInfrastructureExtension, FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor>(project){
            final /* synthetic */ Project $project;

            @Nullable
            public final FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor invoke(FileBasedIndexInfrastructureExtension it) {
                return it.createFileIndexingStatusProcessor(this.$project);
            }
            {
                this.$project = project;
                super(1);
            }
        })));
        boolean bl4 = false;
        HashMap providedIndexIdToIndexedFiles = new HashMap();
        bl4 = false;
        Iterator iterator2 = ((Iterable)providers).iterator();
        while (iterator2.hasNext()) {
            void index;
            IndexableFilesProvider provider;
            IndexableFilesProvider indexableFilesProvider = provider = (IndexableFilesProvider)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)indexableFilesProvider, (String)"provider");
            indicator.setText2(indexableFilesProvider.getDebugName());
            boolean bl5 = false;
            HashSet providerFileIds = new HashSet();
            Map map2 = providerNameToOriginalFileIds;
            String string = provider.getDebugName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"provider.debugName");
            map2.put(string, providerFileIds);
            provider.iterateFiles(project, new ContentIterator(fileBasedIndexExtensions, infrastructureExtensions2, providedIndexIdToIndexedFiles, project, indexedFilePaths, providerFileIds, filesFromUnsupportedFileSystem){
                final /* synthetic */ List $fileBasedIndexExtensions;
                final /* synthetic */ List $infrastructureExtensions;
                final /* synthetic */ HashMap $providedIndexIdToIndexedFiles;
                final /* synthetic */ Project $project;
                final /* synthetic */ ArrayList $indexedFilePaths;
                final /* synthetic */ HashSet $providerFileIds;
                final /* synthetic */ ArrayList $filesFromUnsupportedFileSystem;

                /*
                 * WARNING - void declaration
                 */
                public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                    Object object;
                    Intrinsics.checkParameterIsNotNull((Object)fileOrDir, (String)"fileOrDir");
                    int fileId = FileBasedIndex.getFileId((VirtualFile)fileOrDir);
                    for (FileBasedIndexExtension extension : this.$fileBasedIndexExtensions) {
                        Object object2;
                        String key$iv;
                        void $this$getOrPut$iv;
                        boolean bl;
                        Object $this$any$iv;
                        block7: {
                            $this$any$iv = this.$infrastructureExtensions;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                Iterator<T> iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    T element$iv = iterator2.next();
                                    FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor it = (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor)element$iv;
                                    boolean bl2 = false;
                                    if (!it.hasIndexForFile(fileOrDir, fileId, extension)) continue;
                                    bl = true;
                                    break block7;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        $this$any$iv = this.$providedIndexIdToIndexedFiles;
                        FileBasedIndexExtension fileBasedIndexExtension = extension;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileBasedIndexExtension, (String)"extension");
                        ID iD = fileBasedIndexExtension.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)iD, (String)"extension.name");
                        Intrinsics.checkExpressionValueIsNotNull((Object)iD.getName(), (String)"extension.name.name");
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl3 = false;
                            boolean bl4 = false;
                            HashSet<E> answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        Collection collection = (Set)object2;
                        Integer n = fileId;
                        boolean bl5 = false;
                        collection.add(n);
                    }
                    IndexedFilePath indexedFilePath = IndexContentDiagnosticDumper.INSTANCE.createIndexedFilePath(fileOrDir, this.$project);
                    if (!PortableFilePaths.INSTANCE.isSupportedFileSystem(fileOrDir)) {
                        object = this.$filesFromUnsupportedFileSystem;
                        boolean bl = false;
                        object.add(indexedFilePath);
                        return true;
                    }
                    object = this.$indexedFilePaths;
                    boolean bl = false;
                    object.add(indexedFilePath);
                    object = this.$providerFileIds;
                    Integer n = indexedFilePath.getOriginalFileSystemId();
                    boolean bl6 = false;
                    object.add(n);
                    return true;
                }
                {
                    this.$fileBasedIndexExtensions = list2;
                    this.$infrastructureExtensions = list3;
                    this.$providedIndexIdToIndexedFiles = hashMap;
                    this.$project = project;
                    this.$indexedFilePaths = arrayList;
                    this.$providerFileIds = hashSet;
                    this.$filesFromUnsupportedFileSystem = arrayList2;
                }
            }, visitedFiles);
            indicator.setFraction((double)(index + true) / (double)providers.size());
            ++index;
        }
        return new IndexContentDiagnostic(indexedFilePaths, providedIndexIdToIndexedFiles, filesFromUnsupportedFileSystem, providerNameToOriginalFileIds);
    }

    public final boolean doesFileHaveProvidedIndex(@NotNull VirtualFile file2, @NotNull FileBasedIndexExtension<?, ?> extension, @NotNull Project project) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull(extension, (String)"extension");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            int fileId = FileBasedIndex.getFileId((VirtualFile)file2);
            Stream stream = FileBasedIndexInfrastructureExtension.EP_NAME.extensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)stream, (String)"FileBasedIndexInfrastruc\u2026sion.EP_NAME.extensions()");
            Sequence $this$any$iv = SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<FileBasedIndexInfrastructureExtension, FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor>(project){
                final /* synthetic */ Project $project;

                @Nullable
                public final FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor invoke(FileBasedIndexInfrastructureExtension it) {
                    return it.createFileIndexingStatusProcessor(this.$project);
                }
                {
                    this.$project = project;
                    super(1);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor it = (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor)element$iv;
                boolean bl2 = false;
                if (!it.hasIndexForFile(file2, fileId, extension)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexedFilePath createIndexedFilePath(@NotNull VirtualFile fileOrDir, @NotNull Project project) {
        Object object;
        void $this$mapValuesTo$iv$iv;
        String string;
        String fileType;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)fileOrDir, (String)"fileOrDir");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        int fileId = FileBasedIndex.getFileId((VirtualFile)fileOrDir);
        String string3 = fileOrDir.getUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fileOrDir.url");
        String fileUrl = string3;
        if (fileOrDir.isDirectory()) {
            string2 = null;
        } else {
            FileType fileType2 = fileOrDir.getFileType();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType2, (String)"fileOrDir.fileType");
            string2 = fileType = fileType2.getName();
        }
        if (fileOrDir.isDirectory()) {
            string = null;
        } else {
            boolean $i$f$runReadAction = false;
            string = (String)ApplicationManager.getApplication().runReadAction(new Computable<T>(fileOrDir, project, fileType){
                final /* synthetic */ VirtualFile $fileOrDir$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $fileType$inlined;
                {
                    this.$fileOrDir$inlined = virtualFile;
                    this.$project$inlined = project;
                    this.$fileType$inlined = string;
                }

                public final T compute() {
                    boolean bl = false;
                    FileType fileType = SubstitutedFileType.substituteFileType(this.$fileOrDir$inlined, this.$fileOrDir$inlined.getFileType(), this.$project$inlined);
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"SubstitutedFileType.subs\u2026eOrDir.fileType, project)");
                    String string = fileType.getName();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it = string;
                    boolean bl4 = false;
                    return (T)(Intrinsics.areEqual((Object)it, (Object)this.$fileType$inlined) ^ true ? string : null);
                }
            });
        }
        String substitutedFileType = string;
        Long fileSize = fileOrDir.isDirectory() ? null : Long.valueOf(fileOrDir.getLength());
        PortableFilePath portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(fileOrDir, project);
        VirtualFile resolvedFile = PortableFilePaths.INSTANCE.findFileByPath(portableFilePath, project);
        Map<String, Object> $this$mapValues$iv = this.dumpFilePropertyPusherValues(fileOrDir, project);
        boolean $i$f$mapValues = false;
        Map<String, Object> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            object = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = object;
            Map map4 = map3;
            boolean bl2 = false;
            Object v = it.getValue();
            if (v == null || (v = v.toString()) == null) {
                v = "<null-value>";
            }
            Object v2 = v;
            map4.put(k, v2);
        }
        Map allPusherValues = destination$iv$iv;
        IndexedFilePath indexedFilePath = new IndexedFilePath(fileId, fileType, substitutedFileType, fileSize, fileUrl, portableFilePath, allPusherValues);
        VirtualFile virtualFile = resolvedFile;
        boolean bl = Intrinsics.areEqual((Object)fileUrl, (Object)(virtualFile != null ? virtualFile.getUrl() : null));
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            boolean bl6 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl7 = false;
            boolean bl8 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl9 = false;
            StringBuilder stringBuilder2 = $this$buildString;
            object = "File cannot be resolved";
            boolean bl10 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            stringBuilder2 = $this$buildString;
            object = "Original URL: " + fileUrl;
            bl10 = false;
            StringBuilder stringBuilder4 = stringBuilder2.append((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            stringBuilder2 = $this$buildString;
            VirtualFile virtualFile2 = resolvedFile;
            object = "Resolved URL: " + (virtualFile2 != null ? virtualFile2.getUrl() : null);
            bl10 = false;
            StringBuilder stringBuilder5 = stringBuilder2.append((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            stringBuilder2 = $this$buildString;
            object = indexedFilePath.toString();
            bl10 = false;
            StringBuilder stringBuilder6 = stringBuilder2.append((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
            String string4 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
            String string5 = string4;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        return indexedFilePath;
    }

    @NotNull
    public final Map<String, Object> dumpFilePropertyPusherValues(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        boolean bl = false;
        HashMap map2 = new HashMap();
        FilePropertyPusher.EP_NAME.forEachExtensionSafe(new Consumer<FilePropertyPusher<?>>(file2, project, map2){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashMap $map;

            public final void accept(FilePropertyPusher<?> pusher) {
                if (this.$file.isDirectory() && pusher.acceptsDirectory(this.$file, this.$project) || !this.$file.isDirectory() && pusher.acceptsFile(this.$file, this.$project)) {
                    Map map2 = this.$map;
                    FilePropertyPusher<?> filePropertyPusher = pusher;
                    Intrinsics.checkExpressionValueIsNotNull(filePropertyPusher, (String)"pusher");
                    map2.put(IndexContentDiagnosticDumper.access$getPusherName$p(IndexContentDiagnosticDumper.INSTANCE, filePropertyPusher), pusher.getImmediateValue(this.$project, this.$file));
                }
            }
            {
                this.$file = virtualFile;
                this.$project = project;
                this.$map = hashMap;
            }
        });
        return map2;
    }

    private final String getPusherName(@NotNull FilePropertyPusher<?> $this$pusherName) {
        String string = $this$pusherName.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.name");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)"com."), (CharSequence)"intellij."), (CharSequence)"jetbrains."), (String)"util.", (String)"", (boolean)false, (int)4, null), (String)"impl.", (String)"", (boolean)false, (int)4, null);
    }

    private IndexContentDiagnosticDumper() {
    }

    static {
        IndexContentDiagnosticDumper indexContentDiagnosticDumper;
        INSTANCE = indexContentDiagnosticDumper = new IndexContentDiagnosticDumper();
    }

    public static final /* synthetic */ String access$getPusherName$p(IndexContentDiagnosticDumper $this, FilePropertyPusher $this$access_u24pusherName_u24p) {
        return $this.getPusherName($this$access_u24pusherName_u24p);
    }
}

