/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectAndCompareWithSelectedRevisionAction
extends AbstractVcsAction {
    @Override
    protected void actionPerformed(@NotNull VcsContext vcsContext) {
        if (vcsContext == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(0);
        }
        Project project = vcsContext.getProject();
        VirtualFile file = vcsContext.getSelectedFile();
        if (project == null || file == null) {
            return;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        if (vcs == null) {
            return;
        }
        RevisionSelector selector = vcs.getRevisionSelector();
        DiffProvider diffProvider = vcs.getDiffProvider();
        if (selector == null || diffProvider == null) {
            return;
        }
        VcsRevisionNumber vcsRevisionNumber = selector.selectNumber(file);
        if (vcsRevisionNumber != null) {
            DiffActionExecutor.showDiff(diffProvider, vcsRevisionNumber, file, project);
        }
    }

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation) {
        boolean isVisible;
        if (vcsContext == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(2);
        }
        presentation.setEnabled((isVisible = SelectAndCompareWithSelectedRevisionAction.isVisible(vcsContext)) && SelectAndCompareWithSelectedRevisionAction.isEnabled(vcsContext));
        presentation.setVisible(isVisible);
    }

    private static boolean isVisible(@NotNull VcsContext vcsContext) {
        Project project;
        if (vcsContext == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(3);
        }
        if ((project = vcsContext.getProject()) == null) {
            return false;
        }
        Object[] vcss = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
        return ContainerUtil.exists((Object[])vcss, SelectAndCompareWithSelectedRevisionAction::canShowDiffForVcs);
    }

    private static boolean isEnabled(@NotNull VcsContext vcsContext) {
        if (vcsContext == null) {
            SelectAndCompareWithSelectedRevisionAction.$$$reportNull$$$0(4);
        }
        Project project = vcsContext.getProject();
        VirtualFile file = vcsContext.getSelectedFile();
        if (project == null || file == null || file.isDirectory()) {
            return false;
        }
        AbstractVcs vcs = ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project);
        if (!SelectAndCompareWithSelectedRevisionAction.canShowDiffForVcs(vcs)) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus((Project)project, (VirtualFile)file);
    }

    private static boolean canShowDiffForVcs(@Nullable AbstractVcs vcs) {
        return vcs != null && vcs.getDiffProvider() != null && vcs.getRevisionSelector() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/SelectAndCompareWithSelectedRevisionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

