/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/completion/ml/common/LocationFeaturesUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "indentLevel", "", "line", "", "tabSize", "linesDiff", "completionParameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "completionElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "intellij.statsCollector"})
public final class LocationFeaturesUtil {
    private static final Logger LOG;
    public static final LocationFeaturesUtil INSTANCE;

    public final int indentLevel(@NotNull String line, int tabSize) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        if (tabSize <= 0) {
            return 0;
        }
        int indentLevel = 0;
        int spaces = 0;
        String string = line;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char ch = string.charAt(i);
            if (spaces == tabSize) {
                ++indentLevel;
                spaces = 0;
            }
            if (ch == '\t') {
                ++indentLevel;
                spaces = 0;
                continue;
            }
            if (ch != ' ') break;
            ++spaces;
        }
        return indentLevel;
    }

    @Nullable
    public final Integer linesDiff(@NotNull CompletionParameters completionParameters, @Nullable PsiElement completionElement) {
        Intrinsics.checkParameterIsNotNull((Object)completionParameters, (String)"completionParameters");
        if (completionElement == null) {
            return null;
        }
        Function1<PsiElement, Integer> $fun$line$1 = new Function1<PsiElement, Integer>(completionParameters){
            final /* synthetic */ CompletionParameters $completionParameters;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Integer invoke(@Nullable PsiElement element) {
                int n;
                int textOffset;
                if (element == null) {
                    return null;
                }
                PsiElement psiElement = this.$completionParameters.getPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"completionParameters.position");
                if (Intrinsics.areEqual((Object)psiElement.getContainingFile(), (Object)element.getContainingFile())) {
                    textOffset = element.getTextOffset();
                    if (textOffset == -1) {
                        return null;
                    }
                    PsiElement psiElement2 = this.$completionParameters.getPosition();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"completionParameters.position");
                    n = textOffset <= psiElement2.getTextOffset() ? textOffset : textOffset - "IntellijIdeaRulezzz ".length();
                } else if (Intrinsics.areEqual((Object)this.$completionParameters.getOriginalFile(), (Object)element.getContainingFile())) {
                    void var3_2;
                    textOffset = element.getTextOffset();
                    if (textOffset == -1) {
                        return null;
                    }
                    n = var3_2;
                } else {
                    return null;
                }
                int offset = n;
                Editor editor = this.$completionParameters.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"completionParameters.editor");
                return editor.getDocument().getLineNumber(offset);
            }
            {
                this.$completionParameters = completionParameters;
                super(1);
            }
        };
        try {
            Integer n = $fun$line$1.invoke(completionParameters.getPosition());
            if (n == null) {
                return null;
            }
            int positionLine = n;
            Integer n2 = $fun$line$1.invoke(completionElement);
            if (n2 == null) {
                return null;
            }
            int elementLine = n2;
            return positionLine - elementLine;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            LOG.error("Error while calculating lines diff", e);
            return null;
        }
    }

    private LocationFeaturesUtil() {
    }

    static {
        LocationFeaturesUtil locationFeaturesUtil;
        INSTANCE = locationFeaturesUtil = new LocationFeaturesUtil();
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(LocationFeaturesUtil.javaClass)");
        LOG = logger;
    }
}

