/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifierSplitter
extends BaseSplitter {
    private static final IdentifierSplitter INSTANCE = new IdentifierSplitter();
    @NonNls
    private static final Pattern WORD = Pattern.compile("\\b\\p{L}*'?\\p{L}*");
    @NonNls
    private static final Pattern WORD_IN_QUOTES = Pattern.compile("'([^']*)'");

    public static IdentifierSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (range == null) {
            IdentifierSplitter.$$$reportNull$$$0(0);
        }
        if (text == null || range.getLength() < 1 || range.getStartOffset() < 0) {
            return;
        }
        List<TextRange> extracted = IdentifierSplitter.excludeByPattern(text, range, WORD_IN_QUOTES, 1);
        for (TextRange textRange : extracted) {
            List<TextRange> words = IdentifierSplitter.splitByCase(text, textRange);
            if (words.size() == 0) continue;
            if (words.size() == 1) {
                IdentifierSplitter.addWord(consumer, false, words.get(0));
                continue;
            }
            boolean isCapitalized = Strings.isCapitalized(text, words.get(0));
            boolean containsShortWord = IdentifierSplitter.containsShortWord(words);
            if (isCapitalized && containsShortWord) continue;
            boolean isAllWordsAreUpperCased = IdentifierSplitter.isAllWordsAreUpperCased(text, words);
            for (TextRange word : words) {
                boolean uc = Strings.isUpperCased(text, word);
                boolean flag = uc && !isAllWordsAreUpperCased;
                try {
                    Matcher matcher = WORD.matcher(IdentifierSplitter.newBombedCharSequence(word.substring(text)));
                    if (!matcher.find()) continue;
                    TextRange found = IdentifierSplitter.matcherRange(word, matcher);
                    IdentifierSplitter.addWord(consumer, flag, found);
                }
                catch (ProcessCanceledException e) {
                    return;
                }
            }
        }
    }

    @NotNull
    private static List<TextRange> splitByCase(@NotNull String text, @NotNull TextRange range) {
        if (text == null) {
            IdentifierSplitter.$$$reportNull$$$0(1);
        }
        if (range == null) {
            IdentifierSplitter.$$$reportNull$$$0(2);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int i = range.getStartOffset();
        int s = -1;
        int prevType = 25;
        while (i < range.getEndOffset()) {
            char ch = text.charAt(i);
            if (ch >= '\u3040' && ch <= '\u309f' || ch >= '\u30a0' && ch <= '\u30ff' || ch >= '\u4e00' && ch <= '\u9fff' || ch >= '\uf900' && ch <= '\ufaff' || ch >= '\uff00' && ch <= '\uffef') {
                if (s >= 0) {
                    IdentifierSplitter.add(text, result, i, s);
                    s = -1;
                }
                prevType = 25;
                ++i;
                continue;
            }
            int type = Character.getType(ch);
            if (type == 2 || type == 1 || type == 3 || type == 5 || type == 4 || type == 24) {
                if (s < 0) {
                    s = i;
                } else if (type == 1 && prevType == 2) {
                    IdentifierSplitter.add(text, result, i, s);
                    s = i;
                } else if (i - s >= 1 && type == 2 && prevType == 1) {
                    IdentifierSplitter.add(text, result, i - 1, s);
                    s = i - 1;
                }
            } else if (s >= 0) {
                IdentifierSplitter.add(text, result, i, s);
                s = -1;
            }
            prevType = type;
            ++i;
        }
        if (s >= 0) {
            IdentifierSplitter.add(text, result, i, s);
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            IdentifierSplitter.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static void add(String text, List<TextRange> result, int i, int s) {
        if (i - s > 3) {
            TextRange textRange = new TextRange(s, i);
            result.add(textRange);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/IdentifierSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/IdentifierSplitter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitByCase";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

