/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.DocumentBuilder;
import org.apache.solr.update.UpdateCommand;

public class AddUpdateCommand
extends UpdateCommand {
    public SolrInputDocument solrDoc;
    public long prevVersion = -1L;
    public boolean overwrite = true;
    public Term updateTerm;
    public int commitWithin = -1;
    public boolean isLastDocInBatch = false;
    public Boolean isNested = null;
    private BytesRef indexedId;

    public AddUpdateCommand(SolrQueryRequest req) {
        super(req);
    }

    @Override
    public String name() {
        return "add";
    }

    public void clear() {
        this.solrDoc = null;
        this.indexedId = null;
        this.updateTerm = null;
        this.isLastDocInBatch = false;
        this.version = 0L;
        this.prevVersion = -1L;
    }

    public SolrInputDocument getSolrInputDocument() {
        return this.solrDoc;
    }

    public Document getLuceneDocument() {
        boolean ignoreNestedDocs = false;
        SolrInputDocument solrInputDocument = this.getSolrInputDocument();
        if (!this.isInPlaceUpdate() && this.getReq().getSchema().isUsableForChildDocs()) {
            this.addRootField(solrInputDocument, this.getRootIdUsingRouteParam());
        }
        return DocumentBuilder.toDocument(solrInputDocument, this.req.getSchema(), this.isInPlaceUpdate(), false);
    }

    public BytesRef getIndexedId() {
        IndexSchema schema;
        SchemaField sf;
        if (this.indexedId == null && (sf = (schema = this.req.getSchema()).getUniqueKeyField()) != null && this.solrDoc != null) {
            int count;
            SolrInputField field = this.solrDoc.getField(sf.getName());
            int n = count = field == null ? 0 : field.getValueCount();
            if (count == 0) {
                if (this.overwrite) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document is missing mandatory uniqueKey field: " + sf.getName());
                }
            } else {
                if (count > 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document contains multiple values for uniqueKey field: " + field);
                }
                BytesRefBuilder b = new BytesRefBuilder();
                sf.getType().readableToIndexed(field.getFirstValue().toString(), b);
                this.indexedId = b.get();
            }
        }
        return this.indexedId;
    }

    public void setIndexedId(BytesRef indexedId) {
        this.indexedId = indexedId;
    }

    public String getPrintableId() {
        if (this.req != null) {
            SolrInputField field;
            IndexSchema schema = this.req.getSchema();
            SchemaField sf = schema.getUniqueKeyField();
            if (this.solrDoc != null && sf != null && (field = this.solrDoc.getField(sf.getName())) != null) {
                return field.getFirstValue().toString();
            }
        }
        return "(null)";
    }

    public String getRootIdUsingRouteParam() {
        return this.req.getParams().get("_route_", this.getHashableId());
    }

    public String getHashableId() {
        IndexSchema schema = this.req.getSchema();
        SchemaField sf = schema.getUniqueKeyField();
        if (sf != null && this.solrDoc != null) {
            int count;
            SolrInputField field = this.solrDoc.getField(sf.getName());
            int n = count = field == null ? 0 : field.getValueCount();
            if (count == 0) {
                if (this.overwrite) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document is missing mandatory uniqueKey field: " + sf.getName());
                }
            } else {
                if (count > 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document contains multiple values for uniqueKey field: " + field);
                }
                return field.getFirstValue().toString();
            }
        }
        return null;
    }

    public Iterable<Document> getLuceneDocsIfNested() {
        assert (!this.isInPlaceUpdate()) : "We don't expect this to happen.";
        if (!this.req.getSchema().isUsableForChildDocs()) {
            return null;
        }
        List<SolrInputDocument> all = this.flatten(this.solrDoc);
        if (all.size() <= 1) {
            return null;
        }
        String rootId = this.getRootIdUsingRouteParam();
        SolrInputField versionSif = this.solrDoc.get((Object)"_version_");
        for (SolrInputDocument sdoc : all) {
            this.addRootField(sdoc, rootId);
            if (versionSif == null) continue;
            this.addVersionField(sdoc, versionSif);
        }
        return () -> all.stream().map(sdoc -> DocumentBuilder.toDocument(sdoc, this.req.getSchema())).iterator();
    }

    private void addRootField(SolrInputDocument sdoc, String rootId) {
        sdoc.setField("_root_", (Object)rootId);
    }

    private void addVersionField(SolrInputDocument sdoc, SolrInputField versionSif) {
        sdoc.put("_version_", versionSif);
    }

    private List<SolrInputDocument> flatten(SolrInputDocument root) {
        ArrayList<SolrInputDocument> unwrappedDocs = new ArrayList<SolrInputDocument>();
        this.flattenAnonymous(unwrappedDocs, root, true);
        this.flattenLabelled(unwrappedDocs, root, true);
        unwrappedDocs.add(root);
        return unwrappedDocs;
    }

    private void flattenLabelled(List<SolrInputDocument> unwrappedDocs, SolrInputDocument currentDoc, boolean isRoot) {
        for (SolrInputField field : currentDoc.values()) {
            Object value = field.getFirstValue();
            if (!(value instanceof SolrInputDocument)) continue;
            Object val = field.getValue();
            if (!(val instanceof Collection)) {
                this.flattenLabelled(unwrappedDocs, (SolrInputDocument)val);
                continue;
            }
            Collection childrenList = (Collection)val;
            for (SolrInputDocument child : childrenList) {
                this.flattenLabelled(unwrappedDocs, child);
            }
        }
        if (!isRoot) {
            unwrappedDocs.add(currentDoc);
        }
    }

    private void flattenLabelled(List<SolrInputDocument> unwrappedDocs, SolrInputDocument currentDoc) {
        if (currentDoc.hasChildDocuments()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Anonymous child docs can only hang from others or the root: " + currentDoc);
        }
        this.flattenLabelled(unwrappedDocs, currentDoc, false);
    }

    private void flattenAnonymous(List<SolrInputDocument> unwrappedDocs, SolrInputDocument currentDoc, boolean isRoot) {
        List children = currentDoc.getChildDocuments();
        if (children != null) {
            for (SolrInputDocument child : children) {
                this.flattenAnonymous(unwrappedDocs, child);
            }
        }
        if (!isRoot) {
            unwrappedDocs.add(currentDoc);
        }
    }

    private void flattenAnonymous(List<SolrInputDocument> unwrappedDocs, SolrInputDocument currentDoc) {
        this.flattenAnonymous(unwrappedDocs, currentDoc, false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(",id=").append(this.getPrintableId());
        if (!this.overwrite) {
            sb.append(",overwrite=").append(this.overwrite);
        }
        if (this.commitWithin != -1) {
            sb.append(",commitWithin=").append(this.commitWithin);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean isInPlaceUpdate() {
        return this.prevVersion >= 0L;
    }
}

