/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp;

import com.cloudhopper.commons.util.windowing.Window;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionCounters;
import com.cloudhopper.smpp.pdu.EnquireLink;
import com.cloudhopper.smpp.pdu.EnquireLinkResp;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.pdu.SubmitSmResp;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;

public interface SmppSession {
    public static final int STATE_INITIAL = 0;
    public static final int STATE_OPEN = 1;
    public static final int STATE_BINDING = 2;
    public static final int STATE_BOUND = 3;
    public static final int STATE_UNBINDING = 4;
    public static final int STATE_CLOSED = 5;
    public static final String[] STATES = new String[]{"INITIAL", "OPEN", "BINDING", "BOUND", "UNBINDING", "CLOSED"};

    public SmppBindType getBindType();

    public Type getLocalType();

    public Type getRemoteType();

    public SmppSessionConfiguration getConfiguration();

    public String getStateName();

    public byte getInterfaceVersion();

    public boolean areOptionalParametersSupported();

    public boolean isOpen();

    public boolean isBinding();

    public boolean isBound();

    public boolean isUnbinding();

    public boolean isClosed();

    public long getBoundTime();

    public Window<Integer, PduRequest, PduResponse> getRequestWindow();

    public Window<Integer, PduRequest, PduResponse> getSendWindow();

    public boolean hasCounters();

    public SmppSessionCounters getCounters();

    public void close();

    public void unbind(long var1);

    public void destroy();

    public EnquireLinkResp enquireLink(EnquireLink var1, long var2) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException;

    public SubmitSmResp submit(SubmitSm var1, long var2) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException;

    public WindowFuture<Integer, PduRequest, PduResponse> sendRequestPdu(PduRequest var1, long var2, boolean var4) throws RecoverablePduException, UnrecoverablePduException, SmppTimeoutException, SmppChannelException, InterruptedException;

    public void sendResponsePdu(PduResponse var1) throws RecoverablePduException, UnrecoverablePduException, SmppChannelException, InterruptedException;

    public static enum Type {
        SERVER,
        CLIENT;

    }
}

