/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.BeanProperty;
import com.cloudhopper.commons.util.ClassUtil;
import com.cloudhopper.commons.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    private static Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static BeanProperty findBeanProperty(Class type, String propertyName, boolean caseSensitive) throws IllegalAccessException {
        Class classType;
        BeanProperty beanProperty = null;
        block6: for (classType = type; classType != null && !classType.equals(Object.class); classType = classType.getSuperclass()) {
            for (Field f : classType.getDeclaredFields()) {
                String fieldName = f.getName();
                if ((caseSensitive || !fieldName.equalsIgnoreCase(propertyName)) && (!caseSensitive || !fieldName.equals(propertyName))) continue;
                Class<?> fieldType = f.getType();
                f.setAccessible(true);
                beanProperty = new BeanProperty(propertyName, fieldType, f);
                continue block6;
            }
        }
        String capitalizedName = StringUtil.capitalize(propertyName);
        String getMethodName = "get" + capitalizedName;
        String setMethodName = "set" + capitalizedName;
        String addMethodName = "add" + capitalizedName;
        if (beanProperty == null) {
            block8: for (classType = type; classType != null && !classType.equals(Object.class); classType = classType.getSuperclass()) {
                for (Method m : classType.getDeclaredMethods()) {
                    String methodName = m.getName();
                    if (!caseSensitive && methodName.equalsIgnoreCase(getMethodName) || caseSensitive && methodName.equals(getMethodName)) {
                        if (m.getParameterTypes().length != 0) continue;
                        beanProperty = new BeanProperty(propertyName, m.getReturnType(), null);
                        m.setAccessible(true);
                        beanProperty.getMethod = m;
                        continue block8;
                    }
                    if (!caseSensitive && methodName.equalsIgnoreCase(setMethodName) || caseSensitive && methodName.equals(setMethodName)) {
                        if (m.getParameterTypes().length != 1) continue;
                        beanProperty = new BeanProperty(propertyName, m.getParameterTypes()[0], null);
                        m.setAccessible(true);
                        beanProperty.setMethod = m;
                        continue block8;
                    }
                    if ((caseSensitive || !methodName.equalsIgnoreCase(addMethodName)) && (!caseSensitive || !methodName.equals(addMethodName)) || m.getParameterTypes().length != 1) continue;
                    beanProperty = new BeanProperty(propertyName, m.getParameterTypes()[0], null);
                    m.setAccessible(true);
                    beanProperty.addMethod = m;
                    continue block8;
                }
            }
        }
        if (beanProperty != null) {
            if (beanProperty.getMethod == null) {
                try {
                    Method getMethod = ClassUtil.getMethod(type, getMethodName, beanProperty.getType(), null, caseSensitive);
                    getMethod.setAccessible(true);
                    beanProperty.getMethod = getMethod;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (beanProperty.setMethod == null) {
                try {
                    Method setMethod = ClassUtil.getMethod(type, setMethodName, null, beanProperty.getType(), caseSensitive);
                    setMethod.setAccessible(true);
                    beanProperty.setMethod = setMethod;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (beanProperty.addMethod == null) {
                try {
                    Method addMethod = ClassUtil.getMethod(type, addMethodName, null, beanProperty.getType(), caseSensitive);
                    addMethod.setAccessible(true);
                    beanProperty.addMethod = addMethod;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        return beanProperty;
    }
}

