/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import delight.nashornsandbox.NashornSandbox;
import delight.nashornsandbox.NashornSandboxes;
import delight.nashornsandbox.exceptions.ScriptAbuseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.script.Invocable;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;

public class PacScript {
    private static final String GMT_TIME_ZONE = "GMT";
    private static final List<String> MONTHS = Collections.unmodifiableList(Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"));
    static final List<String> DAYS = Collections.unmodifiableList(Arrays.asList("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"));
    private static final String SETTINGS_SEPARATOR = ";";
    private static final String TYPE_PROXY_DATA_SEPARATOR = " ";
    private static final String HOST_PORT_SEPARATOR = ":";
    private final Invocable pacImpl;
    private Clock baseClock;

    public PacScript(URL scriptUrl) throws IOException, ScriptException {
        this(PacScript.readUrl(Objects.requireNonNull(scriptUrl)));
    }

    private static String readUrl(URL scriptUrl) throws IOException {
        return IOUtils.toString((InputStream)scriptUrl.openStream(), (Charset)StandardCharsets.UTF_8);
    }

    public PacScript(Path file) throws IOException, ScriptException {
        this(new String(Files.readAllBytes(Objects.requireNonNull(file)), StandardCharsets.UTF_8));
    }

    public PacScript(String scriptContent) throws ScriptException {
        if (scriptContent == null || scriptContent.isEmpty()) {
            throw new IllegalArgumentException("The PAC script content must not be null or empty.");
        }
        this.baseClock = Clock.systemDefaultZone();
        NashornSandbox sandbox = NashornSandboxes.create((String[])new String[]{"-nse"});
        sandbox.inject("dateRange", this::dateRange);
        sandbox.inject("dnsDomainIs", PacScript::dnsDomainIs);
        sandbox.inject("dnsDomainLevels", PacScript::dnsDomainLevels);
        sandbox.inject("dnsResolve", PacScript::dnsResolve);
        sandbox.inject("isInNet", PacScript::isInNet);
        sandbox.inject("isPlainHostName", PacScript::isPlainHostName);
        sandbox.inject("isResolvable", PacScript::isResolvable);
        sandbox.inject("localHostOrDomainIs", PacScript::localHostOrDomainIs);
        sandbox.inject("myIpAddress", PacScript::myIpAddress);
        sandbox.inject("shExpMatch", PacScript::shExpMatch);
        sandbox.inject("timeRange", this::timeRange);
        sandbox.inject("weekdayRange", this::weekdayRange);
        try {
            sandbox.eval(scriptContent);
        }
        catch (ScriptAbuseException e) {
            throw new ScriptException((Exception)((Object)e));
        }
        this.pacImpl = sandbox.getSandboxedInvocable();
    }

    void setBaseClock(Clock baseClock) {
        this.baseClock = baseClock;
    }

    String evaluate(String url, String host) throws ScriptException {
        try {
            return (String)this.pacImpl.invokeFunction("FindProxyForURL", url, host);
        }
        catch (ScriptAbuseException | NoSuchMethodException e) {
            throw new ScriptException((Exception)e);
        }
    }

    public List<Setting> findProxyForUrl(String url, String host) throws ScriptException {
        String result = this.evaluate(url, host);
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Setting> settings = new ArrayList<Setting>();
        for (String entry : result.split(SETTINGS_SEPARATOR, -1)) {
            String value = entry.trim();
            if (value.isEmpty()) continue;
            Setting setting = PacScript.createSetting(value);
            settings.add(setting);
            if (setting.getType() == Setting.Type.DIRECT) break;
        }
        return settings;
    }

    private static Setting createSetting(String value) throws ScriptException {
        int port;
        Setting.Type type;
        if (Setting.Type.DIRECT.name().equals(value)) {
            return Setting.DIRECT;
        }
        String[] elements = value.split(TYPE_PROXY_DATA_SEPARATOR, 2);
        if (elements.length != 2) {
            throw new ScriptException("Invalid proxy setting format, expected \"<TYPE> <HOST>:<PORT>\" got: " + value);
        }
        try {
            type = Setting.Type.valueOf(elements[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ScriptException("Invalid proxy setting type, expected \"PROXY\" or \"SOCKS\" got: " + elements[0]);
        }
        if (type == Setting.Type.DIRECT) {
            throw new ScriptException("Invalid proxy setting, expected \"PROXY\" or \"SOCKS\" type in: " + value);
        }
        String[] proxy = elements[1].split(HOST_PORT_SEPARATOR, 2);
        if (proxy.length != 2) {
            throw new ScriptException("Invalid proxy setting data, expected \"<HOST>:<PORT>\" got: " + elements[1]);
        }
        String host = proxy[0];
        if (host.isEmpty()) {
            throw new ScriptException("Invalid proxy setting host, expected non empty host in: " + elements[1]);
        }
        try {
            port = Integer.parseInt(proxy[1]);
        }
        catch (NumberFormatException e) {
            throw new ScriptException("Invalid proxy setting port, expected an integer got: " + proxy[1]);
        }
        if (port <= 0 || port > 65535) {
            throw new ScriptException("Invalid proxy setting port, expected an integer between 1 and 65535 got: " + port);
        }
        return new Setting(type, host, port);
    }

    private static boolean isDay(String value) {
        int day;
        try {
            day = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return day > 0 && day <= 31;
    }

    private static boolean isMonth(String value) {
        return MONTHS.contains(value);
    }

    private static boolean isYear(String value) {
        try {
            Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean currentDateIs(String day, String month, String year, String timeZone) {
        LocalDate currentDate = this.currentDate(timeZone);
        LocalDate givenDate = PacScript.createDate(day, month, year, currentDate);
        return currentDate.equals(givenDate);
    }

    private boolean currentDateIsBetween(String day1, String month1, String year1, String day2, String month2, String year2, String timeZone) {
        LocalDate currentDate = this.currentDate(timeZone);
        if (day1.equals("") || day2.equals("")) {
            String currentDay;
            day1 = currentDay = String.valueOf(currentDate.getDayOfMonth());
            day2 = currentDay;
        }
        if (month1.equals("") || month2.equals("")) {
            String currentMonth;
            month1 = currentMonth = String.valueOf(currentDate.getMonth().getValue());
            month2 = currentMonth;
        }
        if (year1.equals("") || year2.equals("")) {
            String currentYear;
            year1 = currentYear = String.valueOf(currentDate.getYear());
            year2 = currentYear;
        }
        LocalDate dateBefore = PacScript.createDate(day1, month1, year1, currentDate);
        LocalDate dateAfter = PacScript.createDate(day2, month2, year2, currentDate);
        return dateBefore.compareTo(currentDate) <= 0 && dateAfter.compareTo(currentDate) >= 0;
    }

    private boolean dateRange(String ... args) {
        String day1 = PacScript.extractArg(args, 0);
        String month1 = PacScript.extractArg(args, 1);
        String year1 = PacScript.extractArg(args, 2);
        String day2 = PacScript.extractArg(args, 3);
        String month2 = PacScript.extractArg(args, 4);
        String year2 = PacScript.extractArg(args, 5);
        String timeZone = PacScript.extractArg(args, 6);
        if (PacScript.isDay(day1)) {
            if (PacScript.isDay(month1)) {
                return this.currentDateIsBetween(day1, "", "", month1, "", "", year1);
            }
            if (PacScript.isMonth(month1)) {
                if (PacScript.isDay(year1) && PacScript.isMonth(day2)) {
                    return this.currentDateIsBetween(day1, String.valueOf(MONTHS.indexOf(month1) + 1), "", year1, String.valueOf(MONTHS.indexOf(day2) + 1), "", month2);
                }
                if (PacScript.isYear(year1)) {
                    if (PacScript.isDay(day2) && PacScript.isMonth(month2) && PacScript.isYear(year2)) {
                        return this.currentDateIsBetween(day1, String.valueOf(MONTHS.indexOf(month1) + 1), year1, day2, String.valueOf(MONTHS.indexOf(month2) + 1), year2, timeZone);
                    }
                    return this.currentDateIs(day1, String.valueOf(MONTHS.indexOf(month1) + 1), year1, day2);
                }
                return this.currentDateIs(day1, String.valueOf(MONTHS.indexOf(month1) + 1), "", year1);
            }
            return this.currentDateIs(day1, "", "", month1);
        }
        if (PacScript.isMonth(day1)) {
            if (PacScript.isMonth(month1)) {
                return this.currentDateIsBetween("", String.valueOf(MONTHS.indexOf(day1) + 1), "", "", String.valueOf(MONTHS.indexOf(month1) + 1), "", year1);
            }
            if (PacScript.isYear(month1)) {
                if (PacScript.isMonth(year1) && PacScript.isYear(day2)) {
                    return this.currentDateIsBetween("", String.valueOf(MONTHS.indexOf(day1) + 1), month1, "", String.valueOf(MONTHS.indexOf(year1) + 1), day2, month2);
                }
                return this.currentDateIs("", String.valueOf(MONTHS.indexOf(day1) + 1), month1, year1);
            }
            return this.currentDateIs("", String.valueOf(MONTHS.indexOf(day1) + 1), "", month1);
        }
        if (PacScript.isYear(day1)) {
            if (PacScript.isYear(month1)) {
                return this.currentDateIsBetween("", "", day1, "", "", month1, year1);
            }
            return this.currentDateIs("", "", day1, month1);
        }
        return false;
    }

    private static boolean dnsDomainIs(String hostName, String domainName) {
        return hostName.endsWith(domainName);
    }

    private static int dnsDomainLevels(String hostName) {
        int hostLength = hostName.length();
        int count = 0;
        for (int i = 0; i < hostLength; ++i) {
            if (hostName.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    private static String dnsResolve(String hostName) {
        InetAddress address;
        try {
            address = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            return "";
        }
        return address.getHostAddress();
    }

    private static boolean isInNet(String ... args) {
        String host = PacScript.extractArg(args, 0);
        String network = PacScript.extractArg(args, 1);
        String mask = PacScript.extractArg(args, 2);
        String[] hostBytes = PacScript.dnsResolve(host).split("\\.");
        String[] networkBytes = network.split("\\.");
        String[] maskBytes = mask.split("\\.");
        if (hostBytes.length != 4 || networkBytes.length != 4 || maskBytes.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int maskByte;
            int networkByte;
            int hostByte;
            try {
                hostByte = Integer.valueOf(hostBytes[i]);
                networkByte = Integer.valueOf(networkBytes[i]);
                maskByte = Integer.valueOf(maskBytes[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (hostByte < 0 || hostByte > 255 || networkByte < 0 || networkByte > 255 || maskByte < 0 || maskByte > 255) {
                return false;
            }
            if ((hostByte & maskByte) == (networkByte & maskByte)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPlainHostName(String hostName) {
        return !hostName.contains(".");
    }

    private static boolean isResolvable(String hostName) {
        try {
            InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            return false;
        }
        return true;
    }

    private static boolean localHostOrDomainIs(String hostName, String FQHN) {
        return hostName.equals(FQHN) || FQHN.startsWith(hostName + ".");
    }

    private static String myIpAddress() {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return "";
        }
        while (interfaces.hasMoreElements()) {
            Enumeration<InetAddress> interface_addresses = interfaces.nextElement().getInetAddresses();
            while (interface_addresses.hasMoreElements()) {
                InetAddress ip_address = interface_addresses.nextElement();
                if (ip_address.isLoopbackAddress()) continue;
                return ip_address.getHostAddress().replaceAll("%.*", "");
            }
        }
        return "";
    }

    private static boolean shExpMatch(String name, String expression) {
        Pattern pattern;
        expression = expression.replace(".", "\\.");
        expression = expression.replace("*", ".*");
        expression = expression.replace("?", ".");
        try {
            pattern = Pattern.compile(expression);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return pattern.matcher(name).matches();
    }

    private static boolean isHour(String val) {
        int hour;
        try {
            hour = Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return hour >= 0 && hour < 24;
    }

    private static boolean isMinOrSec(String val) {
        int minOrSec;
        try {
            minOrSec = Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return minOrSec >= 0 && minOrSec < 60;
    }

    private boolean currentTimeIs(String hour, String min, String sec, String timeZone) {
        LocalTime currentTime = this.currentTime(timeZone);
        LocalTime givenTime = PacScript.createLocalTime(hour, min, sec, currentTime);
        return currentTime.equals(givenTime);
    }

    private boolean currentTimeIsBetween(String hour1, String min1, String sec1, String hour2, String min2, String sec2, String timeZone) {
        LocalTime currentTime = this.currentTime(timeZone);
        if (min1.equals("") || min2.equals("")) {
            String currentMin;
            min1 = currentMin = String.valueOf(currentTime.getMinute());
            min2 = currentMin;
        }
        if (sec1.equals("") || sec2.equals("")) {
            String currentSec;
            sec1 = currentSec = String.valueOf(currentTime.getSecond());
            sec2 = currentSec;
        }
        LocalTime beforeTime = PacScript.createLocalTime(hour1, min1, sec1, currentTime);
        LocalTime afterTime = PacScript.createLocalTime(hour2, min2, sec2, currentTime);
        return beforeTime.compareTo(currentTime) <= 0 && afterTime.compareTo(currentTime) > 0;
    }

    private boolean timeRange(String ... args) {
        String hour1 = PacScript.extractArg(args, 0);
        String min1 = PacScript.extractArg(args, 1);
        String sec1 = PacScript.extractArg(args, 2);
        String hour2 = PacScript.extractArg(args, 3);
        String min2 = PacScript.extractArg(args, 4);
        String sec2 = PacScript.extractArg(args, 5);
        String timeZone = PacScript.extractArg(args, 6);
        List<String> argList = Arrays.asList(args);
        int numberCount = 0;
        for (String arg : argList) {
            try {
                Integer.valueOf(arg);
            }
            catch (NumberFormatException e) {
                continue;
            }
            ++numberCount;
        }
        boolean hour1IsAnHour = PacScript.isHour(hour1);
        boolean min1IsAMin = PacScript.isMinOrSec(min1);
        boolean sec1IsASec = PacScript.isMinOrSec(sec1);
        if (numberCount == 1 && hour1IsAnHour) {
            return this.currentTimeIs(hour1, "", "", min1);
        }
        if (numberCount == 2 && hour1IsAnHour && PacScript.isHour(min1)) {
            return this.currentTimeIsBetween(hour1, "", "", min1, "", "", sec1);
        }
        if (numberCount == 3 && hour1IsAnHour && min1IsAMin && sec1IsASec) {
            return this.currentTimeIs(hour1, min1, sec1, hour2);
        }
        if (numberCount == 4 && hour1IsAnHour && min1IsAMin && PacScript.isHour(sec1) && PacScript.isMinOrSec(hour2)) {
            return this.currentTimeIsBetween(hour1, min1, "", sec1, hour2, "", min2);
        }
        if (numberCount == 6 && hour1IsAnHour && min1IsAMin && sec1IsASec && PacScript.isHour(hour2) && PacScript.isMinOrSec(min2) && PacScript.isMinOrSec(sec2)) {
            return this.currentTimeIsBetween(hour1, min1, sec1, hour2, min2, sec2, timeZone);
        }
        return false;
    }

    private boolean weekdayRange(String ... args) {
        String day1 = PacScript.extractArg(args, 0);
        String day2 = PacScript.extractArg(args, 1);
        String timeZone = PacScript.extractArg(args, 2);
        if (!DAYS.contains(day1)) {
            return false;
        }
        if (!DAYS.contains(day2)) {
            return DAYS.indexOf(day1) == this.currentDayOfWeek(day2);
        }
        int currentDay = this.currentDayOfWeek(timeZone);
        int index1 = DAYS.indexOf(day1);
        int index2 = DAYS.indexOf(day2);
        return index1 <= currentDay && index2 >= currentDay || index2 < index1 && (index2 >= currentDay || index1 <= currentDay);
    }

    private int currentDayOfWeek(String timezone) {
        DayOfWeek dayOfWeek = this.currentDate(timezone).getDayOfWeek();
        return dayOfWeek.get(WeekFields.SUNDAY_START.dayOfWeek()) - 1;
    }

    private LocalDate currentDate(String timeZone) {
        return LocalDate.now(this.getClock(timeZone));
    }

    private Clock getClock(String timeZone) {
        if (GMT_TIME_ZONE.equals(timeZone)) {
            return this.baseClock.withZone(ZoneId.of(GMT_TIME_ZONE));
        }
        return this.baseClock;
    }

    private LocalTime currentTime(String timeZone) {
        return LocalTime.now(this.getClock(timeZone)).truncatedTo(ChronoUnit.SECONDS);
    }

    private static LocalDate createDate(String day, String month, String year, LocalDate defaultDate) {
        return LocalDate.of(PacScript.getInt(year, defaultDate.getYear()), PacScript.getInt(month, defaultDate.getMonth().getValue()), PacScript.getInt(day, defaultDate.getDayOfMonth()));
    }

    private static LocalTime createLocalTime(String hour, String min, String sec, LocalTime defaultTime) {
        return LocalTime.of(PacScript.getInt(hour, defaultTime.getHour()), PacScript.getInt(min, defaultTime.getMinute()), PacScript.getInt(sec, defaultTime.getSecond()));
    }

    private static int getInt(String value, int defaultValue) {
        return value.isEmpty() ? defaultValue : Integer.parseInt(value);
    }

    private static String extractArg(String[] args, int index) {
        if (args == null || index >= args.length) {
            return "";
        }
        return args[index];
    }

    public static final class Setting {
        private static final Setting DIRECT = new Setting(Type.DIRECT, null, 0);
        private final Type type;
        private final String host;
        private final int port;

        private Setting(Type type, String host, int port) {
            this.type = type;
            this.host = host;
            this.port = port;
        }

        public Type getType() {
            return this.type;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        static enum Type {
            DIRECT,
            PROXY,
            SOCKS;

        }
    }

    @FunctionalInterface
    public static interface StringPredicate {
        public boolean apply(String ... var1);
    }
}

