/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public abstract class InternalNumericMetricsAggregation
extends InternalAggregation {
    private static final DocValueFormat DEFAULT_FORMAT = DocValueFormat.RAW;
    protected DocValueFormat format = DEFAULT_FORMAT;

    private InternalNumericMetricsAggregation(String name, Map<String, Object> metadata) {
        super(name, metadata);
    }

    protected InternalNumericMetricsAggregation(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public final double sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        throw new IllegalArgumentException("Metrics aggregations cannot have sub-aggregations (at [>" + head + "]");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalNumericMetricsAggregation other = (InternalNumericMetricsAggregation)obj;
        return Objects.equals(this.format, other.format);
    }

    public static abstract class MultiValue
    extends InternalNumericMetricsAggregation
    implements NumericMetricsAggregation.MultiValue {
        protected MultiValue(String name, Map<String, Object> metadata) {
            super(name, metadata);
        }

        protected MultiValue(StreamInput in) throws IOException {
            super(in);
        }

        public abstract double value(String var1);

        public String valueAsString(String name) {
            return this.format.format(this.value(name)).toString();
        }

        @Override
        public Object getProperty(List<String> path) {
            if (path.isEmpty()) {
                return this;
            }
            if (path.size() == 1) {
                return this.value(path.get(0));
            }
            throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
        }

        @Override
        public final double sortValue(String key) {
            if (key == null) {
                throw new IllegalArgumentException("Missing value key in [" + key + "] which refers to a multi-value metric aggregation");
            }
            return this.value(key);
        }
    }

    public static abstract class SingleValue
    extends InternalNumericMetricsAggregation
    implements NumericMetricsAggregation.SingleValue {
        protected SingleValue(String name, Map<String, Object> metadata) {
            super(name, metadata);
        }

        protected SingleValue(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public String getValueAsString() {
            return this.format.format(this.value()).toString();
        }

        @Override
        public Object getProperty(List<String> path) {
            if (path.isEmpty()) {
                return this;
            }
            if (path.size() == 1 && "value".equals(path.get(0))) {
                return this.value();
            }
            throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
        }

        @Override
        public final double sortValue(String key) {
            if (key != null && !key.equals("value")) {
                throw new IllegalArgumentException("Unknown value key [" + key + "] for single-value metric aggregation [" + this.getName() + "]. Either use [value] as key or drop the key all together");
            }
            return this.value();
        }
    }
}

