/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;

class DefaultRepositoryContentDescriptor
implements RepositoryContentDescriptorInternal {
    private Set<String> includedConfigurations;
    private Set<String> excludedConfigurations;
    private Set<ContentSpec> includeSpecs;
    private Set<ContentSpec> excludeSpecs;
    private Map<Attribute<Object>, Set<Object>> requiredAttributes;
    private boolean locked;
    private Action<? super ArtifactResolutionDetails> cachedAction;
    private final Supplier<String> repositoryNameSupplier;

    public DefaultRepositoryContentDescriptor(Supplier<String> repositoryNameSupplier) {
        this.repositoryNameSupplier = repositoryNameSupplier;
    }

    private void assertMutable() {
        if (this.locked) {
            throw new IllegalStateException("Cannot mutate content repository descriptor '" + this.repositoryNameSupplier.get() + "' after repository has been used");
        }
    }

    @Override
    public Action<? super ArtifactResolutionDetails> toContentFilter() {
        if (this.cachedAction != null) {
            return this.cachedAction;
        }
        this.locked = true;
        if (this.includedConfigurations == null && this.excludedConfigurations == null && this.includeSpecs == null && this.excludeSpecs == null && this.requiredAttributes == null) {
            return Actions.doNothing();
        }
        this.cachedAction = new RepositoryFilterAction(DefaultRepositoryContentDescriptor.createSpecMatchers(this.includeSpecs), DefaultRepositoryContentDescriptor.createSpecMatchers(this.excludeSpecs));
        return this.cachedAction;
    }

    @Nullable
    private static ImmutableList<SpecMatcher> createSpecMatchers(@Nullable Set<ContentSpec> specs) {
        ImmutableList matchers = null;
        if (specs != null) {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)specs.size());
            for (ContentSpec spec : specs) {
                builder.add((Object)spec.toMatcher());
            }
            matchers = builder.build();
        }
        return matchers;
    }

    public void includeGroup(String group) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        this.addInclude(group, null, null, false);
    }

    private static void checkNotNull(@Nullable String value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public void includeGroupByRegex(String groupRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        this.addInclude(groupRegex, null, null, true);
    }

    public void includeModule(String group, String moduleName) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        this.addInclude(group, moduleName, null, false);
    }

    public void includeModuleByRegex(String groupRegex, String moduleNameRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name cannot be null");
        this.addInclude(groupRegex, moduleNameRegex, null, true);
    }

    public void includeVersion(String group, String moduleName, String version) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(version, "Version cannot be null");
        this.addInclude(group, moduleName, version, false);
    }

    public void includeVersionByRegex(String groupRegex, String moduleNameRegex, String versionRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(versionRegex, "Version cannot be null");
        this.addInclude(groupRegex, moduleNameRegex, versionRegex, true);
    }

    private void addInclude(String group, @Nullable String moduleName, @Nullable String version, boolean regex) {
        this.assertMutable();
        if (this.includeSpecs == null) {
            this.includeSpecs = Sets.newHashSet();
        }
        this.includeSpecs.add(new ContentSpec(regex, group, moduleName, version));
    }

    public void excludeGroup(String group) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        this.addExclude(group, null, null, false);
    }

    public void excludeGroupByRegex(String groupRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        this.addExclude(groupRegex, null, null, true);
    }

    public void excludeModule(String group, String moduleName) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        this.addExclude(group, moduleName, null, false);
    }

    public void excludeModuleByRegex(String groupRegex, String moduleNameRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name cannot be null");
        this.addExclude(groupRegex, moduleNameRegex, null, true);
    }

    public void excludeVersion(String group, String moduleName, String version) {
        DefaultRepositoryContentDescriptor.checkNotNull(group, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleName, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(version, "Version cannot be null");
        this.addExclude(group, moduleName, version, false);
    }

    public void excludeVersionByRegex(String groupRegex, String moduleNameRegex, String versionRegex) {
        DefaultRepositoryContentDescriptor.checkNotNull(groupRegex, "Group cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(moduleNameRegex, "Module name cannot be null");
        DefaultRepositoryContentDescriptor.checkNotNull(versionRegex, "Version cannot be null");
        this.addExclude(groupRegex, moduleNameRegex, versionRegex, true);
    }

    private void addExclude(String group, @Nullable String moduleName, @Nullable String version, boolean regex) {
        this.assertMutable();
        if (this.excludeSpecs == null) {
            this.excludeSpecs = Sets.newHashSet();
        }
        this.excludeSpecs.add(new ContentSpec(regex, group, moduleName, version));
    }

    public void onlyForConfigurations(String ... configurationNames) {
        if (this.includedConfigurations == null) {
            this.includedConfigurations = Sets.newHashSet();
        }
        Collections.addAll(this.includedConfigurations, configurationNames);
    }

    public void notForConfigurations(String ... configurationNames) {
        if (this.excludedConfigurations == null) {
            this.excludedConfigurations = Sets.newHashSet();
        }
        Collections.addAll(this.excludedConfigurations, configurationNames);
    }

    public <T> void onlyForAttribute(Attribute<T> attribute, T ... validValues) {
        if (this.requiredAttributes == null) {
            this.requiredAttributes = Maps.newHashMap();
        }
        this.requiredAttributes.put((Attribute<Object>)((Attribute)Cast.uncheckedCast(attribute)), (Set<Object>)ImmutableSet.copyOf((Object[])validValues));
    }

    private class RepositoryFilterAction
    implements Action<ArtifactResolutionDetails> {
        private final ImmutableList<SpecMatcher> includeMatchers;
        private final ImmutableList<SpecMatcher> excludeMatchers;

        public RepositoryFilterAction(@Nullable ImmutableList<SpecMatcher> includeMatchers, ImmutableList<SpecMatcher> excludeMatchers) {
            this.includeMatchers = includeMatchers;
            this.excludeMatchers = excludeMatchers;
        }

        public void execute(ArtifactResolutionDetails details) {
            if (DefaultRepositoryContentDescriptor.this.includedConfigurations != null && !DefaultRepositoryContentDescriptor.this.includedConfigurations.contains(details.getConsumerName())) {
                details.notFound();
                return;
            }
            if (DefaultRepositoryContentDescriptor.this.excludedConfigurations != null && DefaultRepositoryContentDescriptor.this.excludedConfigurations.contains(details.getConsumerName())) {
                details.notFound();
                return;
            }
            if (this.includeMatchers != null && !this.anyMatch(this.includeMatchers, details)) {
                details.notFound();
                return;
            }
            if (this.excludeMatchers != null && this.anyMatch(this.excludeMatchers, details)) {
                details.notFound();
                return;
            }
            if (this.anyAttributesExcludes(details)) {
                details.notFound();
            }
        }

        private boolean anyAttributesExcludes(ArtifactResolutionDetails details) {
            if (DefaultRepositoryContentDescriptor.this.requiredAttributes != null) {
                AttributeContainer consumerAttributes = details.getConsumerAttributes();
                for (Map.Entry entry : DefaultRepositoryContentDescriptor.this.requiredAttributes.entrySet()) {
                    Object value;
                    Attribute key = (Attribute)entry.getKey();
                    Set allowedValues = (Set)entry.getValue();
                    if (allowedValues.contains(value = consumerAttributes.getAttribute(key))) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean anyMatch(ImmutableList<SpecMatcher> matchers, ArtifactResolutionDetails details) {
            for (SpecMatcher matcher : matchers) {
                boolean matches = details.isVersionListing() ? matcher.matches(details.getModuleId()) : matcher.matches(details.getComponentId());
                if (!matches) continue;
                return true;
            }
            return false;
        }
    }

    private static class PatternSpecMatcher
    implements SpecMatcher {
        private final Pattern groupPattern;
        private final Pattern modulePattern;
        private final Pattern versionPattern;

        private PatternSpecMatcher(String group, @Nullable String module, @Nullable String version) {
            this.groupPattern = Pattern.compile(group);
            this.modulePattern = module == null ? null : Pattern.compile(module);
            this.versionPattern = version == null ? null : Pattern.compile(version);
        }

        @Override
        public boolean matches(ModuleIdentifier id) {
            return this.groupPattern.matcher(id.getGroup()).matches() && (this.modulePattern == null || this.modulePattern.matcher(id.getName()).matches());
        }

        @Override
        public boolean matches(ModuleComponentIdentifier id) {
            return !(!this.groupPattern.matcher(id.getGroup()).matches() || this.modulePattern != null && !this.modulePattern.matcher(id.getModule()).matches() || this.versionPattern != null && !this.versionPattern.matcher(id.getVersion()).matches());
        }
    }

    private static class SimpleSpecMatcher
    implements SpecMatcher {
        private final String group;
        private final String module;
        private final String version;

        private SimpleSpecMatcher(String group, @Nullable String module, @Nullable String version) {
            this.group = group;
            this.module = module;
            this.version = version;
        }

        @Override
        public boolean matches(ModuleIdentifier id) {
            return this.group.equals(id.getGroup()) && (this.module == null || this.module.equals(id.getName()));
        }

        @Override
        public boolean matches(ModuleComponentIdentifier id) {
            return !(!this.group.equals(id.getGroup()) || this.module != null && !this.module.equals(id.getModule()) || this.version != null && !this.version.equals(id.getVersion()));
        }
    }

    private static interface SpecMatcher {
        public boolean matches(ModuleIdentifier var1);

        public boolean matches(ModuleComponentIdentifier var1);
    }

    private static class ContentSpec {
        private final boolean regex;
        private final String group;
        private final String module;
        private final String version;
        private final int hashCode;

        private ContentSpec(boolean regex, String group, @Nullable String module, @Nullable String version) {
            this.regex = regex;
            this.group = group;
            this.module = module;
            this.version = version;
            this.hashCode = Objects.hashCode((Object[])new Object[]{regex, group, module, version});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentSpec that = (ContentSpec)o;
            return this.regex == that.regex && this.hashCode == that.hashCode && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.version, (Object)that.version);
        }

        public int hashCode() {
            return this.hashCode;
        }

        SpecMatcher toMatcher() {
            if (this.regex) {
                return new PatternSpecMatcher(this.group, this.module, this.version);
            }
            return new SimpleSpecMatcher(this.group, this.module, this.version);
        }
    }
}

