/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

public class SharedJavaInstallationRegistry {
    private final Set<InstallationSupplier> suppliers = Sets.newConcurrentHashSet();
    private final Supplier<Set<File>> finalizedInstallations = Suppliers.memoize(this::mapToDirectories);
    private final AtomicBoolean finalized = new AtomicBoolean();
    private final Logger logger;

    @Inject
    public SharedJavaInstallationRegistry(List<InstallationSupplier> suppliers) {
        this(suppliers, Logging.getLogger(SharedJavaInstallationRegistry.class));
    }

    private SharedJavaInstallationRegistry(List<InstallationSupplier> suppliers, Logger logger) {
        this.suppliers.addAll(suppliers);
        this.logger = logger;
    }

    @VisibleForTesting
    static SharedJavaInstallationRegistry withLogger(Logger logger) {
        return new SharedJavaInstallationRegistry(Collections.emptyList(), logger);
    }

    void add(InstallationSupplier provider) {
        Preconditions.checkArgument((!this.finalized.get() ? 1 : 0) != 0, (Object)"Installation must not be mutated after being finalized");
        this.suppliers.add(provider);
    }

    public Set<File> listInstallations() {
        this.finalizeValue();
        return (Set)this.finalizedInstallations.get();
    }

    private void finalizeValue() {
        this.finalized.compareAndSet(false, true);
    }

    private Set<File> mapToDirectories() {
        return this.suppliers.stream().map(java.util.function.Supplier::get).flatMap(Collection::stream).filter(this::installationExists).map(InstallationLocation::getLocation).collect(Collectors.toSet());
    }

    private boolean installationExists(InstallationLocation installationLocation) {
        File file = installationLocation.getLocation();
        if (!file.exists()) {
            this.logger.warn("Directory {} used for java installations does not exist", (Object)installationLocation.getDisplayName());
            return false;
        }
        if (!file.isDirectory()) {
            this.logger.warn("Path for java installation {} points to a file, not a directory", (Object)installationLocation.getDisplayName());
            return false;
        }
        return true;
    }
}

