/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.backend.FakeOverrideMode;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.util.ConstantValueGenerator;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGeneratorKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi2ir.PsiSourceManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "", "()V", "createModuleFragment", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "firFiles", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "fakeOverrideMode", "Lorg/jetbrains/kotlin/fir/backend/FakeOverrideMode;", "generateUnboundSymbolsAsDependencies", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "builtIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "fir2ir"})
public final class Fir2IrConverter {
    public static final Fir2IrConverter INSTANCE;

    @NotNull
    public final Fir2IrResult createModuleFragment(@NotNull FirSession session, @NotNull List<? extends FirFile> firFiles, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull FakeOverrideMode fakeOverrideMode) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(firFiles, (String)"firFiles");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fakeOverrideMode), (String)"fakeOverrideMode");
        FirModuleDescriptor moduleDescriptor = new FirModuleDescriptor(session);
        SymbolTable symbolTable = new SymbolTable(null, 1, null);
        ConstantValueGenerator constantValueGenerator = new ConstantValueGenerator(moduleDescriptor, symbolTable);
        TypeTranslator typeTranslator = new TypeTranslator(symbolTable, languageVersionSettings, moduleDescriptor.getBuiltIns(), null, false, 24, null);
        constantValueGenerator.setTypeTranslator(typeTranslator);
        typeTranslator.setConstantValueGenerator(constantValueGenerator);
        IrBuiltIns builtIns = new IrBuiltIns(moduleDescriptor.getBuiltIns(), typeTranslator, symbolTable);
        PsiSourceManager sourceManager = new PsiSourceManager();
        Fir2IrVisitor fir2irTransformer = new Fir2IrVisitor(session, moduleDescriptor, symbolTable, sourceManager, builtIns, fakeOverrideMode);
        boolean bl = false;
        List irFiles2 = new ArrayList();
        for (FirFile firFile : firFiles) {
            Object r = firFile.accept(fir2irTransformer, null);
            if (r == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            }
            IrFile irFile = (IrFile)r;
            PsiElement psiElement = FirSourceElementKt.getPsi(firFile);
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            }
            PsiSourceManager.PsiFileEntry fileEntry = sourceManager.getOrCreateFileEntry((KtFile)psiElement);
            sourceManager.putFileEntry(irFile, fileEntry);
            Collection collection = irFiles2;
            boolean bl2 = false;
            collection.add(irFile);
        }
        IrModuleFragmentImpl irModuleFragmentImpl = new IrModuleFragmentImpl(moduleDescriptor, builtIns, irFiles2);
        this.generateUnboundSymbolsAsDependencies(irModuleFragmentImpl, symbolTable, builtIns);
        return new Fir2IrResult(irModuleFragmentImpl, symbolTable, sourceManager);
    }

    public static /* synthetic */ Fir2IrResult createModuleFragment$default(Fir2IrConverter fir2IrConverter, FirSession firSession, List list2, LanguageVersionSettings languageVersionSettings, FakeOverrideMode fakeOverrideMode, int n, Object object) {
        if ((n & 8) != 0) {
            fakeOverrideMode = FakeOverrideMode.NORMAL;
        }
        return fir2IrConverter.createModuleFragment(firSession, list2, languageVersionSettings, fakeOverrideMode);
    }

    private final void generateUnboundSymbolsAsDependencies(IrModuleFragment irModule, SymbolTable symbolTable, IrBuiltIns builtIns) {
        new ExternalDependenciesGenerator(symbolTable, ExternalDependenciesGeneratorKt.generateTypicalIrProviderList$default(irModule.getDescriptor(), builtIns, symbolTable, null, null, 24, null)).generateUnboundSymbolsAsDependencies();
    }

    private Fir2IrConverter() {
    }

    static {
        Fir2IrConverter fir2IrConverter;
        INSTANCE = fir2IrConverter = new Fir2IrConverter();
    }
}

