/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.ObjectInputFilter;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;

public final class MarshalledObject<T>
implements Serializable {
    private byte[] objBytes = null;
    private byte[] locBytes = null;
    private int hash;
    private transient ObjectInputFilter objectInputFilter = null;
    private static final long serialVersionUID = 8988374069173025854L;

    public MarshalledObject(T t) throws IOException {
        if (t == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        MarshalledObjectOutputStream marshalledObjectOutputStream = new MarshalledObjectOutputStream((OutputStream)byteArrayOutputStream, byteArrayOutputStream2);
        marshalledObjectOutputStream.writeObject(t);
        marshalledObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        this.locBytes = marshalledObjectOutputStream.hadAnnotations() ? byteArrayOutputStream2.toByteArray() : null;
        int n = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            n = 31 * n + this.objBytes[i];
        }
        this.hash = n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.objectInputFilter = ObjectInputFilter.Config.getObjectInputFilter(objectInputStream);
    }

    public T get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.objBytes);
        ByteArrayInputStream byteArrayInputStream2 = this.locBytes == null ? null : new ByteArrayInputStream(this.locBytes);
        MarshalledObjectInputStream marshalledObjectInputStream = new MarshalledObjectInputStream(byteArrayInputStream, byteArrayInputStream2, this.objectInputFilter);
        Object object = marshalledObjectInputStream.readObject();
        marshalledObjectInputStream.close();
        return (T)object;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof MarshalledObject) {
            MarshalledObject marshalledObject = (MarshalledObject)object;
            if (this.objBytes == null || marshalledObject.objBytes == null) {
                return this.objBytes == marshalledObject.objBytes;
            }
            if (this.objBytes.length != marshalledObject.objBytes.length) {
                return false;
            }
            for (int i = 0; i < this.objBytes.length; ++i) {
                if (this.objBytes[i] == marshalledObject.objBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class MarshalledObjectInputStream
    extends MarshalInputStream {
        private ObjectInputStream locIn;

        MarshalledObjectInputStream(InputStream inputStream, InputStream inputStream2, final ObjectInputFilter objectInputFilter) throws IOException {
            super(inputStream);
            ObjectInputStream objectInputStream = this.locIn = inputStream2 == null ? null : new ObjectInputStream(inputStream2);
            if (objectInputFilter != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ObjectInputFilter.Config.setObjectInputFilter(this, objectInputFilter);
                        if (locIn != null) {
                            ObjectInputFilter.Config.setObjectInputFilter(locIn, objectInputFilter);
                        }
                        return null;
                    }
                });
            }
        }

        @Override
        protected Object readLocation() throws IOException, ClassNotFoundException {
            return this.locIn == null ? null : this.locIn.readObject();
        }
    }

    private static class MarshalledObjectOutputStream
    extends MarshalOutputStream {
        private ObjectOutputStream locOut;
        private boolean hadAnnotations;

        MarshalledObjectOutputStream(OutputStream outputStream, OutputStream outputStream2) throws IOException {
            super(outputStream);
            this.useProtocolVersion(2);
            this.locOut = new ObjectOutputStream(outputStream2);
            this.hadAnnotations = false;
        }

        boolean hadAnnotations() {
            return this.hadAnnotations;
        }

        @Override
        protected void writeLocation(String string) throws IOException {
            this.hadAnnotations |= string != null;
            this.locOut.writeObject(string);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.locOut.flush();
        }
    }
}

