/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atanh(-0.99) => -2.646653
 * atanh(-0.33) => -0.34282827
 * atanh(0.33) => 0.34282827
 * atanh(0.99) => 2.646653
 */
#version 130

void main()
{
  float[distance(atanh(-0.99), -2.646653) <= 0.002646653 ? 1 : -1] array0;
  float[distance(atanh(-0.33), -0.34282827) <= 0.00034282828 ? 1 : -1] array1;
  float[distance(atanh(0.33), 0.34282827) <= 0.00034282828 ? 1 : -1] array2;
  float[distance(atanh(0.99), 2.646653) <= 0.002646653 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
