/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.StepsProgressIndicator;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.DialogManager;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitMergeProvider;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitRebaseProcess.class);
    private final NotificationAction ABORT_ACTION;
    private final NotificationAction CONTINUE_ACTION;
    private final NotificationAction RETRY_ACTION;
    private final NotificationAction VIEW_STASH_ACTION;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitRebaseSpec myRebaseSpec;
    @Nullable
    private final GitRebaseResumeMode myCustomMode;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final ProgressManager myProgressManager;
    @NotNull
    private final VcsDirtyScopeManager myDirtyScopeManager;

    public GitRebaseProcess(@NotNull Project project, @NotNull GitRebaseSpec rebaseSpec, @Nullable GitRebaseResumeMode customMode) {
        if (project == null) {
            GitRebaseProcess.$$$reportNull$$$0(0);
        }
        if (rebaseSpec == null) {
            GitRebaseProcess.$$$reportNull$$$0(1);
        }
        this.ABORT_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.abort.text", new Object[0]), () -> this.abort());
        this.CONTINUE_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.continue.text", new Object[0]), () -> this.retry(GitBundle.getString("rebase.progress.indicator.continue.title")));
        this.RETRY_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.retry.text", new Object[0]), () -> this.retry(GitBundle.getString("rebase.progress.indicator.retry.title")));
        this.myProject = project;
        this.myRebaseSpec = rebaseSpec;
        this.myCustomMode = customMode;
        this.mySaver = rebaseSpec.getSaver();
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myProgressManager = ProgressManager.getInstance();
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.VIEW_STASH_ACTION = NotificationAction.createSimple((String)this.mySaver.getSaveMethod().selectBundleMessage(GitBundle.getString("rebase.notification.action.view.stash.text"), GitBundle.getString("rebase.notification.action.view.shelf.text")), () -> this.mySaver.showSavedChanges());
    }

    public void rebase() {
        if (this.checkForRebasingPublishedCommits()) {
            new GitFreezingProcess(this.myProject, GitBundle.getString("rebase.git.operation.name"), this::doRebase).execute();
        }
    }

    private void doRebase() {
        LOG.info("Started rebase");
        LOG.debug("Started rebase with the following spec: " + this.myRebaseSpec);
        LinkedHashMap<GitRepository, GitRebaseStatus> statuses = new LinkedHashMap<GitRepository, GitRebaseStatus>(this.myRebaseSpec.getStatuses());
        List<GitRepository> repositoriesToRebase = this.myRepositoryManager.sortByDependency(this.myRebaseSpec.getIncompleteRepositories());
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)"Rebase");){
            GitRebaseStatus.Type latestStatus;
            if (!this.saveDirtyRootsInitially(repositoriesToRebase)) {
                return;
            }
            GitRepository latestRepository = null;
            ProgressIndicator showingIndicator = this.myProgressManager.getProgressIndicator();
            StepsProgressIndicator indicator = new StepsProgressIndicator((ProgressIndicator)(showingIndicator != null ? showingIndicator : new EmptyProgressIndicator()), repositoriesToRebase.size());
            indicator.setIndeterminate(false);
            for (GitRepository repository : repositoriesToRebase) {
                GitRebaseResumeMode customMode = null;
                if (repository == this.myRebaseSpec.getOngoingRebase()) {
                    customMode = this.myCustomMode == null ? GitRebaseResumeMode.CONTINUE : this.myCustomMode;
                }
                Hash startHash = GitUtil.getHead(repository);
                GitRebaseStatus rebaseStatus = this.rebaseSingleRoot(repository, customMode, GitRebaseProcess.getSuccessfulRepositories(statuses), (ProgressIndicator)indicator);
                indicator.nextStep();
                repository.update();
                if (customMode == GitRebaseResumeMode.CONTINUE) {
                    this.myDirtyScopeManager.dirDirtyRecursively(repository.getRoot());
                }
                latestRepository = repository;
                statuses.put(repository, rebaseStatus);
                if (GitRebaseProcess.shouldBeRefreshed(rebaseStatus)) {
                    GitUtil.refreshChangedVfs(repository, startHash);
                }
                if (rebaseStatus.getType() == GitRebaseStatus.Type.SUCCESS) continue;
                break;
            }
            if ((latestStatus = ((GitRebaseStatus)statuses.get(latestRepository)).getType()) == GitRebaseStatus.Type.SUCCESS || latestStatus == GitRebaseStatus.Type.NOT_STARTED) {
                LOG.debug("Rebase completed successfully.");
                this.mySaver.load();
            }
            if (latestStatus == GitRebaseStatus.Type.SUCCESS) {
                this.notifySuccess();
            }
            this.saveUpdatedSpec(statuses);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
            ExceptionUtil.rethrowUnchecked((Throwable)e);
        }
    }

    private void saveUpdatedSpec(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(2);
        }
        if (this.myRebaseSpec.shouldBeSaved()) {
            GitRebaseSpec newRebaseInfo = this.myRebaseSpec.cloneWithNewStatuses(statuses);
            this.myRepositoryManager.setOngoingRebaseSpec(newRebaseInfo);
        } else {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
        }
    }

    @NotNull
    private GitRebaseStatus rebaseSingleRoot(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode customMode, @NotNull Map<GitRepository, GitSuccessfulRebase> alreadyRebased, @NotNull ProgressIndicator indicator) {
        GitRebaseStatus.Type type;
        boolean somethingRebased;
        GitCommandResult result2;
        String repoName;
        block17: {
            ResolveConflictResult resolveResult;
            if (repository == null) {
                GitRebaseProcess.$$$reportNull$$$0(3);
            }
            if (alreadyRebased == null) {
                GitRebaseProcess.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                GitRebaseProcess.$$$reportNull$$$0(5);
            }
            VirtualFile root = repository.getRoot();
            repoName = DvcsUtil.getShortRepositoryName((Repository)repository);
            LOG.info("Rebasing root " + repoName + ", mode: " + ObjectUtils.notNull((Object)((Object)customMode), (Object)"standard"));
            boolean retryWhenDirty = false;
            int commitsToRebase = 0;
            try {
                GitRebaseParams params = this.myRebaseSpec.getParams();
                if (params != null) {
                    String upstream = params.getUpstream();
                    String branch = params.getBranch();
                    commitsToRebase = GitRebaseUtils.getNumberOfCommitsToRebase(repository, upstream, branch);
                }
            }
            catch (VcsException e) {
                LOG.warn("Couldn't get the number of commits to rebase", (Throwable)e);
            }
            GitRebaseProgressListener progressListener = new GitRebaseProgressListener(commitsToRebase, indicator);
            while (true) {
                GitRebaseProblemDetector rebaseDetector = new GitRebaseProblemDetector();
                GitUntrackedFilesOverwrittenByOperationDetector untrackedDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitRebaseCommandResult rebaseCommandResult = this.callRebase(repository, customMode, rebaseDetector, untrackedDetector, progressListener);
                result2 = rebaseCommandResult.getCommandResult();
                boolean bl = somethingRebased = customMode != null || progressListener.currentCommit > 1;
                if (rebaseCommandResult.wasCancelledInCommitList()) {
                    GitRebaseStatus gitRebaseStatus = GitRebaseStatus.notStarted();
                    if (gitRebaseStatus == null) {
                        GitRebaseProcess.$$$reportNull$$$0(6);
                    }
                    return gitRebaseStatus;
                }
                if (rebaseCommandResult.wasCancelledInCommitMessage()) {
                    this.showStoppedForEditingMessage();
                    return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
                }
                if (result2.success()) {
                    if (rebaseDetector.hasStoppedForEditing()) {
                        this.showStoppedForEditingMessage();
                        return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
                    }
                    LOG.debug("Successfully rebased " + repoName);
                    return new GitSuccessfulRebase();
                }
                if (rebaseDetector.isDirtyTree() && customMode == null && !retryWhenDirty) {
                    LOG.debug("Dirty tree detected in " + repoName);
                    String saveError = this.saveLocalChanges(Collections.singleton(repository.getRoot()));
                    if (saveError == null) {
                        retryWhenDirty = true;
                        continue;
                    }
                    LOG.warn(String.format("Couldn't %s root %s: %s", this.mySaver.getSaveMethod() == GitSaveChangesPolicy.SHELVE ? "shelve" : "stash", repository.getRoot(), saveError));
                    this.showFatalError(saveError, repository, somethingRebased, alreadyRebased.keySet());
                    GitRebaseStatus.Type type2 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    return new GitRebaseStatus(type2);
                }
                if (untrackedDetector.wasMessageDetected()) {
                    LOG.info("Untracked files detected in " + repoName);
                    this.showUntrackedFilesError(untrackedDetector.getRelativeFilePaths(), repository, somethingRebased, alreadyRebased.keySet());
                    type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    return new GitRebaseStatus(type);
                }
                if (rebaseDetector.isNoChangeError()) {
                    LOG.info("'No changes' situation detected in " + repoName);
                    customMode = GitRebaseResumeMode.SKIP;
                    continue;
                }
                if (!rebaseDetector.isMergeConflict()) break block17;
                LOG.info("Merge conflict in " + repoName);
                resolveResult = this.showConflictResolver(repository, false);
                if (resolveResult != ResolveConflictResult.ALL_RESOLVED) break;
                customMode = GitRebaseResumeMode.CONTINUE;
            }
            if (resolveResult == ResolveConflictResult.NOTHING_TO_MERGE) {
                LOG.info("Unmerged changes while rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
                this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet());
                GitRebaseStatus.Type type3 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                return new GitRebaseStatus(type3);
            }
            this.notifyNotAllConflictsResolved(repository);
            return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
        }
        LOG.info("Error rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
        this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet());
        type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
        return new GitRebaseStatus(type);
    }

    @NotNull
    private GitRebaseCommandResult callRebase(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode mode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(7);
        }
        if (listeners == null) {
            GitRebaseProcess.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            GitRebaseParams params = Objects.requireNonNull(this.myRebaseSpec.getParams());
            GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebase(repository, params, listeners);
            if (gitRebaseCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(9);
            }
            return gitRebaseCommandResult;
        }
        if (mode == GitRebaseResumeMode.SKIP) {
            GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebaseSkip(repository, listeners);
            if (gitRebaseCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(10);
            }
            return gitRebaseCommandResult;
        }
        LOG.assertTrue(mode == GitRebaseResumeMode.CONTINUE, (Object)("Unexpected rebase mode: " + (Object)((Object)mode)));
        GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebaseContinue(repository, listeners);
        if (gitRebaseCommandResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(11);
        }
        return gitRebaseCommandResult;
    }

    @VisibleForTesting
    @NotNull
    protected Collection<GitRepository> getDirtyRoots(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(12);
        }
        Collection<GitRepository> collection = this.findRootsWithLocalChanges(repositories);
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(13);
        }
        return collection;
    }

    private static boolean shouldBeRefreshed(@NotNull GitRebaseStatus rebaseStatus) {
        if (rebaseStatus == null) {
            GitRebaseProcess.$$$reportNull$$$0(14);
        }
        return rebaseStatus.getType() != GitRebaseStatus.Type.SUCCESS;
    }

    private boolean saveDirtyRootsInitially(@NotNull List<? extends GitRepository> repositories) {
        List repositoriesToSave;
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(15);
        }
        if ((repositoriesToSave = ContainerUtil.filter(repositories, repository -> !repository.equals(this.myRebaseSpec.getOngoingRebase()))).isEmpty()) {
            return true;
        }
        Collection<VirtualFile> rootsToSave = GitUtil.getRootsFromRepositories(this.getDirtyRoots(repositoriesToSave));
        String error = this.saveLocalChanges(rootsToSave);
        if (error != null) {
            this.myNotifier.notifyError(GitBundle.getString("rebase.notification.not.started.title"), error);
            return false;
        }
        return true;
    }

    @Nullable
    private String saveLocalChanges(@NotNull Collection<? extends VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            GitRebaseProcess.$$$reportNull$$$0(16);
        }
        try {
            this.mySaver.saveLocalChanges(rootsToSave);
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return this.mySaver.getSaveMethod().selectBundleMessage(GitBundle.message("rebase.notification.failed.stash.text", e.getMessage()), GitBundle.message("rebase.notification.failed.shelf.text", e.getMessage()));
        }
    }

    private Collection<GitRepository> findRootsWithLocalChanges(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(17);
        }
        return ContainerUtil.filter(repositories, repository -> this.myChangeListManager.haveChangesUnder(repository.getRoot()) != ThreeState.NO);
    }

    protected void notifySuccess() {
        String baseBranch;
        String rebasedBranch = GitRebaseProcess.getCommonCurrentBranchNameIfAllTheSame(this.myRebaseSpec.getAllRepositories());
        GitRebaseParams params = this.myRebaseSpec.getParams();
        String string = baseBranch = params == null ? null : (String)ObjectUtils.notNull((Object)params.getNewBase(), (Object)params.getUpstream());
        if ("HEAD".equals(baseBranch)) {
            baseBranch = GitRebaseProcess.getItemIfAllTheSame(this.myRebaseSpec.getInitialBranchNames().values(), baseBranch);
        }
        String message = GitSuccessfulRebase.formatMessage(rebasedBranch, baseBranch, params != null && params.getBranch() != null);
        this.myNotifier.notifyMinorInfo(GitBundle.getString("rebase.notification.successful.title"), message);
    }

    @Nullable
    private static String getCommonCurrentBranchNameIfAllTheSame(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(18);
        }
        return GitRebaseProcess.getItemIfAllTheSame(ContainerUtil.map(repositories, Repository::getCurrentBranchName), null);
    }

    @Contract(value="_, !null -> !null")
    private static <T> T getItemIfAllTheSame(@NotNull Collection<? extends T> collection, @Nullable T defaultItem) {
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(19);
        }
        return (T)(new HashSet<T>(collection).size() == 1 ? ContainerUtil.getFirstItem(collection) : defaultItem);
    }

    private void notifyNotAllConflictsResolved(@NotNull GitRepository conflictingRepository) {
        if (conflictingRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(20);
        }
        String description = GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(GitBundle.getString("rebase.notification.conflict.title"), description, NotificationType.WARNING, null);
        notification.addAction((AnAction)new ResolveAction(conflictingRepository));
        notification.addAction((AnAction)this.CONTINUE_ACTION);
        notification.addAction((AnAction)this.ABORT_ACTION);
        if (this.mySaver.wereChangesSaved()) {
            notification.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification);
    }

    @NotNull
    private ResolveConflictResult showConflictResolver(@NotNull GitRepository conflicting, boolean calledFromNotification) {
        if (conflicting == null) {
            GitRebaseProcess.$$$reportNull$$$0(21);
        }
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject).setMergeDialogCustomizer(GitRebaseProcess.createDialogCustomizer(conflicting, this.myRebaseSpec)).setReverse(true);
        RebaseConflictResolver conflictResolver = new RebaseConflictResolver(this.myProject, conflicting, params, calledFromNotification);
        boolean allResolved = conflictResolver.merge();
        if (conflictResolver.myWasNothingToMerge) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.NOTHING_TO_MERGE;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(22);
            }
            return resolveConflictResult;
        }
        if (allResolved) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.ALL_RESOLVED;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(23);
            }
            return resolveConflictResult;
        }
        ResolveConflictResult resolveConflictResult = ResolveConflictResult.UNRESOLVED_REMAIN;
        if (resolveConflictResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(24);
        }
        return resolveConflictResult;
    }

    @Nullable
    private static Hash resolveRef(@NotNull GitRepository repository, @NotNull String ref) {
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(25);
        }
        if (ref == null) {
            GitRebaseProcess.$$$reportNull$$$0(26);
        }
        GitRevisionNumber resolved = null;
        try {
            resolved = GitRevisionNumber.resolve(repository.getProject(), repository.getRoot(), ref);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        return resolved != null ? HashImpl.build((String)resolved.asString()) : null;
    }

    @NotNull
    private static MergeDialogCustomizer createDialogCustomizer(@NotNull GitRepository repository, @NotNull GitRebaseSpec rebaseSpec) {
        GitRebaseParams rebaseParams;
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(27);
        }
        if (rebaseSpec == null) {
            GitRebaseProcess.$$$reportNull$$$0(28);
        }
        if ((rebaseParams = rebaseSpec.getParams()) != null) {
            String branch;
            String currentBranchAtTheStartOfRebase = rebaseSpec.getInitialBranchNames().get(repository);
            String upstream = rebaseParams.getUpstream();
            if (upstream.equals("HEAD")) {
                upstream = currentBranchAtTheStartOfRebase;
            }
            if ((branch = rebaseParams.getBranch()) == null) {
                branch = currentBranchAtTheStartOfRebase;
            }
            if (upstream != null && branch != null) {
                Hash rebaseHead = GitRebaseProcess.resolveRef(repository, "REBASE_HEAD");
                Hash mergeBase = null;
                try {
                    GitRevisionNumber mergeBaseRev = GitHistoryUtils.getMergeBase(repository.getProject(), repository.getRoot(), upstream, branch);
                    mergeBase = mergeBaseRev != null ? HashImpl.build((String)mergeBaseRev.getRev()) : null;
                }
                catch (VcsException e) {
                    LOG.warn((Throwable)e);
                }
                return new GitRebaseMergeDialogCustomizer(repository, upstream, branch, rebaseHead, mergeBase);
            }
        }
        return new GitDefaultMergeDialogCustomizer(repository.getProject());
    }

    private void showStoppedForEditingMessage() {
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(GitBundle.getString("rebase.notification.editing.title"), "", NotificationType.INFORMATION, null);
        notification.addAction((AnAction)this.CONTINUE_ACTION);
        notification.addAction((AnAction)this.ABORT_ACTION);
        this.myNotifier.notify(notification);
    }

    private void showFatalError(@NotNull String error, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (error == null) {
            GitRebaseProcess.$$$reportNull$$$0(29);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(30);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(31);
        }
        String repo = this.myRepositoryManager.moreThanOneRoot() ? DvcsUtil.getShortRepositoryName((Repository)currentRepository) + ": " : "";
        String description = repo + error + "<br/>" + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        String title = this.myRebaseSpec.getOngoingRebase() == null ? GitBundle.getString("rebase.notification.failed.rebase.title") : GitBundle.getString("rebase.notification.failed.continue.title");
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, description, NotificationType.ERROR, null);
        notification.addAction((AnAction)this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            notification.addAction((AnAction)this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            notification.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification);
    }

    private void showUntrackedFilesError(@NotNull Set<String> untrackedPaths, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (untrackedPaths == null) {
            GitRebaseProcess.$$$reportNull$$$0(32);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(33);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(34);
        }
        String message = GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        ArrayList<NotificationAction> actions = new ArrayList<NotificationAction>();
        actions.add(this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            actions.add(this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            actions.add(this.VIEW_STASH_ACTION);
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, currentRepository.getRoot(), untrackedPaths, GitBundle.getString("rebase.git.operation.name"), message, null, actions.toArray(new NotificationAction[0]));
    }

    @NotNull
    private static Map<GitRepository, GitSuccessfulRebase> getSuccessfulRepositories(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(35);
        }
        LinkedHashMap<GitRepository, GitSuccessfulRebase> map2 = new LinkedHashMap<GitRepository, GitSuccessfulRebase>();
        for (GitRepository repository : statuses.keySet()) {
            GitRebaseStatus status = statuses.get(repository);
            if (!(status instanceof GitSuccessfulRebase)) continue;
            map2.put(repository, (GitSuccessfulRebase)status);
        }
        LinkedHashMap<GitRepository, GitSuccessfulRebase> linkedHashMap = map2;
        if (linkedHashMap == null) {
            GitRebaseProcess.$$$reportNull$$$0(36);
        }
        return linkedHashMap;
    }

    private boolean checkForRebasingPublishedCommits() {
        if (this.myCustomMode != null || this.myRebaseSpec.getOngoingRebase() != null) {
            return true;
        }
        if (this.myRebaseSpec.getParams() == null) {
            LOG.error("Shouldn't happen. Spec: " + this.myRebaseSpec);
            return true;
        }
        String upstream = this.myRebaseSpec.getParams().getUpstream();
        for (GitRepository repository : this.myRebaseSpec.getAllRepositories()) {
            if (repository.getCurrentBranchName() == null) {
                LOG.error("No current branch in " + repository);
                return true;
            }
            String rebasingBranch = (String)ObjectUtils.notNull((Object)this.myRebaseSpec.getParams().getBranch(), (Object)repository.getCurrentBranchName());
            if (!this.isRebasingPublishedCommit(repository, upstream, rebasingBranch)) continue;
            return GitRebaseProcess.askIfShouldRebasePublishedCommit();
        }
        return true;
    }

    private boolean isRebasingPublishedCommit(@NotNull GitRepository repository, @NotNull String baseBranch, @NotNull String rebasingBranch) {
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(37);
        }
        if (baseBranch == null) {
            GitRebaseProcess.$$$reportNull$$$0(38);
        }
        if (rebasingBranch == null) {
            GitRebaseProcess.$$$reportNull$$$0(39);
        }
        try {
            List<? extends TimedVcsCommit> commits2 = GitHistoryUtils.collectTimedCommits(this.myProject, repository.getRoot(), baseBranch + ".." + rebasingBranch);
            return ContainerUtil.exists(commits2, commit2 -> GitProtectedBranchesKt.isCommitPublished(repository, (Hash)commit2.getId()));
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits", (Throwable)e);
            return true;
        }
    }

    private static boolean askIfShouldRebasePublishedCommit() {
        Ref rebaseAnyway = Ref.create((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            int answer = DialogManager.showMessage(GitBundle.getString("rebase.confirmation.dialog.published.commits.message"), GitBundle.getString("rebase.confirmation.dialog.published.commits.title"), new String[]{GitBundle.getString("rebase.confirmation.dialog.published.commits.button.rebase.text"), GitBundle.getString("rebase.confirmation.dialog.published.commits.button.cancel.text")}, 1, 1, Messages.getWarningIcon(), null);
            rebaseAnyway.set((Object)(answer == 0 ? 1 : 0));
        });
        return (Boolean)rebaseAnyway.get();
    }

    private void abort() {
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.getString("rebase.progress.indicator.aborting.title")){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.abort(this.myProject, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$1", "run"));
            }
        });
    }

    private void retry(@NotNull @Nls String processTitle) {
        if (processTitle == null) {
            GitRebaseProcess.$$$reportNull$$$0(40);
        }
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, processTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.continueRebase(this.myProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$2", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseSpec";
                break;
            }
            case 2: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statuses";
                break;
            }
            case 3: 
            case 7: 
            case 25: 
            case 27: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyRebased";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseStatus";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictingRepository";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicting";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successful";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedPaths";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBranch";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebasingBranch";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseSingleRoot";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "callRebase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyRoots";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "showConflictResolver";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessfulRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveUpdatedSpec";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSingleRoot";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 36: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "callRebase";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeRefreshed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveDirtyRootsInitially";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "saveLocalChanges";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findRootsWithLocalChanges";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCurrentBranchNameIfAllTheSame";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getItemIfAllTheSame";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notifyNotAllConflictsResolved";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showConflictResolver";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveRef";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createDialogCustomizer";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showFatalError";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesError";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSuccessfulRepositories";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isRebasingPublishedCommit";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "retry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GitRebaseProgressListener
    implements GitLineHandlerListener {
        @NonNls
        private static final Pattern REBASING_PATTERN = Pattern.compile("^Rebasing \\((\\d+)/(\\d+)\\)$");
        @NonNls
        private static final String APPLYING_PREFIX = "Applying: ";
        private int currentCommit;
        private final int myCommitsToRebase;
        @NotNull
        private final ProgressIndicator myIndicator;

        GitRebaseProgressListener(int commitsToRebase, @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(0);
            }
            this.currentCommit = 0;
            this.myCommitsToRebase = commitsToRebase;
            this.myIndicator = indicator;
        }

        @Override
        public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
            Matcher matcher;
            if (line == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(2);
            }
            if ((matcher = REBASING_PATTERN.matcher(line)).matches()) {
                this.currentCommit = Integer.parseInt(matcher.group(1));
            } else if (StringUtil.startsWith((CharSequence)line, (CharSequence)APPLYING_PREFIX)) {
                ++this.currentCommit;
            }
            if (this.myCommitsToRebase != 0) {
                this.myIndicator.setFraction((double)this.currentCommit / (double)this.myCommitsToRebase);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "git4idea/rebase/GitRebaseProcess$GitRebaseProgressListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onLineAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ResolveAction
    extends NotificationAction {
        @NotNull
        private final GitRepository myCurrentRepository;

        ResolveAction(GitRepository currentRepository) {
            if (currentRepository == null) {
                ResolveAction.$$$reportNull$$$0(0);
            }
            super(GitBundle.messagePointer("action.NotificationAction.text.resolve", new Object[0]));
            this.myCurrentRepository = currentRepository;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                ResolveAction.$$$reportNull$$$0(1);
            }
            if (notification == null) {
                ResolveAction.$$$reportNull$$$0(2);
            }
            GitRebaseProcess.this.myProgressManager.run((Task)new Task.Backgroundable(GitRebaseProcess.this.myProject, GitBundle.getString("rebase.progress.indicator.conflicts.collecting.title")){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    GitRebaseProcess.this.showConflictResolver(ResolveAction.this.myCurrentRepository, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$ResolveAction$1", "run"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentRepository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "git4idea/rebase/GitRebaseProcess$ResolveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ResolveConflictResult {
        ALL_RESOLVED,
        NOTHING_TO_MERGE,
        UNRESOLVED_REMAIN;

    }

    private class RebaseConflictResolver
    extends GitConflictResolver {
        private final boolean myCalledFromNotification;
        private boolean myWasNothingToMerge;

        RebaseConflictResolver(@NotNull Project project, @NotNull GitRepository repository, GitConflictResolver.Params params, boolean calledFromNotification) {
            if (project == null) {
                RebaseConflictResolver.$$$reportNull$$$0(0);
            }
            if (repository == null) {
                RebaseConflictResolver.$$$reportNull$$$0(1);
            }
            if (params == null) {
                RebaseConflictResolver.$$$reportNull$$$0(2);
            }
            super(project, Collections.singleton(repository.getRoot()), params);
            this.myCalledFromNotification = calledFromNotification;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }

        @Override
        protected boolean proceedAfterAllMerged() {
            if (this.myCalledFromNotification) {
                GitRebaseProcess.this.retry(GitBundle.getString("rebase.progress.indicator.continue.title"));
            }
            return true;
        }

        @Override
        protected boolean proceedIfNothingToMerge() {
            this.myWasNothingToMerge = true;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repository";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GitRebaseMergeDialogCustomizer
    extends MergeDialogCustomizer {
        @NotNull
        private final GitRepository myRepository;
        @NotNull
        private final String myRebasingBranch;
        @NotNull
        private final String myBasePresentable;
        @Nullable
        private final String myBaseBranch;
        @Nullable
        private final Hash myBaseHash;
        @Nullable
        private final Hash myIngoingCommit;
        @Nullable
        private final Hash myMergeBase;

        private GitRebaseMergeDialogCustomizer(@NotNull GitRepository repository, @NotNull String upstream, @NotNull String branch, @Nullable Hash ingoingCommit, @Nullable Hash mergeBase) {
            if (repository == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(0);
            }
            if (upstream == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(1);
            }
            if (branch == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(2);
            }
            this.myRepository = repository;
            this.myRebasingBranch = branch;
            this.myIngoingCommit = ingoingCommit;
            this.myMergeBase = mergeBase;
            if (upstream.matches("[a-fA-F0-9]{40}")) {
                this.myBasePresentable = VcsLogUtil.getShortHash((String)upstream);
                this.myBaseBranch = null;
                this.myBaseHash = HashImpl.build((String)upstream);
            } else {
                this.myBasePresentable = upstream;
                this.myBaseBranch = upstream;
                this.myBaseHash = null;
            }
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            if (files == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(3);
            }
            String string = GitDefaultMergeDialogCustomizerKt.getDescriptionForRebase(this.myRebasingBranch, this.myBaseBranch, this.myBaseHash);
            if (string == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            if (file == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(5);
            }
            String string = GitDefaultMergeDialogCustomizerKt.getDefaultLeftPanelTitleForBranch(this.myRebasingBranch);
            if (string == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber) {
            GitRevisionNumber gitRevisionNumber;
            if (file == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(7);
            }
            Hash hash = (gitRevisionNumber = (GitRevisionNumber)ObjectUtils.tryCast((Object)revisionNumber, GitRevisionNumber.class)) != null ? HashImpl.build((String)gitRevisionNumber.asString()) : this.myBaseHash;
            String string = GitDefaultMergeDialogCustomizerKt.getDefaultRightPanelTitleForBranch(this.myBaseBranch, hash);
            if (string == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Nullable
        public List<String> getColumnNames() {
            return Arrays.asList(GitMergeProvider.calcColumnName(false, this.myRebasingBranch), GitMergeProvider.calcColumnName(true, this.myBasePresentable));
        }

        @NotNull
        public MergeDialogCustomizer.DiffEditorTitleCustomizerList getTitleCustomizerList(@NotNull FilePath file) {
            if (file == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(9);
            }
            return new MergeDialogCustomizer.DiffEditorTitleCustomizerList(this.getLeftTitleCustomizer(file), null, this.getRightTitleCustomizer(file));
        }

        @Nullable
        public DiffEditorTitleCustomizer getLeftTitleCustomizer(@NotNull FilePath file) {
            if (file == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(10);
            }
            if (this.myIngoingCommit == null) {
                return null;
            }
            return GitDefaultMergeDialogCustomizerKt.getTitleWithCommitDetailsCustomizer(GitBundle.message("rebase.conflict.diff.dialog.left.title", this.myIngoingCommit.toShortString(), this.myRebasingBranch), this.myRepository, file, this.myIngoingCommit.asString());
        }

        @Nullable
        public DiffEditorTitleCustomizer getRightTitleCustomizer(@NotNull FilePath file) {
            if (file == null) {
                GitRebaseMergeDialogCustomizer.$$$reportNull$$$0(11);
            }
            if (this.myMergeBase == null) {
                return null;
            }
            String title = this.myBaseBranch != null ? GitBundle.message("rebase.conflict.diff.dialog.right.with.branch.title", this.myBaseBranch) : GitBundle.getString("rebase.conflict.diff.dialog.right.simple.title");
            return GitDefaultMergeDialogCustomizerKt.getTitleWithCommitsRangeDetailsCustomizer(title, this.myRepository, file, (Pair<String, String>)new Pair((Object)this.myMergeBase.asString(), (Object)"HEAD"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upstream";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/rebase/GitRebaseProcess$GitRebaseMergeDialogCustomizer";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/rebase/GitRebaseProcess$GitRebaseMergeDialogCustomizer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMultipleFileMergeDescription";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeftPanelTitle";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRightPanelTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getMultipleFileMergeDescription";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeftPanelTitle";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getRightPanelTitle";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTitleCustomizerList";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getLeftTitleCustomizer";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getRightTitleCustomizer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

