/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.jetbrains.rest.RestFileType;
import com.jetbrains.rest.RestLanguage;
import com.jetbrains.rest.validation.RestAnnotator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestAnnotatingVisitor
implements Annotator {
    private static final Logger LOGGER = Logger.getInstance((String)RestAnnotatingVisitor.class.getName());
    private final List<RestAnnotator> myAnnotators = new ArrayList<RestAnnotator>();

    public RestAnnotatingVisitor() {
        for (Class<? extends RestAnnotator> cls : ((RestLanguage)RestFileType.INSTANCE.getLanguage()).getAnnotators()) {
            RestAnnotator annotator;
            try {
                annotator = cls.newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            this.myAnnotators.add(annotator);
        }
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            RestAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RestAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        for (RestAnnotator annotator : this.myAnnotators) {
            annotator.annotateElement(psiElement, holder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/rest/validation/RestAnnotatingVisitor";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

