/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.MemoryFileSystemBuilder;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.util.UUID;

public class MemoryFileSystemFactoryBean {
    private String name;
    private String type;
    public static final String WINDOWS = "windows";
    public static final String LINUX = "linux";
    public static final String MACOS = "macos";

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    private String getName() {
        if (this.name != null) {
            return this.name;
        }
        return UUID.randomUUID().toString();
    }

    private MemoryFileSystemBuilder getBuilder() {
        if (this.type == null) {
            return MemoryFileSystemBuilder.newEmpty();
        }
        switch (this.type) {
            case "windows": {
                return MemoryFileSystemBuilder.newWindows();
            }
            case "linux": {
                return MemoryFileSystemBuilder.newLinux();
            }
            case "macos": {
                return MemoryFileSystemBuilder.newMacOs();
            }
        }
        throw new IllegalArgumentException("unknown file system type: " + this.type);
    }

    public FileSystem getObject() {
        try {
            return this.getBuilder().build(this.getName());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not create file system", e);
        }
    }
}

