/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyKnownDecoratorUtil {
    private static final Set<KnownDecorator> ABSTRACT_DECORATORS = EnumSet.of(KnownDecorator.ABC_ABSTRACTMETHOD, KnownDecorator.ABC_ABSTRACTPROPERTY, KnownDecorator.ABC_ABSTRACTSTATICMETHOD, KnownDecorator.ABC_ABSTRACTCLASSMETHOD);
    private static final Set<KnownDecorator> PROPERTY_DECORATORS = EnumSet.of(KnownDecorator.PROPERTY, KnownDecorator.ABC_ABSTRACTPROPERTY, KnownDecorator.PYRAMID_DECORATOR_REIFY, KnownDecorator.DJANGO_UTILS_FUNCTIONAL_CACHED_PROPERTY, KnownDecorator.KOMBU_UTILS_CACHED_PROPERTY);
    private static final Set<KnownDecorator> GENERATOR_BASED_COROUTINE_DECORATORS = EnumSet.of(KnownDecorator.ASYNCIO_TASKS_COROUTINE, KnownDecorator.ASYNCIO_COROUTINES_COROUTINE, KnownDecorator.TYPES_COROUTINE);
    private static final Map<String, List<KnownDecorator>> BY_SHORT_NAME = StreamEx.of((Object[])KnownDecorator.values()).groupingBy(KnownDecorator::getShortName);

    private PyKnownDecoratorUtil() {
    }

    @NotNull
    public static List<KnownDecorator> getKnownDecorators(@NotNull PyDecoratable element, @NotNull TypeEvalContext context) {
        PyDecoratorList decoratorList;
        if (element == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(1);
        }
        if ((decoratorList = element.getDecoratorList()) == null) {
            List<KnownDecorator> list = Collections.emptyList();
            if (list == null) {
                PyKnownDecoratorUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = StreamEx.of((Object[])decoratorList.getDecorators()).flatMap(decorator -> PyKnownDecoratorUtil.asKnownDecorators(decorator, context).stream()).nonNull().toList();
        if (list == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<KnownDecorator> asKnownDecorators(@NotNull PyDecorator decorator, @NotNull TypeEvalContext context) {
        QualifiedName qualifiedName;
        if (decorator == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(5);
        }
        if ((qualifiedName = decorator.getQualifiedName()) == null) {
            List<KnownDecorator> list = Collections.emptyList();
            if (list == null) {
                PyKnownDecoratorUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (context.maySwitchToAST((PsiElement)decorator)) {
            PyQualifiedNameOwner resolved = PyUtil.as(PyKnownDecoratorUtil.resolveDecorator(decorator), PyQualifiedNameOwner.class);
            if ((resolved = (PyQualifiedNameOwner)ObjectUtils.chooseNotNull((Object)PyUtil.turnConstructorIntoClass(PyUtil.as(resolved, PyFunction.class)), (Object)resolved)) != null && resolved.getQualifiedName() != null) {
                QualifiedName resolvedName = QualifiedName.fromDottedString((String)resolved.getQualifiedName());
                List knownDecorators = BY_SHORT_NAME.getOrDefault(resolvedName.getLastComponent(), Collections.emptyList());
                List list = ContainerUtil.filter(knownDecorators, knownDecorator -> resolvedName.equals((Object)knownDecorator.getQualifiedName()));
                if (list == null) {
                    PyKnownDecoratorUtil.$$$reportNull$$$0(7);
                }
                return list;
            }
        } else {
            List<KnownDecorator> list = BY_SHORT_NAME.getOrDefault(qualifiedName.getLastComponent(), Collections.emptyList());
            if (list == null) {
                PyKnownDecoratorUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<KnownDecorator> list = Collections.emptyList();
        if (list == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveDecorator(@NotNull PyDecorator decorator) {
        PyExpression callee;
        if (decorator == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(10);
        }
        if ((callee = decorator.getCallee()) == null) {
            return null;
        }
        PsiReference reference = callee.getReference();
        if (reference == null) {
            return null;
        }
        return reference.resolve();
    }

    public static boolean hasUnknownDecorator(@NotNull PyDecoratable element, @NotNull TypeEvalContext context) {
        if (element == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(12);
        }
        return !PyKnownDecoratorUtil.allDecoratorsAreKnown(element, PyKnownDecoratorUtil.getKnownDecorators(element, context));
    }

    public static boolean hasAbstractDecorator(@NotNull PyDecoratable element, @NotNull TypeEvalContext context) {
        List<KnownDecorator> knownDecorators;
        if (element == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(14);
        }
        if ((knownDecorators = PyKnownDecoratorUtil.getKnownDecorators(element, context)).isEmpty()) {
            return false;
        }
        knownDecorators.retainAll(ABSTRACT_DECORATORS);
        return !knownDecorators.isEmpty();
    }

    public static boolean isPropertyDecorator(@NotNull PyDecorator decorator, @NotNull TypeEvalContext context) {
        if (decorator == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(16);
        }
        return ContainerUtil.exists(PyKnownDecoratorUtil.asKnownDecorators(decorator, context), PROPERTY_DECORATORS::contains);
    }

    public static boolean hasGeneratorBasedCoroutineDecorator(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(18);
        }
        return ContainerUtil.exists(PyKnownDecoratorUtil.getKnownDecorators(function, context), GENERATOR_BASED_COROUTINE_DECORATORS::contains);
    }

    public static boolean isResolvedToGeneratorBasedCoroutine(@NotNull PyCallExpression receiver, @NotNull PyResolveContext resolveContext, @NotNull TypeEvalContext typeEvalContext) {
        if (receiver == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(19);
        }
        if (resolveContext == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(20);
        }
        if (typeEvalContext == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(21);
        }
        return StreamEx.of(receiver.multiResolveCalleeFunction(resolveContext)).select(PyFunction.class).anyMatch(function -> PyKnownDecoratorUtil.hasGeneratorBasedCoroutineDecorator(function, typeEvalContext));
    }

    public static boolean hasRedeclarationDecorator(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(23);
        }
        return PyKnownDecoratorUtil.getKnownDecorators(function, context).contains((Object)KnownDecorator.TYPING_OVERLOAD);
    }

    public static boolean hasUnknownOrChangingSignatureDecorator(@NotNull PyDecoratable decoratable, @NotNull TypeEvalContext context) {
        List<KnownDecorator> decorators;
        if (decoratable == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(25);
        }
        return !PyKnownDecoratorUtil.allDecoratorsAreKnown(decoratable, decorators = PyKnownDecoratorUtil.getKnownDecorators(decoratable, context)) || decorators.contains((Object)KnownDecorator.UNITTEST_MOCK_PATCH);
    }

    public static boolean hasUnknownOrChangingReturnTypeDecorator(@NotNull PyDecoratable decoratable, @NotNull TypeEvalContext context) {
        List<KnownDecorator> decorators;
        if (decoratable == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(27);
        }
        if (!PyKnownDecoratorUtil.allDecoratorsAreKnown(decoratable, decorators = PyKnownDecoratorUtil.getKnownDecorators(decoratable, context))) {
            return true;
        }
        return ContainerUtil.exists(decorators, d -> d == KnownDecorator.UNITTEST_MOCK_PATCH || d == KnownDecorator.CONTEXTLIB_CONTEXTMANAGER);
    }

    public static boolean hasUnknownOrUpdatingAttributesDecorator(@NotNull PyDecoratable decoratable, @NotNull TypeEvalContext context) {
        List<KnownDecorator> decorators;
        if (decoratable == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(28);
        }
        if (context == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(29);
        }
        if (!PyKnownDecoratorUtil.allDecoratorsAreKnown(decoratable, decorators = PyKnownDecoratorUtil.getKnownDecorators(decoratable, context))) {
            return true;
        }
        return ContainerUtil.exists(decorators, d -> d == KnownDecorator.FUNCTOOLS_LRU_CACHE || d == KnownDecorator.FUNCTOOLS_SINGLEDISPATCH);
    }

    private static boolean allDecoratorsAreKnown(@NotNull PyDecoratable element, @NotNull List<KnownDecorator> decorators) {
        PyDecoratorList decoratorList;
        if (element == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(30);
        }
        if (decorators == null) {
            PyKnownDecoratorUtil.$$$reportNull$$$0(31);
        }
        return (decoratorList = element.getDecoratorList()) == null ? decorators.isEmpty() : decoratorList.getDecorators().length == StreamEx.of(decorators).groupingBy(KnownDecorator::getShortName).size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 23: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyKnownDecoratorUtil";
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyKnownDecoratorUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownDecorators";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asKnownDecorators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKnownDecorators";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asKnownDecorators";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveDecorator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasUnknownDecorator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasAbstractDecorator";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyDecorator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasGeneratorBasedCoroutineDecorator";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedToGeneratorBasedCoroutine";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasRedeclarationDecorator";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasUnknownOrChangingSignatureDecorator";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasUnknownOrChangingReturnTypeDecorator";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasUnknownOrUpdatingAttributesDecorator";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "allDecoratorsAreKnown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum KnownDecorator {
        STATICMETHOD("staticmethod"),
        CLASSMETHOD("classmethod"),
        PROPERTY("property"),
        CONTEXTLIB_CONTEXTMANAGER("contextlib.contextmanager"),
        FUNCTOOLS_LRU_CACHE("functools.lru_cache"),
        FUNCTOOLS_WRAPS("functools.wraps"),
        FUNCTOOLS_TOTAL_ORDERING("functools.total_ordering"),
        FUNCTOOLS_SINGLEDISPATCH("functools.singledispatch"),
        ABC_ABSTRACTMETHOD("abc.abstractmethod"),
        ABC_ABSTRACTCLASSMETHOD("abc.abstractclassmethod"),
        ABC_ABSTRACTSTATICMETHOD("abc.abstractstaticmethod"),
        ABC_ABSTRACTPROPERTY("abc.abstractproperty"),
        ASYNCIO_TASKS_COROUTINE("asyncio.tasks.coroutine"),
        ASYNCIO_COROUTINES_COROUTINE("asyncio.coroutines.coroutine"),
        TYPES_COROUTINE("types.coroutine"),
        UNITTEST_SKIP("unittest.case.skip"),
        UNITTEST_SKIP_IF("unittest.case.skipIf"),
        UNITTEST_SKIP_UNLESS("unittest.case.skipUnless"),
        UNITTEST_EXPECTED_FAILURE("unittest.case.expectedFailure"),
        UNITTEST_MOCK_PATCH("unittest.mock.patch"),
        TYPING_OVERLOAD("typing.overload"),
        TYPING_RUNTIME("typing.runtime"),
        TYPING_RUNTIME_EXT("typing_extensions.runtime"),
        TYPING_RUNTIME_CHECKABLE("typing.runtime_checkable"),
        TYPING_RUNTIME_CHECKABLE_EXT("typing_extensions.runtime_checkable"),
        TYPING_FINAL("typing.final"),
        TYPING_FINAL_EXT("typing_extensions.final"),
        REPRLIB_RECURSIVE_REPR("reprlib.recursive_repr"),
        PYRAMID_DECORATOR_REIFY("pyramid.decorator.reify"),
        DJANGO_UTILS_FUNCTIONAL_CACHED_PROPERTY("django.utils.functional.cached_property"),
        KOMBU_UTILS_CACHED_PROPERTY("kombu.utils.cached_property"),
        DATACLASSES_DATACLASS("dataclasses.dataclass"),
        ATTR_S("attr.s"),
        ATTR_ATTRS("attr.attrs"),
        ATTR_ATTRIBUTES("attr.attributes"),
        ATTR_DATACLASS("attr.dataclass"),
        PYTEST_FIXTURE("pytest.fixture");

        private final QualifiedName myQualifiedName;

        private KnownDecorator(String qualifiedName) {
            if (qualifiedName == null) {
                KnownDecorator.$$$reportNull$$$0(0);
            }
            this.myQualifiedName = QualifiedName.fromDottedString((String)qualifiedName);
        }

        @NotNull
        public QualifiedName getQualifiedName() {
            QualifiedName qualifiedName = this.myQualifiedName;
            if (qualifiedName == null) {
                KnownDecorator.$$$reportNull$$$0(1);
            }
            return qualifiedName;
        }

        @NotNull
        public String getShortName() {
            String string = this.myQualifiedName.getLastComponent();
            if (string == null) {
                KnownDecorator.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/PyKnownDecoratorUtil$KnownDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/PyKnownDecoratorUtil$KnownDecorator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiedName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

