/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.ui;

import com.google.common.base.Preconditions;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.ui.PyMemberSelectionTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class PyMemberSelectionPanel
extends JPanel {
    private static final List<PyMemberInfo<PyElement>> EMPTY_MEMBER_INFO = Collections.emptyList();
    private final PyMemberSelectionTable myTable;
    private boolean myInitialized;

    public PyMemberSelectionPanel(@NotNull String title, boolean supportAbstract) {
        if (title == null) {
            PyMemberSelectionPanel.$$$reportNull$$$0(0);
        }
        this(title, EMPTY_MEMBER_INFO, null, supportAbstract);
    }

    public PyMemberSelectionPanel(String title, List<PyMemberInfo<PyElement>> memberInfo, MemberInfoModel<PyElement, PyMemberInfo<PyElement>> model, boolean supportAbstract) {
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)title, (boolean)false);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder((Border)titledBorder, emptyBorder);
        this.setBorder(border);
        this.setLayout(new BorderLayout());
        this.myTable = new PyMemberSelectionTable(memberInfo, model, supportAbstract);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable));
        this.add((Component)scrollPane, "Center");
    }

    public void init(@NotNull MemberInfoModel<PyElement, PyMemberInfo<PyElement>> memberInfoModel, @NotNull Collection<PyMemberInfo<PyElement>> members2) {
        if (memberInfoModel == null) {
            PyMemberSelectionPanel.$$$reportNull$$$0(1);
        }
        if (members2 == null) {
            PyMemberSelectionPanel.$$$reportNull$$$0(2);
        }
        Preconditions.checkState((!this.myInitialized ? 1 : 0) != 0, (Object)"Already myInitialized");
        this.myTable.setMemberInfos(members2);
        this.myTable.setMemberInfoModel(memberInfoModel);
        this.myTable.addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        this.myInitialized = true;
    }

    @NotNull
    public Collection<PyMemberInfo<PyElement>> getSelectedMemberInfos() {
        Preconditions.checkState((boolean)this.myInitialized, (Object)"Call #init first");
        Collection collection = this.myTable.getSelectedMemberInfos();
        if (collection == null) {
            PyMemberSelectionPanel.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public void redraw() {
        this.myTable.redraw();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMemberInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

