/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.target.value.TargetValue;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class DeferredTargetValue<T>
implements TargetValue<T> {
    private final AsyncPromise<T> myTargetPromise = new AsyncPromise();
    private final Promise<T> myLocalPromise;

    public DeferredTargetValue(T localValue) {
        this.myLocalPromise = Promises.resolvedPromise(localValue);
    }

    public void resolve(T valueToResolve) {
        if (this.myTargetPromise.isDone()) {
            throw new IllegalStateException("Target value is already resolved to '" + this.myTargetPromise.get() + "'");
        }
        this.myTargetPromise.setResult(valueToResolve);
    }

    @Override
    public Promise<T> getLocalValue() {
        return this.myLocalPromise;
    }

    @Override
    public Promise<T> getTargetValue() {
        return this.myTargetPromise;
    }
}

