/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.externalComponents;

import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalComponentManager {
    @NotNull
    public static ExternalComponentManager getInstance() {
        ExternalComponentManager externalComponentManager = (ExternalComponentManager)ServiceManager.getService(ExternalComponentManager.class);
        if (externalComponentManager == null) {
            ExternalComponentManager.$$$reportNull$$$0(0);
        }
        return externalComponentManager;
    }

    @NotNull
    public Iterable<ExternalComponentSource> getEnabledComponentSources(@NotNull UpdateSettings updateSettings) {
        if (updateSettings == null) {
            ExternalComponentManager.$$$reportNull$$$0(1);
        }
        this.refreshKnownSources(updateSettings);
        HashSet<String> enabledSources = new HashSet<String>(updateSettings.getEnabledExternalUpdateSources());
        LinkedList<ExternalComponentSource> res2 = new LinkedList<ExternalComponentSource>(ExternalComponentSource.EP_NAME.getExtensionList());
        res2.removeIf(source -> !enabledSources.contains(source.getName()));
        LinkedList<ExternalComponentSource> linkedList = res2;
        if (linkedList == null) {
            ExternalComponentManager.$$$reportNull$$$0(2);
        }
        return linkedList;
    }

    private void refreshKnownSources(@NotNull UpdateSettings updateSettings) {
        if (updateSettings == null) {
            ExternalComponentManager.$$$reportNull$$$0(3);
        }
        LinkedList<ExternalComponentSource> unknownSources = new LinkedList<ExternalComponentSource>(ExternalComponentSource.EP_NAME.getExtensionList());
        HashSet<String> knownSources = new HashSet<String>(updateSettings.getKnownExternalUpdateSources());
        unknownSources.removeIf(source -> knownSources.contains(source.getName()));
        for (ExternalComponentSource source2 : unknownSources) {
            updateSettings.getKnownExternalUpdateSources().add(source2.getName());
            updateSettings.getEnabledExternalUpdateSources().add(source2.getName());
            List<String> channels = source2.getAllChannels();
            if (channels == null) continue;
            updateSettings.getExternalUpdateChannels().put(source2.getName(), channels.get(0));
        }
    }

    @Nullable
    public UpdatableExternalComponent findExistingComponentMatching(@NotNull UpdatableExternalComponent update2, @NotNull ExternalComponentSource source) {
        if (update2 == null) {
            ExternalComponentManager.$$$reportNull$$$0(4);
        }
        if (source == null) {
            ExternalComponentManager.$$$reportNull$$$0(5);
        }
        Collection<UpdatableExternalComponent> existing = source.getCurrentVersions();
        for (UpdatableExternalComponent c : existing) {
            if (!update2.isUpdateFor(c)) continue;
            return c;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/externalComponents/ExternalComponentManager";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/externalComponents/ExternalComponentManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledComponentSources";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledComponentSources";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshKnownSources";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExistingComponentMatching";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

