/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.apache.lucene.util.automaton.Transition;

public class AutomatonTestUtil {
    public static final int DEFAULT_MAX_DETERMINIZED_STATES = 1000000;

    public static String randomRegexp(Random r) {
        while (true) {
            String regexp;
            if (!UnicodeUtil.validUTF16String((CharSequence)(regexp = AutomatonTestUtil.randomRegexpString(r)))) {
                continue;
            }
            try {
                new RegExp(regexp, 0);
                return regexp;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static String randomRegexpString(Random r) {
        int end = r.nextInt(20);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        for (int i = 0; i < end; ++i) {
            int t = r.nextInt(15);
            if (0 == t && i < end - 1) {
                buffer[i++] = (char)TestUtil.nextInt(r, 55296, 56319);
                buffer[i] = (char)TestUtil.nextInt(r, 56320, 57343);
                continue;
            }
            if (t <= 1) {
                buffer[i] = (char)r.nextInt(128);
                continue;
            }
            if (2 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 128, 2048);
                continue;
            }
            if (3 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 2048, 55295);
                continue;
            }
            if (4 == t) {
                buffer[i] = (char)TestUtil.nextInt(r, 57344, 65535);
                continue;
            }
            if (5 == t) {
                buffer[i] = 46;
                continue;
            }
            if (6 == t) {
                buffer[i] = 63;
                continue;
            }
            if (7 == t) {
                buffer[i] = 42;
                continue;
            }
            if (8 == t) {
                buffer[i] = 43;
                continue;
            }
            if (9 == t) {
                buffer[i] = 40;
                continue;
            }
            if (10 == t) {
                buffer[i] = 41;
                continue;
            }
            if (11 == t) {
                buffer[i] = 45;
                continue;
            }
            if (12 == t) {
                buffer[i] = 91;
                continue;
            }
            if (13 == t) {
                buffer[i] = 93;
                continue;
            }
            if (14 != t) continue;
            buffer[i] = 124;
        }
        return new String(buffer, 0, end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getRandomCodePoint(Random r, int min, int max) {
        int code;
        if (max < 55296 || min > 56319) {
            code = min + r.nextInt(max - min + 1);
        } else if (min >= 55296) {
            if (max <= 57343) throw new IllegalArgumentException("transition accepts only surrogates: min=" + min + " max=" + max);
            code = 57344 + r.nextInt(max - 57343);
        } else if (max <= 57343) {
            if (min >= 55296) throw new IllegalArgumentException("transition accepts only surrogates: min=" + min + " max=" + max);
            code = min + r.nextInt(55296 - min);
        } else {
            int gap1 = 55296 - min;
            int gap2 = max - 57343;
            int c = r.nextInt(gap1 + gap2);
            code = c < gap1 ? min + c : 57343 + c - gap1 + 1;
        }
        assert (code >= min && code <= max && (code < 55296 || code > 57343)) : "code=" + code + " min=" + min + " max=" + max;
        return code;
    }

    private static Automaton randomSingleAutomaton(Random random) {
        while (true) {
            try {
                Automaton a1 = new RegExp(AutomatonTestUtil.randomRegexp(random), 0).toAutomaton();
                if (random.nextBoolean()) {
                    a1 = Operations.complement((Automaton)a1, (int)1000000);
                }
                return a1;
            }
            catch (TooComplexToDeterminizeException tooComplexToDeterminizeException) {
                continue;
            }
            break;
        }
    }

    public static Automaton randomAutomaton(Random random) {
        Automaton a1 = AutomatonTestUtil.randomSingleAutomaton(random);
        Automaton a2 = AutomatonTestUtil.randomSingleAutomaton(random);
        switch (random.nextInt(4)) {
            case 0: {
                return Operations.concatenate((Automaton)a1, (Automaton)a2);
            }
            case 1: {
                return Operations.union((Automaton)a1, (Automaton)a2);
            }
            case 2: {
                return Operations.intersection((Automaton)a1, (Automaton)a2);
            }
        }
        return Operations.minus((Automaton)a1, (Automaton)a2, (int)1000000);
    }

    public static Automaton minimizeSimple(Automaton a) {
        HashSet<Integer> initialSet = new HashSet<Integer>();
        a = AutomatonTestUtil.determinizeSimple(Operations.reverse((Automaton)a, initialSet), initialSet);
        initialSet.clear();
        a = AutomatonTestUtil.determinizeSimple(Operations.reverse((Automaton)a, initialSet), initialSet);
        return a;
    }

    public static Automaton determinizeSimple(Automaton a) {
        HashSet<Integer> initialset = new HashSet<Integer>();
        initialset.add(0);
        return AutomatonTestUtil.determinizeSimple(a, initialset);
    }

    public static Automaton determinizeSimple(Automaton a, Set<Integer> initialset) {
        if (a.getNumStates() == 0) {
            return a;
        }
        int[] points = a.getStartPoints();
        HashMap<Set<Integer>, Set<Integer>> sets = new HashMap<Set<Integer>, Set<Integer>>();
        LinkedList<Set<Integer>> worklist = new LinkedList<Set<Integer>>();
        HashMap<Set<Integer>, Integer> newstate = new HashMap<Set<Integer>, Integer>();
        sets.put(initialset, initialset);
        worklist.add(initialset);
        Automaton.Builder result = new Automaton.Builder();
        result.createState();
        newstate.put(initialset, 0);
        Transition t = new Transition();
        while (worklist.size() > 0) {
            Set s = (Set)worklist.removeFirst();
            int r = (Integer)newstate.get(s);
            Iterator iterator = s.iterator();
            while (iterator.hasNext()) {
                int q = (Integer)iterator.next();
                if (!a.isAccept(q)) continue;
                result.setAccept(r, true);
                break;
            }
            for (int n = 0; n < points.length; ++n) {
                HashSet<Integer> p = new HashSet<Integer>();
                Iterator iterator2 = s.iterator();
                while (iterator2.hasNext()) {
                    int q = (Integer)iterator2.next();
                    int count = a.initTransition(q, t);
                    for (int i = 0; i < count; ++i) {
                        a.getNextTransition(t);
                        if (t.min > points[n] || points[n] > t.max) continue;
                        p.add(t.dest);
                    }
                }
                if (!sets.containsKey(p)) {
                    sets.put(p, p);
                    worklist.add(p);
                    newstate.put(p, result.createState());
                }
                int q = (Integer)newstate.get(p);
                int min = points[n];
                int max = n + 1 < points.length ? points[n + 1] - 1 : 0x10FFFF;
                result.addTransition(r, q, min, max);
            }
        }
        return Operations.removeDeadStates((Automaton)result.finish());
    }

    public static Set<IntsRef> getFiniteStringsRecursive(Automaton a, int limit) {
        HashSet<IntsRef> strings = new HashSet<IntsRef>();
        if (!AutomatonTestUtil.getFiniteStrings(a, 0, new HashSet<Integer>(), strings, new IntsRefBuilder(), limit)) {
            return strings;
        }
        return strings;
    }

    private static boolean getFiniteStrings(Automaton a, int s, HashSet<Integer> pathstates, HashSet<IntsRef> strings, IntsRefBuilder path, int limit) {
        pathstates.add(s);
        Transition t = new Transition();
        int count = a.initTransition(s, t);
        for (int i = 0; i < count; ++i) {
            a.getNextTransition(t);
            if (pathstates.contains(t.dest)) {
                return false;
            }
            for (int n = t.min; n <= t.max; ++n) {
                path.append(n);
                if (a.isAccept(t.dest)) {
                    strings.add(path.toIntsRef());
                    if (limit >= 0 && strings.size() > limit) {
                        return false;
                    }
                }
                if (!AutomatonTestUtil.getFiniteStrings(a, t.dest, pathstates, strings, path, limit)) {
                    return false;
                }
                path.setLength(path.length() - 1);
            }
        }
        pathstates.remove(s);
        return true;
    }

    public static boolean isFiniteSlow(Automaton a) {
        if (a.getNumStates() == 0) {
            return true;
        }
        return AutomatonTestUtil.isFiniteSlow(a, 0, new HashSet<Integer>());
    }

    private static boolean isFiniteSlow(Automaton a, int s, HashSet<Integer> path) {
        path.add(s);
        Transition t = new Transition();
        int count = a.initTransition(s, t);
        for (int i = 0; i < count; ++i) {
            a.getNextTransition(t);
            if (!path.contains(t.dest) && AutomatonTestUtil.isFiniteSlow(a, t.dest, path)) continue;
            return false;
        }
        path.remove(s);
        return true;
    }

    public static void assertNoDetachedStates(Automaton a) {
        Automaton a2 = Operations.removeDeadStates((Automaton)a);
        assert (a.getNumStates() == a2.getNumStates()) : "automaton has " + (a.getNumStates() - a2.getNumStates()) + " detached states";
    }

    public static boolean isDeterministicSlow(Automaton a) {
        Transition t = new Transition();
        int numStates = a.getNumStates();
        for (int s = 0; s < numStates; ++s) {
            int count = a.initTransition(s, t);
            int lastMax = -1;
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (t.min <= lastMax) {
                    assert (!a.isDeterministic());
                    return false;
                }
                lastMax = t.max;
            }
        }
        assert (a.isDeterministic());
        return true;
    }

    public static class RandomAcceptedStrings {
        private final Map<Transition, Boolean> leadsToAccept;
        private final Automaton a;
        private final Transition[][] transitions;

        public RandomAcceptedStrings(Automaton a) {
            int s;
            this.a = a;
            if (a.getNumStates() == 0) {
                throw new IllegalArgumentException("this automaton accepts nothing");
            }
            this.transitions = a.getSortedTransitions();
            this.leadsToAccept = new HashMap<Transition, Boolean>();
            HashMap<Integer, ArrayList<ArrivingTransition>> allArriving = new HashMap<Integer, ArrayList<ArrivingTransition>>();
            LinkedList<Integer> q = new LinkedList<Integer>();
            HashSet<Integer> seen = new HashSet<Integer>();
            int numStates = a.getNumStates();
            for (s = 0; s < numStates; ++s) {
                for (Transition t : this.transitions[s]) {
                    ArrayList<ArrivingTransition> tl = (ArrayList<ArrivingTransition>)allArriving.get(t.dest);
                    if (tl == null) {
                        tl = new ArrayList<ArrivingTransition>();
                        allArriving.put(t.dest, tl);
                    }
                    tl.add(new ArrivingTransition(s, t));
                }
                if (!a.isAccept(s)) continue;
                q.add(s);
                seen.add(s);
            }
            while (!q.isEmpty()) {
                s = (Integer)q.removeFirst();
                List arriving = (List)allArriving.get(s);
                if (arriving == null) continue;
                for (ArrivingTransition at : arriving) {
                    int from = at.from;
                    if (seen.contains(from)) continue;
                    q.add(from);
                    seen.add(from);
                    this.leadsToAccept.put(at.t, Boolean.TRUE);
                }
            }
        }

        public int[] getRandomAcceptedString(Random r) {
            int[] codePoints = new int[]{};
            int codepointCount = 0;
            int s = 0;
            while (!this.a.isAccept(s) || this.a.getNumTransitions(s) != 0 && !r.nextBoolean()) {
                Transition t;
                if (this.a.getNumTransitions(s) == 0) {
                    throw new RuntimeException("this automaton has dead states");
                }
                boolean cheat = r.nextBoolean();
                if (cheat) {
                    ArrayList<Transition> toAccept = new ArrayList<Transition>();
                    for (Transition t0 : this.transitions[s]) {
                        if (!this.leadsToAccept.containsKey(t0)) continue;
                        toAccept.add(t0);
                    }
                    t = toAccept.size() == 0 ? this.transitions[s][r.nextInt(this.transitions[s].length)] : (Transition)toAccept.get(r.nextInt(toAccept.size()));
                } else {
                    t = this.transitions[s][r.nextInt(this.transitions[s].length)];
                }
                codePoints = ArrayUtil.grow((int[])codePoints, (int)(codepointCount + 1));
                codePoints[codepointCount++] = AutomatonTestUtil.getRandomCodePoint(r, t.min, t.max);
                s = t.dest;
            }
            return ArrayUtil.copyOfSubArray((int[])codePoints, (int)0, (int)codepointCount);
        }

        private static class ArrivingTransition {
            final int from;
            final Transition t;

            public ArrivingTransition(int from, Transition t) {
                this.from = from;
                this.t = t;
            }
        }
    }
}

