/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum NamedGroup {
    SECT163K1(new byte[]{0, 1}, "sect163k1", 163),
    SECT163R1(new byte[]{0, 2}, "sect163r1", 163),
    SECT163R2(new byte[]{0, 3}, "sect163r2", 163),
    SECT193R1(new byte[]{0, 4}, "sect193r1", 193),
    SECT193R2(new byte[]{0, 5}, "sect193r2", 193),
    SECT233K1(new byte[]{0, 6}, "sect233k1", 233),
    SECT233R1(new byte[]{0, 7}, "sect233r1", 233),
    SECT239K1(new byte[]{0, 8}, "sect239k1", 239),
    SECT283K1(new byte[]{0, 9}, "sect283k1", 283),
    SECT283R1(new byte[]{0, 10}, "sect283r1", 283),
    SECT409K1(new byte[]{0, 11}, "sect409k1", 409),
    SECT409R1(new byte[]{0, 12}, "sect409r1", 409),
    SECT571K1(new byte[]{0, 13}, "sect571k1", 571),
    SECT571R1(new byte[]{0, 14}, "sect571r1", 571),
    SECP160K1(new byte[]{0, 15}, "secp160k1", 160),
    SECP160R1(new byte[]{0, 16}, "secp160r1", 160),
    SECP160R2(new byte[]{0, 17}, "secp160r2", 150),
    SECP192K1(new byte[]{0, 18}, "secp192k1", 192),
    SECP192R1(new byte[]{0, 19}, "secp192r1", 192),
    SECP224K1(new byte[]{0, 20}, "secp224k1", 224),
    SECP224R1(new byte[]{0, 21}, "secp224r1", 224),
    SECP256K1(new byte[]{0, 22}, "secp256k1", 256),
    SECP256R1(new byte[]{0, 23}, "secp256r1", 256),
    SECP384R1(new byte[]{0, 24}, "secp384r1", 384),
    SECP521R1(new byte[]{0, 25}, "secp521r1", 521),
    BRAINPOOLP256R1(new byte[]{0, 26}, "brainpoolp256r1", 256),
    BRAINPOOLP384R1(new byte[]{0, 27}, "brainpoolp384r1", 384),
    BRAINPOOLP512R1(new byte[]{0, 28}, "brainpoolp512r1", 512),
    ECDH_X25519(new byte[]{0, 29}, "ecdh_X25519", 256),
    ECDH_X448(new byte[]{0, 30}, "ecdh_X448", 448),
    FFDHE2048(new byte[]{1, 0}, "FFDHE2048", 2048),
    FFDHE3072(new byte[]{1, 1}, "FFDHE3072", 3072),
    FFDHE4096(new byte[]{1, 2}, "FFDHE4096", 4096),
    FFDHE6144(new byte[]{1, 3}, "FFDHE6144", 6144),
    FFDHE8192(new byte[]{1, 4}, "FFDHE8192", 8192),
    GREASE_00(new byte[]{10, 10}, "GREASE", null),
    GREASE_01(new byte[]{26, 26}, "GREASE", null),
    GREASE_02(new byte[]{42, 42}, "GREASE", null),
    GREASE_03(new byte[]{58, 58}, "GREASE", null),
    GREASE_04(new byte[]{74, 74}, "GREASE", null),
    GREASE_05(new byte[]{90, 90}, "GREASE", null),
    GREASE_06(new byte[]{106, 106}, "GREASE", null),
    GREASE_07(new byte[]{122, 122}, "GREASE", null),
    GREASE_08(new byte[]{-118, -118}, "GREASE", null),
    GREASE_09(new byte[]{-102, -102}, "GREASE", null),
    GREASE_10(new byte[]{-86, -86}, "GREASE", null),
    GREASE_11(new byte[]{-70, -70}, "GREASE", null),
    GREASE_12(new byte[]{-54, -54}, "GREASE", null),
    GREASE_13(new byte[]{-38, -38}, "GREASE", null),
    GREASE_14(new byte[]{-22, -22}, "GREASE", null),
    GREASE_15(new byte[]{-6, -6}, "GREASE", null);

    private static final Logger LOGGER;
    public static final int LENGTH = 2;
    private byte[] value;
    private String javaName;
    private final Integer coordinateSizeInBit;
    private static final Map<Integer, NamedGroup> MAP;
    private static final Set<NamedGroup> tls13Groups;

    private NamedGroup(byte[] value, String javaName, Integer coordinateSizeInBit) {
        this.value = value;
        this.javaName = javaName;
        this.coordinateSizeInBit = coordinateSizeInBit;
    }

    public static NamedGroup fromJavaName(String name) {
        if (name.equals("prime256v1")) {
            return SECP256R1;
        }
        for (NamedGroup group : NamedGroup.values()) {
            if (!group.getJavaName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    private static Integer valueToInt(byte[] value) {
        if (value.length < 2) {
            LOGGER.warn("Could not convert NamedGroup. Returning null");
            return null;
        }
        return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
    }

    public static NamedGroup getNamedGroup(byte[] value) {
        return MAP.get(NamedGroup.valueToInt(value));
    }

    public static NamedGroup getNamedGroup(ECPublicKey publicKey) {
        for (NamedGroup group : NamedGroup.getImplemented()) {
            if (!group.isCurve() || !group.isStandardCurve()) continue;
            try {
                EllipticCurve tlsAttackerCurve = CurveFactory.getCurve(group);
                if (!publicKey.getParams().getGenerator().getAffineX().equals(tlsAttackerCurve.getBasePoint().getX().getData()) || !publicKey.getParams().getGenerator().getAffineY().equals(tlsAttackerCurve.getBasePoint().getY().getData())) continue;
                return group;
            }
            catch (UnsupportedOperationException E) {
                LOGGER.debug("Could not test " + group.name() + " not completly integrated");
            }
        }
        return null;
    }

    public static NamedGroup getNamedGroup(ECPrivateKey privateKey) {
        for (NamedGroup group : NamedGroup.getImplemented()) {
            if (!group.isCurve() || !group.isStandardCurve()) continue;
            try {
                EllipticCurve tlsAttackerCurve = CurveFactory.getCurve(group);
                if (!privateKey.getParams().getGenerator().getAffineX().equals(tlsAttackerCurve.getBasePoint().getX().getData()) || !privateKey.getParams().getGenerator().getAffineY().equals(tlsAttackerCurve.getBasePoint().getY().getData())) continue;
                return group;
            }
            catch (UnsupportedOperationException E) {
                LOGGER.debug("Could not test " + group.name() + " not completly integrated");
            }
        }
        return null;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Integer getCoordinateSizeInBit() {
        return this.coordinateSizeInBit;
    }

    public static NamedGroup getRandom(Random random) {
        NamedGroup c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (NamedGroup)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    public Integer getIntValue() {
        return NamedGroup.valueToInt(this.value);
    }

    public static byte[] namedGroupsToByteArray(List<NamedGroup> groups) throws IOException {
        if (groups == null || groups.isEmpty()) {
            return new byte[0];
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bytes);
        os.writeObject(groups.toArray(new NamedGroup[groups.size()]));
        return bytes.toByteArray();
    }

    public static NamedGroup[] namedGroupsFromByteArray(byte[] sourceBytes) throws IOException, ClassNotFoundException {
        if (sourceBytes == null || sourceBytes.length == 0) {
            return new NamedGroup[0];
        }
        if (sourceBytes.length % 2 != 0) {
            throw new IllegalArgumentException("Failed to convert byte array. Source array size is not a multiple of destination type size.");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(sourceBytes);
        ObjectInputStream is = new ObjectInputStream(in);
        NamedGroup[] groups = (NamedGroup[])is.readObject();
        return groups;
    }

    public boolean isStandardCurve() {
        return this.isCurve() && this != ECDH_X25519 && this != ECDH_X448;
    }

    public boolean isCurve() {
        return this.name().toLowerCase().contains("ec") || this.name().toLowerCase().contains("brainpool");
    }

    public boolean isDhGroup() {
        return this.name().toLowerCase().contains("dhe");
    }

    public boolean isGrease() {
        return this.name().contains("GREASE");
    }

    public static List<NamedGroup> getImplemented() {
        LinkedList<NamedGroup> list = new LinkedList<NamedGroup>();
        list.add(SECP160K1);
        list.add(SECP160R1);
        list.add(SECP160R2);
        list.add(SECP192K1);
        list.add(SECP192R1);
        list.add(SECP224K1);
        list.add(SECP224R1);
        list.add(SECP256K1);
        list.add(SECP256R1);
        list.add(SECP384R1);
        list.add(SECP521R1);
        list.add(SECT163K1);
        list.add(SECT163R1);
        list.add(SECT163R2);
        list.add(SECT193R1);
        list.add(SECT193R2);
        list.add(SECT233K1);
        list.add(SECT233R1);
        list.add(SECT239K1);
        list.add(SECT283K1);
        list.add(SECT283R1);
        list.add(SECT409K1);
        list.add(SECT409R1);
        list.add(SECT571K1);
        list.add(SECT571R1);
        list.add(ECDH_X25519);
        list.add(ECDH_X448);
        list.add(BRAINPOOLP256R1);
        list.add(BRAINPOOLP384R1);
        list.add(BRAINPOOLP512R1);
        return list;
    }

    public boolean isTls13() {
        return tls13Groups.contains((Object)this);
    }

    public boolean isGost() {
        return this.name().contains("GOST");
    }

    static {
        LOGGER = LogManager.getLogger();
        tls13Groups = new HashSet<NamedGroup>(Arrays.asList(ECDH_X25519, ECDH_X448, FFDHE2048, FFDHE3072, FFDHE4096, FFDHE6144, FFDHE8192, SECP256R1, SECP384R1, SECP521R1));
        MAP = new HashMap<Integer, NamedGroup>();
        for (NamedGroup c : NamedGroup.values()) {
            MAP.put(NamedGroup.valueToInt(c.value), c);
        }
    }
}

