function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiBeacon } from '../beacon';
import { EuiButtonEmpty } from '../button';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiI18n } from '../i18n';
import { EuiPopover, EuiPopoverFooter, EuiPopoverTitle } from '../popover';
import { EuiTitle } from '../title';
import { EuiTourStepIndicator } from './tour_step_indicator';
export var EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
      anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
      children = _ref.children,
      className = _ref.className,
      _ref$closePopover = _ref.closePopover,
      closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
      content = _ref.content,
      _ref$isStepOpen = _ref.isStepOpen,
      isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
      _ref$minWidth = _ref.minWidth,
      minWidth = _ref$minWidth === void 0 ? true : _ref$minWidth,
      onFinish = _ref.onFinish,
      _ref$step = _ref.step,
      step = _ref$step === void 0 ? 1 : _ref$step,
      stepsTotal = _ref.stepsTotal,
      style = _ref.style,
      subtitle = _ref.subtitle,
      title = _ref.title,
      _ref$decoration = _ref.decoration,
      decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
      footerAction = _ref.footerAction,
      rest = _objectWithoutProperties(_ref, ["anchorPosition", "children", "className", "closePopover", "content", "isStepOpen", "minWidth", "onFinish", "step", "stepsTotal", "style", "subtitle", "title", "decoration", "footerAction"]);

  if (step === 0) {
    console.warn('EuiTourStep `step` should 1-based indexing. Please update to eliminate 0 indexes.');
  }

  var newStyle;
  var widthClassName;

  if (minWidth === true) {
    widthClassName = 'euiTour--minWidth-default';
  } else if (minWidth !== false) {
    var value = typeof minWidth === 'number' ? "".concat(minWidth, "px") : minWidth;
    newStyle = _objectSpread({}, style, {
      minWidth: value
    });
  }

  var classes = classNames('euiTour', widthClassName, className);
  var finishButtonProps = {
    color: 'text',
    flush: 'right',
    size: 'xs'
  };
  var footer = React.createElement(EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd'
  }, stepsTotal > 1 && React.createElement(EuiFlexItem, {
    grow: false
  }, React.createElement("ul", {
    className: "euiTourFooter__stepList"
  }, _toConsumableArray(Array(stepsTotal).keys()).map(function (_, i) {
    var status = 'complete';

    if (step === i + 1) {
      status = 'active';
    } else if (step <= i) {
      status = 'incomplete';
    }

    return React.createElement(EuiTourStepIndicator, {
      key: i,
      number: i + 1,
      status: status
    });
  }))), footerAction ? React.createElement(EuiFlexItem, {
    grow: false
  }, footerAction) : React.createElement(EuiFlexItem, {
    grow: false
  }, React.createElement(EuiI18n, {
    tokens: ['euiTourStep.endTour', 'euiTourStep.skipTour', 'euiTourStep.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 3),
        endTour = _ref3[0],
        skipTour = _ref3[1],
        closeTour = _ref3[2];

    var content = closeTour;

    if (stepsTotal > 1) {
      content = stepsTotal === step ? endTour : skipTour;
    }

    return React.createElement(EuiButtonEmpty, _extends({
      onClick: onFinish
    }, finishButtonProps), content);
  })));
  var hasBeacon = decoration === 'beacon';
  return React.createElement(EuiPopover, _extends({
    anchorPosition: anchorPosition,
    button: children,
    closePopover: closePopover,
    isOpen: isStepOpen,
    panelClassName: classes,
    panelStyle: newStyle || style,
    offset: hasBeacon ? 10 : 0,
    arrowChildren: hasBeacon && React.createElement(EuiBeacon, {
      className: "euiTour__beacon"
    }),
    withTitle: true
  }, rest), React.createElement(EuiPopoverTitle, {
    className: "euiTourHeader"
  }, React.createElement(EuiTitle, {
    size: "xxxs",
    className: "euiTourHeader__subtitle"
  }, React.createElement("h1", null, subtitle)), React.createElement(EuiTitle, {
    size: "xxs",
    className: "euiTourHeader__title"
  }, React.createElement("h2", null, title))), React.createElement("div", {
    className: "euiTour__content"
  }, content), React.createElement(EuiPopoverFooter, {
    className: "euiTourFooter"
  }, footer));
};
EuiTourStep.propTypes = {
  /**
     * Element to which the tour step popover attaches when open
     */
  children: PropTypes.element.isRequired,

  /**
     * Contents of the tour step popover
     */
  content: PropTypes.node.isRequired,

  /**
     * Step will display if set to `true`
     */
  isStepOpen: PropTypes.bool,

  /**
     * Sets the min-width of the tour popover,
     * set to `true` to use the default size,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  minWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),

  /**
     * Function to call for 'Skip tour' and 'End tour' actions
     */
  onFinish: PropTypes.func.isRequired,

  /**
     * The number of the step within the parent tour. 1-based indexing.
     */
  step: PropTypes.number.isRequired,

  /**
     * The total number of steps in the tour
     */
  stepsTotal: PropTypes.number.isRequired,

  /**
     * Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.
     */
  style: PropTypes.any,

  /**
     * Smaller title text that appears atop each step in the tour
     */
  subtitle: PropTypes.string.isRequired,

  /**
     * Larger title text specific to this step
     */
  title: PropTypes.string.isRequired,

  /**
     * Extra visual indication of step location
     */
  decoration: PropTypes.oneOf(["none", "beacon"]),

  /**
     * Element to replace the 'Skip tour' link in the footer
     */
  footerAction: PropTypes.element,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};
EuiTourStep.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiTourStep",
  "props": {
    "anchorPosition": {
      "defaultValue": {
        "value": "'leftUp'",
        "computed": false
      },
      "required": false
    },
    "closePopover": {
      "defaultValue": {
        "value": "() => {}",
        "computed": false
      },
      "required": false
    },
    "isStepOpen": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Step will display if set to `true`"
    },
    "minWidth": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "bool"
        }, {
          "name": "number"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": "Sets the min-width of the tour popover,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement."
    },
    "step": {
      "defaultValue": {
        "value": "1",
        "computed": false
      },
      "type": {
        "name": "number"
      },
      "required": false,
      "description": "The number of the step within the parent tour. 1-based indexing."
    },
    "decoration": {
      "defaultValue": {
        "value": "'beacon'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"beacon\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Extra visual indication of step location"
    },
    "children": {
      "type": {
        "name": "element"
      },
      "required": true,
      "description": "Element to which the tour step popover attaches when open"
    },
    "content": {
      "type": {
        "name": "node"
      },
      "required": true,
      "description": "Contents of the tour step popover"
    },
    "onFinish": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": "Function to call for 'Skip tour' and 'End tour' actions"
    },
    "stepsTotal": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": "The total number of steps in the tour"
    },
    "style": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Optional, standard DOM `style` attribute. Passed to the EuiPopover panel."
    },
    "subtitle": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": "Smaller title text that appears atop each step in the tour"
    },
    "title": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": "Larger title text specific to this step"
    },
    "footerAction": {
      "type": {
        "name": "element"
      },
      "required": false,
      "description": "Element to replace the 'Skip tour' link in the footer"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};