"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiOutsideClickDetector = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("react");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _accessibility = require("../../services/accessibility");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var EuiOutsideClickDetector =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiOutsideClickDetector, _Component);

  // We are working with the assumption that a click event is
  // equivalent to a sequential, compound press and release of
  // the pointing device (mouse, finger, stylus, etc.).
  // A click event's target can be imprecise, as the value will be
  // the closest common ancestor of the press (mousedown, touchstart)
  // and relase (mouseup, touchend) events (often <body />) if
  // the the target of each event differs.
  // We need the actual event targets to make the correct decisions
  // about user intention. So, consider the down/start and up/end
  // items below as the deconstruction of a click event.
  function EuiOutsideClickDetector(props) {
    var _this;

    (0, _classCallCheck2.default)(this, EuiOutsideClickDetector);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(EuiOutsideClickDetector).call(this, props)); // the id is used to identify which EuiOutsideClickDetector
    // is the source of a click event; as the click event bubbles
    // up and reaches the click detector's child component the
    // id value is stamped on the event. This id is inspected
    // in the document's click handler, and if the id doesn't
    // exist or doesn't match this detector's id, then trigger
    // the outsideClick callback.
    //
    // Taking this approach instead of checking if the event's
    // target element exists in this component's DOM sub-tree is
    // necessary for handling clicks originating from children
    // rendered through React's portals (EuiPortal). The id tracking
    // works because React guarantees the event bubbles through the
    // virtual DOM and executes EuiClickDetector's onClick handler,
    // stamping the id even though the event originates outside
    // this component's reified DOM tree.

    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "id", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "capturedDownIds", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClickOutside", function (event) {
      var _this$props = _this.props,
          isDisabled = _this$props.isDisabled,
          onOutsideClick = _this$props.onOutsideClick;

      if (isDisabled) {
        _this.capturedDownIds = [];
        return;
      }

      if (event.euiGeneratedBy && event.euiGeneratedBy.includes(_this.id) || _this.capturedDownIds.includes(_this.id)) {
        _this.capturedDownIds = [];
        return;
      }

      _this.capturedDownIds = [];
      return onOutsideClick(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChildClick", function (event, cb) {
      // to support nested click detectors, build an array
      // of detector ids that have been encountered
      if (event.nativeEvent.hasOwnProperty('euiGeneratedBy')) {
        event.nativeEvent.euiGeneratedBy.push(_this.id);
      } else {
        event.nativeEvent.euiGeneratedBy = [_this.id];
      }

      if (cb) cb(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChildMouseDown", function (event) {
      _this.onChildClick(event, function (e) {
        _this.capturedDownIds = e.nativeEvent.euiGeneratedBy;
        if (_this.props.onMouseDown) _this.props.onMouseDown(e);
        if (_this.props.onTouchStart) _this.props.onTouchStart(e);
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChildMouseUp", function (event) {
      _this.onChildClick(event, function (e) {
        if (_this.props.onMouseUp) _this.props.onMouseUp(e);
        if (_this.props.onTouchEnd) _this.props.onTouchEnd(e);
      });
    });
    _this.id = (0, _accessibility.htmlIdGenerator)()();
    _this.capturedDownIds = [];
    return _this;
  }

  (0, _createClass2.default)(EuiOutsideClickDetector, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.addEventListener('mouseup', this.onClickOutside);
      document.addEventListener('touchend', this.onClickOutside);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.removeEventListener('mouseup', this.onClickOutside);
      document.removeEventListener('touchend', this.onClickOutside);
    }
  }, {
    key: "render",
    value: function render() {
      var props = _objectSpread({}, this.props.children.props, {}, {
        onMouseDown: this.onChildMouseDown,
        onTouchStart: this.onChildMouseDown,
        onMouseUp: this.onChildMouseUp,
        onTouchEnd: this.onChildMouseUp
      });

      var child = _react.Children.only(this.props.children);

      return (0, _react.cloneElement)(child, props);
    }
  }]);
  return EuiOutsideClickDetector;
}(_react.Component);

exports.EuiOutsideClickDetector = EuiOutsideClickDetector;
EuiOutsideClickDetector.propTypes = {
  children: _propTypes.default.element.isRequired,
  onOutsideClick: _propTypes.default.func.isRequired,
  isDisabled: _propTypes.default.bool,
  onMouseDown: _propTypes.default.func,
  onMouseUp: _propTypes.default.func,
  onTouchStart: _propTypes.default.func,
  onTouchEnd: _propTypes.default.func
};
EuiOutsideClickDetector.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "onClickOutside",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onChildClick",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }, {
      "name": "cb",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onChildMouseDown",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onChildMouseUp",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiOutsideClickDetector",
  "props": {
    "children": {
      "type": {
        "name": "element"
      },
      "required": true,
      "description": ""
    },
    "onOutsideClick": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "isDisabled": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "onMouseDown": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onMouseUp": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onTouchStart": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onTouchEnd": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    }
  }
};