function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiIcon } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import React from 'react';
import { relativeToAbsolute } from '../../nav_links/to_nav_link';
export var isModifiedOrPrevented = function isModifiedOrPrevented(event) {
  return event.metaKey || event.altKey || event.ctrlKey || event.shiftKey || event.defaultPrevented;
};
// TODO #64541
// Set return type to EuiListGroupItemProps
// Currently it's a subset of EuiListGroupItemProps+FlyoutMenuItem for CollapsibleNav and NavDrawer
// But FlyoutMenuItem isn't exported from EUI
export function createEuiListItem(_ref) {
  var link = _ref.link,
      legacyMode = _ref.legacyMode,
      appId = _ref.appId,
      basePath = _ref.basePath,
      _ref$onClick = _ref.onClick,
      _onClick = _ref$onClick === void 0 ? function () {} : _ref$onClick,
      navigateToApp = _ref.navigateToApp,
      dataTestSubj = _ref.dataTestSubj,
      _ref$externalLink = _ref.externalLink,
      externalLink = _ref$externalLink === void 0 ? false : _ref$externalLink;

  var legacy = link.legacy,
      active = link.active,
      id = link.id,
      title = link.title,
      disabled = link.disabled,
      euiIconType = link.euiIconType,
      icon = link.icon,
      tooltip = link.tooltip,
      href = link.href;
  return _objectSpread({
    label: tooltip !== null && tooltip !== void 0 ? tooltip : title,
    href: href,

    /* Use href and onClick to support "open in new tab" and SPA navigation in the same link */
    onClick: function onClick(event) {
      if (!isModifiedOrPrevented(event)) {
        _onClick();
      }

      if (!externalLink && // ignore external links
      !legacyMode && // ignore when in legacy mode
      !legacy && // ignore links to legacy apps
      event.button === 0 && // ignore everything but left clicks
      !isModifiedOrPrevented(event)) {
        event.preventDefault();
        navigateToApp(id);
      }
    },
    // Legacy apps use `active` property, NP apps should match the current app
    isActive: active || appId === id,
    isDisabled: disabled,
    'data-test-subj': dataTestSubj
  }, basePath && {
    iconType: euiIconType,
    icon: !euiIconType && icon ? /*#__PURE__*/React.createElement(EuiIcon, {
      type: basePath.prepend("/".concat(icon)),
      size: "m"
    }) : undefined
  });
}

/**
 * Add saved object type info to recently links
 * TODO #64541 - set return type to EuiListGroupItemProps
 *
 * Recent nav links are similar to normal nav links but are missing some Kibana Platform magic and
 * because of legacy reasons have slightly different properties.
 * @param recentLink
 * @param navLinks
 * @param basePath
 */
export function createRecentNavLink(recentLink, navLinks, basePath) {
  var link = recentLink.link,
      label = recentLink.label;
  var href = relativeToAbsolute(basePath.prepend(link));
  var navLink = navLinks.find(function (nl) {
    var _nl$baseUrl;

    return href.startsWith((_nl$baseUrl = nl.baseUrl) !== null && _nl$baseUrl !== void 0 ? _nl$baseUrl : nl.subUrlBase);
  });
  var titleAndAriaLabel = label;

  if (navLink) {
    titleAndAriaLabel = i18n.translate('core.ui.recentLinks.linkItem.screenReaderLabel', {
      defaultMessage: '{recentlyAccessedItemLinklabel}, type: {pageType}',
      values: {
        recentlyAccessedItemLinklabel: label,
        pageType: navLink.title
      }
    });
  }

  return {
    href: href,
    label: label,
    title: titleAndAriaLabel,
    'aria-label': titleAndAriaLabel,
    iconType: navLink === null || navLink === void 0 ? void 0 : navLink.euiIconType
  };
}