function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import React, { Fragment, useState } from 'react';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiButton, EuiButtonEmpty, EuiFieldNumber, EuiFormRow, EuiCheckboxGroup, EuiModal, EuiModalBody, EuiModalFooter, EuiModalHeader, EuiModalHeaderTitle, EuiOverlayMask, EuiSwitch } from '@elastic/eui';
export function DevToolsSettingsModal(props) {
  var _useState = useState(props.settings.fontSize),
      _useState2 = _slicedToArray(_useState, 2),
      fontSize = _useState2[0],
      setFontSize = _useState2[1];

  var _useState3 = useState(props.settings.wrapMode),
      _useState4 = _slicedToArray(_useState3, 2),
      wrapMode = _useState4[0],
      setWrapMode = _useState4[1];

  var _useState5 = useState(props.settings.autocomplete.fields),
      _useState6 = _slicedToArray(_useState5, 2),
      fields = _useState6[0],
      setFields = _useState6[1];

  var _useState7 = useState(props.settings.autocomplete.indices),
      _useState8 = _slicedToArray(_useState7, 2),
      indices = _useState8[0],
      setIndices = _useState8[1];

  var _useState9 = useState(props.settings.autocomplete.templates),
      _useState10 = _slicedToArray(_useState9, 2),
      templates = _useState10[0],
      setTemplates = _useState10[1];

  var _useState11 = useState(props.settings.polling),
      _useState12 = _slicedToArray(_useState11, 2),
      polling = _useState12[0],
      setPolling = _useState12[1];

  var _useState13 = useState(props.settings.tripleQuotes),
      _useState14 = _slicedToArray(_useState13, 2),
      tripleQuotes = _useState14[0],
      setTripleQuotes = _useState14[1];

  var autoCompleteCheckboxes = [{
    id: 'fields',
    label: i18n.translate('console.settingsPage.fieldsLabelText', {
      defaultMessage: 'Fields'
    }),
    stateSetter: setFields
  }, {
    id: 'indices',
    label: i18n.translate('console.settingsPage.indicesAndAliasesLabelText', {
      defaultMessage: 'Indices & Aliases'
    }),
    stateSetter: setIndices
  }, {
    id: 'templates',
    label: i18n.translate('console.settingsPage.templatesLabelText', {
      defaultMessage: 'Templates'
    }),
    stateSetter: setTemplates
  }];
  var checkboxIdToSelectedMap = {
    fields: fields,
    indices: indices,
    templates: templates
  };

  var onAutocompleteChange = function onAutocompleteChange(optionId) {
    var option = _.find(autoCompleteCheckboxes, function (item) {
      return item.id === optionId;
    });

    if (option) {
      option.stateSetter(!checkboxIdToSelectedMap[optionId]);
    }
  };

  function saveSettings() {
    props.onSaveSettings({
      fontSize: fontSize,
      wrapMode: wrapMode,
      autocomplete: {
        fields: fields,
        indices: indices,
        templates: templates
      },
      polling: polling,
      tripleQuotes: tripleQuotes
    });
  } // It only makes sense to show polling options if the user needs to fetch any data.


  var pollingFields = fields || indices || templates ? /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFormRow, {
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "console.settingsPage.refreshingDataLabel",
      defaultMessage: "Refreshing autocomplete suggestions"
    }),
    helpText: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "console.settingsPage.refreshingDataDescription",
      defaultMessage: "Console refreshes autocomplete suggestions by querying Elasticsearch. Automatic refreshes may be an issue if you have a large cluster or if you have network limitations."
    })
  }, /*#__PURE__*/React.createElement(EuiSwitch, {
    checked: polling,
    "data-test-subj": "autocompletePolling",
    id: "autocompletePolling",
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      defaultMessage: "Automatically refresh autocomplete suggestions",
      id: "console.settingsPage.pollingLabelText"
    }),
    onChange: function onChange(e) {
      return setPolling(e.target.checked);
    }
  })), /*#__PURE__*/React.createElement(EuiButton, {
    "data-test-subj": "autocompletePolling",
    id: "autocompletePolling",
    onClick: function onClick() {
      // Only refresh the currently selected settings.
      props.refreshAutocompleteSettings({
        fields: fields,
        indices: indices,
        templates: templates
      });
    }
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    defaultMessage: "Refresh autocomplete suggestions",
    id: "console.settingsPage.refreshButtonLabel"
  }))) : undefined;
  return /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(EuiModal, {
    "data-test-subj": "devToolsSettingsModal",
    className: "conApp__settingsModal",
    onClose: props.onClose
  }, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.settingsPage.pageTitle",
    defaultMessage: "Console Settings"
  }))), /*#__PURE__*/React.createElement(EuiModalBody, null, /*#__PURE__*/React.createElement(EuiFormRow, {
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "console.settingsPage.fontSizeLabel",
      defaultMessage: "Font Size"
    })
  }, /*#__PURE__*/React.createElement(EuiFieldNumber, {
    autoFocus: true,
    "data-test-subj": "setting-font-size-input",
    value: fontSize,
    min: 6,
    max: 50,
    onChange: function onChange(e) {
      var val = parseInt(e.target.value, 10);
      if (!val) return;
      setFontSize(val);
    }
  })), /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiSwitch, {
    checked: wrapMode,
    "data-test-subj": "settingsWrapLines",
    id: "wrapLines",
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      defaultMessage: "Wrap long lines",
      id: "console.settingsPage.wrapLongLinesLabelText"
    }),
    onChange: function onChange(e) {
      return setWrapMode(e.target.checked);
    }
  })), /*#__PURE__*/React.createElement(EuiFormRow, {
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "console.settingsPage.jsonSyntaxLabel",
      defaultMessage: "JSON syntax"
    })
  }, /*#__PURE__*/React.createElement(EuiSwitch, {
    checked: tripleQuotes,
    "data-test-subj": "tripleQuotes",
    id: "tripleQuotes",
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      defaultMessage: "Use triple quotes in output pane",
      id: "console.settingsPage.tripleQuotesMessage"
    }),
    onChange: function onChange(e) {
      return setTripleQuotes(e.target.checked);
    }
  })), /*#__PURE__*/React.createElement(EuiFormRow, {
    labelType: "legend",
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "console.settingsPage.autocompleteLabel",
      defaultMessage: "Autocomplete"
    })
  }, /*#__PURE__*/React.createElement(EuiCheckboxGroup, {
    options: autoCompleteCheckboxes.map(function (opts) {
      var stateSetter = opts.stateSetter,
          rest = _objectWithoutProperties(opts, ["stateSetter"]);

      return rest;
    }),
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: function onChange(e) {
      onAutocompleteChange(e);
    }
  })), pollingFields), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    "data-test-subj": "settingsCancelButton",
    onClick: props.onClose
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.settingsPage.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/React.createElement(EuiButton, {
    fill: true,
    "data-test-subj": "settings-save-button",
    onClick: saveSettings
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.settingsPage.saveButtonLabel",
    defaultMessage: "Save"
  })))));
}