function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function detectCURLinLine(line) {
  // returns true if text matches a curl request
  return line.match(/^\s*?curl\s+(-X[A-Z]+)?\s*['"]?.*?['"]?(\s*$|\s+?-d\s*?['"])/);
}

export function detectCURL(text) {
  // returns true if text matches a curl request
  if (!text) return false;

  var _iterator = _createForOfIteratorHelper(text.split('\n')),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var line = _step.value;

      if (detectCURLinLine(line)) {
        return true;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return false;
}
export function parseCURL(text) {
  var state = 'NONE';
  var out = [];
  var body = [];
  var line = '';
  var lines = text.trim().split('\n');
  var matches;
  var EmptyLine = /^\s*$/;
  var Comment = /^\s*(?:#|\/{2,})(.*)\n?$/;
  var ExecutionComment = /^\s*#!/;
  var ClosingSingleQuote = /^([^']*)'/;
  var ClosingDoubleQuote = /^((?:[^\\"]|\\.)*)"/;
  var EscapedQuotes = /^((?:[^\\"']|\\.)+)/;
  var LooksLikeCurl = /^\s*curl\s+/;
  var CurlVerb = /-X ?(GET|HEAD|POST|PUT|DELETE)/;
  var HasProtocol = /[\s"']https?:\/\//;
  var CurlRequestWithProto = /[\s"']https?:\/\/[^\/ ]+\/+([^\s"']+)/;
  var CurlRequestWithoutProto = /[\s"'][^\/ ]+\/+([^\s"']+)/;
  var CurlData = /^.+\s(--data|-d)\s*/;
  var SenseLine = /^\s*(GET|HEAD|POST|PUT|DELETE)\s+\/?(.+)/;

  if (lines.length > 0 && ExecutionComment.test(lines[0])) {
    lines.shift();
  }

  function nextLine() {
    if (line.length > 0) {
      return true;
    }

    if (lines.length === 0) {
      return false;
    }

    line = lines.shift().replace(/[\r\n]+/g, '\n') + '\n';
    return true;
  }

  function unescapeLastBodyEl() {
    var str = body.pop().replace(/\\([\\"'])/g, '$1');
    body.push(str);
  } // Is the next char a single or double quote?
  // If so remove it


  function detectQuote() {
    if (line.substr(0, 1) === "'") {
      line = line.substr(1);
      state = 'SINGLE_QUOTE';
    } else if (line.substr(0, 1) === '"') {
      line = line.substr(1);
      state = 'DOUBLE_QUOTE';
    } else {
      state = 'UNQUOTED';
    }
  } // Body is finished - append to output with final LF


  function addBodyToOut() {
    if (body.length > 0) {
      out.push(body.join(''));
      body = [];
    }

    state = 'LF';
    out.push('\n');
  } // If the pattern matches, then the state is about to change,
  // so add the capture to the body and detect the next state
  // Otherwise add the whole line


  function consumeMatching(pattern) {
    var result = line.match(pattern);

    if (result) {
      body.push(result[1]);
      line = line.substr(result[0].length);
      detectQuote();
    } else {
      body.push(line);
      line = '';
    }
  }

  function parseCurlLine() {
    var verb = 'GET';
    var request = '';
    var result;

    if (result = line.match(CurlVerb)) {
      verb = result[1];
    } // JS regexen don't support possessive quantifiers, so
    // we need two distinct patterns


    var pattern = HasProtocol.test(line) ? CurlRequestWithProto : CurlRequestWithoutProto;

    if (result = line.match(pattern)) {
      request = result[1];
    }

    out.push(verb + ' /' + request + '\n');

    if (result = line.match(CurlData)) {
      line = line.substr(result[0].length);
      detectQuote();

      if (EmptyLine.test(line)) {
        line = '';
      }
    } else {
      state = 'NONE';
      line = '';
      out.push('');
    }
  }

  while (nextLine()) {
    if (state === 'SINGLE_QUOTE') {
      consumeMatching(ClosingSingleQuote);
    } else if (state === 'DOUBLE_QUOTE') {
      consumeMatching(ClosingDoubleQuote);
      unescapeLastBodyEl();
    } else if (state === 'UNQUOTED') {
      consumeMatching(EscapedQuotes);

      if (body.length) {
        unescapeLastBodyEl();
      }

      if (state === 'UNQUOTED') {
        addBodyToOut();
        line = '';
      }
    } // the BODY state (used to match the body of a Sense request)
    // can be terminated early if it encounters
    // a comment or an empty line
    else if (state === 'BODY') {
        if (Comment.test(line) || EmptyLine.test(line)) {
          addBodyToOut();
        } else {
          body.push(line);
          line = '';
        }
      } else if (EmptyLine.test(line)) {
        if (state !== 'LF') {
          out.push('\n');
          state = 'LF';
        }

        line = '';
      } else if (matches = line.match(Comment)) {
        out.push('#' + matches[1] + '\n');
        state = 'NONE';
        line = '';
      } else if (LooksLikeCurl.test(line)) {
        parseCurlLine();
      } else if (matches = line.match(SenseLine)) {
        out.push(matches[1] + ' /' + matches[2] + '\n');
        line = '';
        state = 'BODY';
      } // Nothing else matches, so output with a prefix of ### for debugging purposes
      else {
          out.push('### ' + line);
          line = '';
        }
  }

  addBodyToOut();
  return out.join('').trim();
}