function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IndexPatternCreationManager, IndexPatternCreationConfig } from './creation';
import { IndexPatternListManager, IndexPatternListConfig } from './list';
import { FieldFormatEditors } from './field_format_editors';
import { BytesFormatEditor, ColorFormatEditor, DateFormatEditor, DateNanosFormatEditor, DurationFormatEditor, NumberFormatEditor, PercentFormatEditor, StaticLookupFormatEditor, StringFormatEditor, TruncateFormatEditor, UrlFormatEditor } from '../components/field_editor/components/field_format_editor';

/**
 * Index patterns management service
 *
 * @internal
 */
export var IndexPatternManagementService = /*#__PURE__*/function () {
  function IndexPatternManagementService() {
    _classCallCheck(this, IndexPatternManagementService);

    _defineProperty(this, "indexPatternCreationManager", void 0);

    _defineProperty(this, "indexPatternListConfig", void 0);

    _defineProperty(this, "fieldFormatEditors", void 0);

    this.indexPatternCreationManager = new IndexPatternCreationManager();
    this.indexPatternListConfig = new IndexPatternListManager();
    this.fieldFormatEditors = new FieldFormatEditors();
  }

  _createClass(IndexPatternManagementService, [{
    key: "setup",
    value: function setup(_ref) {
      var httpClient = _ref.httpClient;
      var creationManagerSetup = this.indexPatternCreationManager.setup(httpClient);
      creationManagerSetup.addCreationConfig(IndexPatternCreationConfig);
      var indexPatternListConfigSetup = this.indexPatternListConfig.setup();
      indexPatternListConfigSetup.addListConfig(IndexPatternListConfig);
      var defaultFieldFormatEditors = [BytesFormatEditor, ColorFormatEditor, DateFormatEditor, DateNanosFormatEditor, DurationFormatEditor, NumberFormatEditor, PercentFormatEditor, StaticLookupFormatEditor, StringFormatEditor, TruncateFormatEditor, UrlFormatEditor];
      var fieldFormatEditorsSetup = this.fieldFormatEditors.setup(defaultFieldFormatEditors);
      return {
        creation: creationManagerSetup,
        list: indexPatternListConfigSetup,
        fieldFormatEditors: fieldFormatEditorsSetup
      };
    }
  }, {
    key: "start",
    value: function start() {
      return {
        creation: this.indexPatternCreationManager.start(),
        list: this.indexPatternListConfig.start(),
        fieldFormatEditors: this.fieldFormatEditors.start()
      };
    }
  }, {
    key: "stop",
    value: function stop() {// nothing to do here yet.
    }
  }]);

  return IndexPatternManagementService;
}();
/** @internal */