function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as React from 'react';
import { createReactOverlays } from '../overlays';
import { createNotifications } from '../notifications';
var useMemo = React.useMemo,
    useContext = React.useContext,
    createElement = React.createElement,
    createContext = React.createContext;
var defaultContextValue = {
  services: {},
  overlays: createReactOverlays({}),
  notifications: createNotifications({})
};
export var context = createContext(defaultContextValue);
export var useKibana = function useKibana() {
  return useContext(context);
};
export var withKibana = function withKibana(type) {
  var EnhancedType = function EnhancedType(props) {
    var kibana = useKibana();
    return /*#__PURE__*/React.createElement(type, _objectSpread(_objectSpread({}, props), {}, {
      kibana: kibana
    }));
  };

  return EnhancedType;
};
export var UseKibana = function UseKibana(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/React.createElement(React.Fragment, null, children(useKibana()));
};
export var createKibanaReactContext = function createKibanaReactContext(services) {
  var value = {
    services: services,
    overlays: createReactOverlays(services),
    notifications: createNotifications(services)
  };

  var Provider = function Provider(_ref2) {
    var _ref2$services = _ref2.services,
        newServices = _ref2$services === void 0 ? {} : _ref2$services,
        children = _ref2.children;
    var oldValue = useKibana();

    var _useMemo = useMemo(function () {
      return createKibanaReactContext(_objectSpread(_objectSpread(_objectSpread({}, services), oldValue.services), newServices));
    }, [services, oldValue, newServices]),
        newValue = _useMemo.value;

    return createElement(context.Provider, {
      value: newValue,
      children: children
    });
  };

  return {
    value: value,
    Provider: Provider,
    Consumer: context.Consumer
  };
};

var _createKibanaReactCon = createKibanaReactContext({}),
    KibanaContextProvider = _createKibanaReactCon.Provider;

export { KibanaContextProvider };