/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useContext } from 'react';
import { EuiFlyout, EuiFlyoutBody, EuiFlyoutHeader, EuiTitle, EuiLink, EuiFlyoutFooter, EuiFlexGroup, EuiFlexItem, EuiButtonEmpty, EuiText, EuiBadge, EuiHeaderAlert } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { NewsfeedContext } from './newsfeed_header_nav_button';
import { NewsEmptyPrompt } from './empty_news';
import { NewsLoadingPrompt } from './loading_news';
export var NewsfeedFlyout = function NewsfeedFlyout() {
  var _useContext = useContext(NewsfeedContext),
      newsFetchResult = _useContext.newsFetchResult,
      setFlyoutVisible = _useContext.setFlyoutVisible;

  var closeFlyout = useCallback(function () {
    return setFlyoutVisible(false);
  }, [setFlyoutVisible]);
  return /*#__PURE__*/React.createElement(EuiFlyout, {
    onClose: closeFlyout,
    size: "s",
    "aria-labelledby": "flyoutSmallTitle",
    className: "kbnNews__flyout",
    "data-test-subj": "NewsfeedFlyout"
  }, /*#__PURE__*/React.createElement(EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "s"
  }, /*#__PURE__*/React.createElement("h2", {
    id: "flyoutSmallTitle"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "newsfeed.flyoutList.whatsNewTitle",
    defaultMessage: "What's new at Elastic"
  })))), /*#__PURE__*/React.createElement(EuiFlyoutBody, {
    className: 'kbnNews__flyoutAlerts'
  }, !newsFetchResult ? /*#__PURE__*/React.createElement(NewsLoadingPrompt, null) : newsFetchResult.feedItems.length > 0 ? newsFetchResult.feedItems.map(function (item) {
    return /*#__PURE__*/React.createElement(EuiHeaderAlert, {
      key: item.hash,
      title: item.title,
      text: item.description,
      "data-test-subj": "newsHeadAlert",
      action: /*#__PURE__*/React.createElement(EuiLink, {
        target: "_blank",
        href: item.linkUrl,
        external: true
      }, item.linkText),
      date: item.publishOn.format('DD MMMM YYYY'),
      badge: item.badge ? /*#__PURE__*/React.createElement(EuiBadge, {
        color: "hollow"
      }, item.badge) : undefined
    });
  }) : /*#__PURE__*/React.createElement(NewsEmptyPrompt, null)), /*#__PURE__*/React.createElement(EuiFlyoutFooter, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "newsfeed.flyoutList.closeButtonLabel",
    defaultMessage: "Close"
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, newsFetchResult ? /*#__PURE__*/React.createElement(EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "newsfeed.flyoutList.versionTextLabel",
    defaultMessage: "{version}",
    values: {
      version: "Version\xA0".concat(newsFetchResult.kibanaVersion)
    }
  }))) : null))));
};