function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiPanel, EuiTitle, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { BasicOptions, SwitchOption } from '../../../../../charts/public';
import { GridPanel } from './grid_panel';
import { ThresholdPanel } from './threshold_panel';
import { ChartTypes } from '../../../utils/collections';

function PointSeriesOptions(props) {
  var stateParams = props.stateParams,
      _setValue = props.setValue,
      vis = props.vis;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.editors.pointSeries.settingsTitle",
    defaultMessage: "Settings"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(BasicOptions, props), vis.data.aggs.aggs.some(function (agg) {
    return agg.schema === 'segment' && agg.type.name === 'date_histogram';
  }) ? /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.editors.pointSeries.currentTimeMarkerLabel', {
      defaultMessage: 'Current time marker'
    }),
    paramName: "addTimeMarker",
    value: stateParams.addTimeMarker,
    setValue: _setValue
  }) : /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.editors.pointSeries.orderBucketsBySumLabel', {
      defaultMessage: 'Order buckets by sum'
    }),
    paramName: "orderBucketsBySum",
    value: stateParams.orderBucketsBySum,
    setValue: _setValue
  }), vis.type.name === ChartTypes.HISTOGRAM && /*#__PURE__*/React.createElement(SwitchOption, {
    "data-test-subj": "showValuesOnChart",
    label: i18n.translate('visTypeVislib.editors.pointSeries.showLabels', {
      defaultMessage: 'Show values on chart'
    }),
    paramName: "show",
    value: stateParams.labels.show,
    setValue: function setValue(paramName, value) {
      return _setValue('labels', _objectSpread(_objectSpread({}, stateParams.labels), {}, _defineProperty({}, paramName, value)));
    }
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(GridPanel, props), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), stateParams.thresholdLine && /*#__PURE__*/React.createElement(ThresholdPanel, props));
}

export { PointSeriesOptions };